/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.builder.right;

import com.bstek.ureport.Range;
import com.bstek.ureport.definition.BlankCellInfo;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.export.builder.right.TopParentCellCreator;
import com.bstek.ureport.parser.BuildUtils;
import java.util.List;
import java.util.Map;

public class RightCellbuilder {
    private TopParentCellCreator topParentCellCreator = new TopParentCellCreator();

    public void buildParentCell(CellDefinition cell, List<CellDefinition> cells) {
        List<Range> rangeList = this.topParentCellCreator.buildParentCells(cell);
        Range childRange = this.buildChildrenCells(cell, rangeList);
        this.buildChildrenBlankCells(cell, cells, childRange);
        Range colRange = this.buildColumnRange(rangeList);
        this.buildColumnsBlankCells(cell, cells, colRange);
        int start = colRange.getStart();
        int end = colRange.getEnd();
        int colNumberStart = cell.getColumnNumber();
        int colNumberEnd = cell.getColumnNumber();
        int colSpan = cell.getColSpan();
        if (colSpan > 0) {
            colNumberEnd += colSpan - 1;
        }
        int rangeStart = 0;
        int rangeEnd = 0;
        if (start != -1) {
            rangeStart = start - colNumberStart;
        }
        rangeEnd = end > colNumberStart && end > colNumberEnd ? end - colNumberStart : colNumberEnd - colNumberStart;
        Range duplicateRange = new Range(rangeStart, rangeEnd);
        cell.setDuplicateRange(duplicateRange);
    }

    private void buildColumnsBlankCells(CellDefinition cell, List<CellDefinition> cells, Range range) {
        Map<String, BlankCellInfo> blankCellNamesMap = cell.getNewBlankCellsMap();
        int start = range.getStart();
        int end = range.getEnd();
        int nextEnd = 0;
        int i = start;
        while (i <= end) {
            for (CellDefinition cellDef : cells) {
                int endColNumber;
                String name = cellDef.getName();
                if (this.cellPrcessed(cell, name)) continue;
                int colNumber = cellDef.getColumnNumber();
                if (colNumber == i) {
                    int offset = colNumber - cell.getColumnNumber();
                    blankCellNamesMap.put(name, new BlankCellInfo(offset, cellDef.getColSpan(), false));
                    continue;
                }
                if (colNumber >= i || (endColNumber = BuildUtils.buildColNumberEnd(cellDef, colNumber)) < i) continue;
                int offset = colNumber - cell.getColumnNumber();
                blankCellNamesMap.put(name, new BlankCellInfo(offset, cellDef.getColSpan(), false));
                if (i <= end || i <= nextEnd) continue;
                nextEnd = i;
            }
            ++i;
        }
        if (nextEnd > end) {
            this.buildColumnsBlankCells(cell, cells, new Range(end, nextEnd));
        }
    }

    private Range buildColumnRange(List<Range> rangeList) {
        Range colRange = new Range();
        for (Range range : rangeList) {
            int i = range.getStart();
            while (i <= range.getEnd()) {
                if (colRange.getStart() == -1 || i < colRange.getStart()) {
                    colRange.setStart(i);
                }
                if (colRange.getEnd() < i) {
                    colRange.setEnd(i);
                }
                ++i;
            }
        }
        return colRange;
    }

    private Range buildChildrenCells(CellDefinition cell, List<Range> rangeList) {
        Range range = new Range();
        List<CellDefinition> childrenCells = cell.getColumnChildrenCells();
        for (CellDefinition childCell : childrenCells) {
            cell.getNewCellNames().add(childCell.getName());
            int colNumber = childCell.getColumnNumber();
            int endColNumber = BuildUtils.buildColNumberEnd(childCell, colNumber);
            rangeList.add(new Range(colNumber, endColNumber));
            if (endColNumber > range.getEnd()) {
                range.setEnd(endColNumber);
            }
            if (range.getStart() != -1 && colNumber >= range.getStart()) continue;
            range.setStart(colNumber);
        }
        return range;
    }

    private void buildChildrenBlankCells(CellDefinition cell, List<CellDefinition> cells, Range childRange) {
        int startColNumber = cell.getColumnNumber();
        int endColNumber = BuildUtils.buildColNumberEnd(cell, startColNumber);
        int start = childRange.getStart();
        int end = childRange.getEnd();
        if (start != -1 && start < startColNumber) {
            startColNumber = start;
        }
        if (end > endColNumber) {
            endColNumber = end;
        }
        Map<String, BlankCellInfo> blankCellNamesMap = cell.getNewBlankCellsMap();
        int i = startColNumber;
        while (i <= endColNumber) {
            for (CellDefinition c : cells) {
                String name;
                boolean contain;
                if (c.getColumnNumber() != i || c.equals(cell) || (contain = this.cellPrcessed(cell, name = c.getName()))) continue;
                int offset = c.getColumnNumber() - cell.getColumnNumber();
                blankCellNamesMap.put(name, new BlankCellInfo(offset, c.getColSpan(), false));
            }
            ++i;
        }
    }

    private boolean cellPrcessed(CellDefinition cell, String name) {
        List<String> newCellNames = cell.getNewCellNames();
        List<String> increaseCellNames = cell.getIncreaseSpanCellNames();
        Map<String, BlankCellInfo> blankCellNamesMap = cell.getNewBlankCellsMap();
        boolean contain = false;
        if (cell.getName().equals(name)) {
            contain = true;
        }
        if (newCellNames.contains(name)) {
            contain = true;
        }
        if (increaseCellNames.contains(name)) {
            contain = true;
        }
        if (blankCellNamesMap.containsKey(name)) {
            contain = true;
        }
        return contain;
    }
}

