/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.excel;

import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.model.Cell;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class CellStyleContext {
    private Map<String, XSSFCellStyle> styleMap = new HashMap<String, XSSFCellStyle>();

    public XSSFCellStyle produceXSSFCellStyle(SXSSFWorkbook wb, Cell cell) {
        String name = cell.getName();
        if (cell.getCustomCellStyle() == null) {
            if (this.styleMap.containsKey(name)) {
                return this.styleMap.get(name);
            }
            XSSFCellStyle cellStyle = this.createNewCellStyle(wb, cell);
            this.styleMap.put(name, cellStyle);
            return cellStyle;
        }
        String styleId = String.valueOf(name) + "=>" + this.buildStyleId(cell);
        if (this.styleMap.containsKey(styleId)) {
            return this.styleMap.get(styleId);
        }
        XSSFCellStyle cellStyle = this.createNewCellStyle(wb, cell);
        this.styleMap.put(styleId, cellStyle);
        return cellStyle;
    }

    private XSSFCellStyle createNewCellStyle(SXSSFWorkbook wb, Cell cell) {
        CellStyle cellStyle = cell.getCellStyle();
        CellStyle customStyle = cell.getCustomCellStyle();
        CellStyle rowStyle = cell.getRow().getCustomCellStyle();
        CellStyle colStyle = cell.getColumn().getCustomCellStyle();
        XSSFCellStyle style = (XSSFCellStyle)wb.createCellStyle();
        style.setWrapText(true);
        String bgcolor = cellStyle.getBgcolor();
        if (customStyle != null && StringUtils.isNotBlank((CharSequence)customStyle.getBgcolor())) {
            bgcolor = customStyle.getBgcolor();
        }
        if (rowStyle != null && StringUtils.isNotBlank((CharSequence)rowStyle.getBgcolor())) {
            bgcolor = rowStyle.getBgcolor();
        }
        if (colStyle != null && StringUtils.isNotBlank((CharSequence)colStyle.getBgcolor())) {
            bgcolor = colStyle.getBgcolor();
        }
        if (StringUtils.isNotEmpty((CharSequence)bgcolor)) {
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(this.buildXSSFColor(bgcolor));
        }
        Border topBorder = cellStyle.getTopBorder();
        if (customStyle != null && customStyle.getTopBorder() != null) {
            topBorder = customStyle.getTopBorder();
        }
        if (topBorder != null) {
            BorderStyle borderStyle = this.getBorderStyle(topBorder);
            XSSFColor borderColor = this.buildXSSFColor(topBorder.getColor());
            style.setTopBorderColor(borderColor);
            style.setBorderTop(borderStyle);
        }
        Border bottomBorder = cellStyle.getBottomBorder();
        if (customStyle != null && customStyle.getBottomBorder() != null) {
            bottomBorder = customStyle.getBottomBorder();
        }
        if (bottomBorder != null) {
            BorderStyle borderStyle = this.getBorderStyle(bottomBorder);
            XSSFColor borderColor = this.buildXSSFColor(bottomBorder.getColor());
            style.setBottomBorderColor(borderColor);
            style.setBorderBottom(borderStyle);
        }
        Border leftBorder = cellStyle.getLeftBorder();
        if (customStyle != null && customStyle.getLeftBorder() != null) {
            leftBorder = customStyle.getLeftBorder();
        }
        if (leftBorder != null) {
            BorderStyle borderStyle = this.getBorderStyle(leftBorder);
            XSSFColor borderColor = this.buildXSSFColor(leftBorder.getColor());
            style.setLeftBorderColor(borderColor);
            style.setBorderLeft(borderStyle);
        }
        Border rightBorder = cellStyle.getRightBorder();
        if (customStyle != null && customStyle.getRightBorder() != null) {
            rightBorder = customStyle.getRightBorder();
        }
        if (rightBorder != null) {
            BorderStyle borderStyle = this.getBorderStyle(rightBorder);
            XSSFColor borderColor = this.buildXSSFColor(rightBorder.getColor());
            style.setRightBorderColor(borderColor);
            style.setBorderRight(borderStyle);
        }
        Alignment align = cellStyle.getAlign();
        if (customStyle != null && customStyle.getAlign() != null) {
            align = customStyle.getAlign();
        }
        if (rowStyle != null && rowStyle.getAlign() != null) {
            align = rowStyle.getAlign();
        }
        if (colStyle != null && colStyle.getAlign() != null) {
            align = colStyle.getAlign();
        }
        if (align != null) {
            if (align.equals((Object)Alignment.left)) {
                style.setAlignment(HorizontalAlignment.LEFT);
            } else if (align.equals((Object)Alignment.center)) {
                style.setAlignment(HorizontalAlignment.CENTER);
            } else if (align.equals((Object)Alignment.right)) {
                style.setAlignment(HorizontalAlignment.RIGHT);
            }
        }
        Alignment valign = cellStyle.getValign();
        if (customStyle != null && customStyle.getValign() != null) {
            valign = customStyle.getValign();
        }
        if (rowStyle != null && rowStyle.getValign() != null) {
            valign = rowStyle.getValign();
        }
        if (colStyle != null && colStyle.getValign() != null) {
            valign = colStyle.getValign();
        }
        if (valign != null) {
            if (valign.equals((Object)Alignment.top)) {
                style.setVerticalAlignment(VerticalAlignment.TOP);
            } else if (valign.equals((Object)Alignment.middle)) {
                style.setVerticalAlignment(VerticalAlignment.CENTER);
            } else if (valign.equals((Object)Alignment.bottom)) {
                style.setVerticalAlignment(VerticalAlignment.BOTTOM);
            }
        }
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setFontHeight((double)cellStyle.getFontSize());
        Boolean bold = cellStyle.getBold();
        if (customStyle != null && customStyle.getBold() != null) {
            bold = customStyle.getBold();
        }
        if (rowStyle != null && rowStyle.getBold() != null) {
            bold = rowStyle.getBold();
        }
        if (colStyle != null && colStyle.getBold() != null) {
            bold = colStyle.getBold();
        }
        if (bold != null) {
            font.setBold(bold.booleanValue());
        }
        Boolean italic = cellStyle.getItalic();
        if (customStyle != null && customStyle.getItalic() != null) {
            italic = customStyle.getItalic();
        }
        if (rowStyle != null && rowStyle.getItalic() != null) {
            italic = rowStyle.getItalic();
        }
        if (colStyle != null && colStyle.getItalic() != null) {
            italic = colStyle.getItalic();
        }
        if (italic != null) {
            font.setItalic(italic.booleanValue());
        }
        Boolean underline = cellStyle.getUnderline();
        if (customStyle != null && customStyle.getUnderline() != null) {
            underline = customStyle.getUnderline();
        }
        if (rowStyle != null && rowStyle.getUnderline() != null) {
            underline = rowStyle.getUnderline();
        }
        if (colStyle != null && colStyle.getUnderline() != null) {
            underline = colStyle.getUnderline();
        }
        if (underline != null && underline.booleanValue()) {
            font.setUnderline((byte)1);
        }
        String forecolor = cellStyle.getForecolor();
        if (customStyle != null && customStyle.getForecolor() != null) {
            forecolor = customStyle.getForecolor();
        }
        if (rowStyle != null && rowStyle.getForecolor() != null) {
            forecolor = rowStyle.getForecolor();
        }
        if (colStyle != null && colStyle.getForecolor() != null) {
            forecolor = colStyle.getForecolor();
        }
        if (StringUtils.isEmpty((CharSequence)forecolor)) {
            forecolor = "0,0,0";
        }
        font.setColor(this.buildXSSFColor(forecolor));
        String fontFamily = cellStyle.getFontFamily();
        if (customStyle != null && customStyle.getFontFamily() != null) {
            fontFamily = customStyle.getFontFamily();
        }
        if (rowStyle != null && rowStyle.getFontFamily() != null) {
            fontFamily = rowStyle.getFontFamily();
        }
        if (colStyle != null && colStyle.getFontFamily() != null) {
            fontFamily = colStyle.getFontFamily();
        }
        if (fontFamily != null) {
            font.setFontName(fontFamily);
        }
        style.setFont((Font)font);
        return style;
    }

    private BorderStyle getBorderStyle(Border border) {
        if (border.getStyle().equals((Object)com.bstek.ureport.definition.BorderStyle.solid)) {
            return BorderStyle.THIN;
        }
        if (border.getStyle().equals((Object)com.bstek.ureport.definition.BorderStyle.dashed)) {
            return BorderStyle.DASHED;
        }
        if (border.getStyle().equals((Object)com.bstek.ureport.definition.BorderStyle.doublesolid)) {
            return BorderStyle.DOUBLE;
        }
        return null;
    }

    private XSSFColor buildXSSFColor(String colorStr) {
        String[] color = colorStr.split(",");
        Color c = new Color(Integer.valueOf(color[0]), Integer.valueOf(color[1]), Integer.valueOf(color[2]));
        XSSFColor xssfColor = new XSSFColor(c);
        return xssfColor;
    }

    private String buildStyleId(Cell cell) {
        Border rightBorder;
        Border leftBorder;
        Border bottomBorder;
        Border topBorder;
        CellStyle customStyle = cell.getCustomCellStyle();
        CellStyle rowStyle = cell.getRow().getCustomCellStyle();
        CellStyle colStyle = cell.getColumn().getCustomCellStyle();
        StringBuffer sb = new StringBuffer();
        String bgcolor = customStyle.getBgcolor();
        if (rowStyle != null && StringUtils.isNotBlank((CharSequence)rowStyle.getBgcolor())) {
            bgcolor = rowStyle.getBgcolor();
        }
        if (colStyle != null && StringUtils.isNotBlank((CharSequence)colStyle.getBgcolor())) {
            bgcolor = colStyle.getBgcolor();
        }
        if (StringUtils.isNotEmpty((CharSequence)bgcolor)) {
            sb.append("bgcolor:" + bgcolor);
        }
        if ((topBorder = customStyle.getTopBorder()) != null) {
            sb.append("topborder:" + this.buildBorderStyleId(topBorder));
        }
        if ((bottomBorder = customStyle.getBottomBorder()) != null) {
            sb.append("bottomborder:" + this.buildBorderStyleId(bottomBorder));
        }
        if ((leftBorder = customStyle.getLeftBorder()) != null) {
            sb.append("leftborder:" + this.buildBorderStyleId(leftBorder));
        }
        if ((rightBorder = customStyle.getRightBorder()) != null) {
            sb.append("rightborder:" + this.buildBorderStyleId(rightBorder));
        }
        Alignment align = customStyle.getAlign();
        if (rowStyle != null && rowStyle.getAlign() != null) {
            align = rowStyle.getAlign();
        }
        if (colStyle != null && colStyle.getAlign() != null) {
            align = colStyle.getAlign();
        }
        if (align != null) {
            if (align.equals((Object)Alignment.left)) {
                sb.append("align:" + HorizontalAlignment.LEFT.name());
            } else if (align.equals((Object)Alignment.center)) {
                sb.append("align:" + HorizontalAlignment.CENTER.name());
            } else if (align.equals((Object)Alignment.right)) {
                sb.append("align:" + HorizontalAlignment.RIGHT.name());
            }
        }
        Alignment valign = customStyle.getValign();
        if (rowStyle != null && rowStyle.getValign() != null) {
            valign = rowStyle.getValign();
        }
        if (colStyle != null && colStyle.getValign() != null) {
            valign = colStyle.getValign();
        }
        if (valign != null) {
            if (valign.equals((Object)Alignment.top)) {
                sb.append("valign:" + VerticalAlignment.TOP.name());
            } else if (valign.equals((Object)Alignment.middle)) {
                sb.append("valign:" + VerticalAlignment.CENTER.name());
            } else if (valign.equals((Object)Alignment.bottom)) {
                sb.append("valign:" + VerticalAlignment.BOTTOM.name());
            }
        }
        Boolean underline = customStyle.getUnderline();
        if (rowStyle != null && rowStyle.getUnderline() != null) {
            underline = rowStyle.getUnderline();
        }
        if (colStyle != null && colStyle.getUnderline() != null) {
            underline = colStyle.getUnderline();
        }
        sb.append("underline:" + underline);
        Boolean bold = customStyle.getBold();
        if (rowStyle != null && rowStyle.getBold() != null) {
            bold = rowStyle.getBold();
        }
        if (colStyle != null && colStyle.getBold() != null) {
            bold = colStyle.getBold();
        }
        sb.append("bold:" + bold);
        Boolean italic = customStyle.getItalic();
        if (rowStyle != null && rowStyle.getItalic() != null) {
            italic = rowStyle.getItalic();
        }
        if (colStyle != null && colStyle.getItalic() != null) {
            italic = colStyle.getItalic();
        }
        sb.append("italic:" + italic);
        String forecolor = customStyle.getForecolor();
        if (rowStyle != null && rowStyle.getForecolor() != null) {
            forecolor = rowStyle.getForecolor();
        }
        if (colStyle != null && colStyle.getForecolor() != null) {
            forecolor = colStyle.getForecolor();
        }
        sb.append("forecolor:" + forecolor);
        String font = customStyle.getFontFamily();
        if (rowStyle != null && rowStyle.getFontFamily() != null) {
            font = rowStyle.getFontFamily();
        }
        if (colStyle != null && colStyle.getFontFamily() != null) {
            font = colStyle.getFontFamily();
        }
        sb.append("font:" + font);
        int fontSize = customStyle.getFontSize();
        if (rowStyle != null && rowStyle.getFontSize() > 0) {
            fontSize = rowStyle.getFontSize();
        }
        if (colStyle != null && colStyle.getFontSize() > 0) {
            fontSize = colStyle.getFontSize();
        }
        sb.append("font-size:" + fontSize);
        return sb.toString();
    }

    private String buildBorderStyleId(Border border) {
        StringBuilder sb = new StringBuilder();
        if (border.getStyle() != null) {
            sb.append("border-style:" + border.getStyle().name());
        }
        sb.append("border-color:" + border.getColor());
        sb.append("border-width:" + border.getWidth());
        return sb.toString();
    }
}

