/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.html;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Image;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlProducer {
    public String produce(Report report) {
        List<Row> rows = report.getRows();
        List<Column> columns = report.getColumns();
        Map<Row, Map<Column, Cell>> cellMap = report.getRowColCellMap();
        StringBuilder sb = this.buildTable(report.getContext(), rows, columns, cellMap, false, false);
        return sb.toString();
    }

    public String produce(Context context, List<Page> pages, int columnMargin, boolean breakPage) {
        int pageSize = pages.size();
        int singleTableWidth = this.buildTableWidth(pages.get(0).getColumns());
        int tableWidth = singleTableWidth * pageSize + columnMargin * (pageSize - 1);
        StringBuilder sb = new StringBuilder();
        if (breakPage) {
            sb.append("<table border='0' class='page-break' style='border-collapse:collapse;width:" + tableWidth + "pt'>");
        } else {
            sb.append("<table border='0' class='page-break' style='border-collapse:collapse;width:" + tableWidth + "pt'>");
        }
        sb.append("<tr>");
        int i = 0;
        while (i < pageSize) {
            if (i > 0) {
                sb.append("<td style='width:" + columnMargin + "pt'></td>");
            }
            Page page = pages.get(i);
            String table = this.produce(context, page, false);
            sb.append("<td style='width:" + singleTableWidth + "pt;vertical-align:top'>");
            sb.append(table);
            sb.append("</td>");
            ++i;
        }
        sb.append("</tr>");
        sb.append("</table>");
        return sb.toString();
    }

    public String produce(Context context, Page page, boolean breakPage) {
        List<Row> rows = page.getRows();
        List<Column> columns = page.getColumns();
        Map<Row, Map<Column, Cell>> cellMap = context.getReport().getRowColCellMap();
        StringBuilder sb = this.buildTable(context, rows, columns, cellMap, breakPage, true);
        return sb.toString();
    }

    private StringBuilder buildTable(Context context, List<Row> rows, List<Column> columns, Map<Row, Map<Column, Cell>> cellMap, boolean breakPage, boolean forPage) {
        StringBuilder sb = new StringBuilder();
        int tableWidth = this.buildTableWidth(columns);
        if (breakPage) {
            sb.append("<table class='page-break' border='0' style='border-collapse:collapse;width:" + tableWidth + "pt'>");
        } else {
            sb.append("<table border='0' style='border-collapse:collapse;width:" + tableWidth + "pt'>");
        }
        int colSize = columns.size();
        int rowSize = rows.size();
        int i = 0;
        while (i < rowSize) {
            int height;
            Row row = rows.get(i);
            if ((forPage || !row.isForPaging()) && (height = row.getRealHeight()) >= 1) {
                sb.append("<tr style=\"height:" + height + "pt\">");
                int j = 0;
                while (j < colSize) {
                    Map<Column, Cell> colMap;
                    Column col = columns.get(j);
                    Cell cell = null;
                    if (cellMap.containsKey(row) && (colMap = cellMap.get(row)).containsKey(col)) {
                        cell = colMap.get(col);
                    }
                    if (cell != null && (forPage || !cell.isForPaging())) {
                        Object obj;
                        int colSpan = cell.getColSpan();
                        int rowSpan = cell.getRowSpan();
                        if (forPage) {
                            rowSpan = cell.getPageRowSpan();
                        }
                        if (rowSpan > 0) {
                            if (colSpan > 0) {
                                sb.append("<td rowspan=\"" + rowSpan + "\" colspan=\"" + colSpan + "\"");
                            } else {
                                sb.append("<td rowspan=\"" + rowSpan + "\"");
                            }
                        } else if (colSpan > 0) {
                            sb.append("<td colspan=\"" + colSpan + "\"");
                        } else {
                            sb.append("<td");
                        }
                        sb.append(" class='_" + cell.getName() + "' ");
                        String style = this.buildCustomStyle(cell);
                        sb.append(" " + style);
                        sb.append(">");
                        boolean hasLink = false;
                        String linkURL = cell.getLinkUrl();
                        if (StringUtils.isNotBlank((CharSequence)linkURL)) {
                            hasLink = true;
                            String urlParameter = cell.buildLinkParameters(context);
                            linkURL = linkURL.indexOf("?") == -1 ? String.valueOf(linkURL) + "?" + urlParameter : String.valueOf(linkURL) + "&" + urlParameter;
                            String target = cell.getLinkTargetWindow();
                            if (StringUtils.isBlank((CharSequence)target)) {
                                target = "_self";
                            }
                            sb.append("<a href=\"" + linkURL + "\" target=\"" + target + "\">");
                        }
                        Object object = obj = cell.getData() == null ? "&nbsp;" : cell.getData();
                        if (obj instanceof Image) {
                            Image img = (Image)obj;
                            String path = img.getPath();
                            String imageType = "image/png";
                            if (StringUtils.isNotBlank((CharSequence)path)) {
                                if ((path = path.toLowerCase()).endsWith(".jpg") || path.endsWith(".jpeg")) {
                                    imageType = "image/jpeg";
                                } else if (path.endsWith(".gif")) {
                                    imageType = "image/gif";
                                }
                            }
                            sb.append("<img src=\"data:" + imageType + ";base64," + img.getBase64Data() + "\"");
                            sb.append(">");
                        } else {
                            String text = obj.toString();
                            text = text.replaceAll("\r\n", "<br>");
                            text = text.replaceAll("\n", "<br>");
                            sb.append(text);
                        }
                        if (hasLink) {
                            sb.append("</a>");
                        }
                        sb.append("</td>");
                    }
                    ++j;
                }
                sb.append("</tr>");
            }
            ++i;
        }
        sb.append("</table>");
        return sb;
    }

    private String buildCustomStyle(Cell cell) {
        CellStyle style = cell.getCustomCellStyle();
        CellStyle rowStyle = cell.getRow().getCustomCellStyle();
        CellStyle colStyle = cell.getColumn().getCustomCellStyle();
        if (style == null && rowStyle == null && colStyle == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String forecolor = null;
        if (style != null) {
            forecolor = style.getForecolor();
        }
        if (rowStyle != null) {
            forecolor = rowStyle.getForecolor();
        }
        if (colStyle != null) {
            forecolor = colStyle.getForecolor();
        }
        if (StringUtils.isNotBlank((CharSequence)forecolor)) {
            sb.append("color:rgb(" + forecolor + ");");
        }
        String bgcolor = null;
        if (style != null) {
            bgcolor = style.getBgcolor();
        }
        if (rowStyle != null) {
            bgcolor = rowStyle.getBgcolor();
        }
        if (colStyle != null) {
            bgcolor = colStyle.getBgcolor();
        }
        if (StringUtils.isNotBlank((CharSequence)bgcolor)) {
            sb.append("background-color:rgb(" + bgcolor + ");");
        }
        String fontFamily = null;
        if (style != null) {
            fontFamily = style.getFontFamily();
        }
        if (rowStyle != null) {
            fontFamily = rowStyle.getFontFamily();
        }
        if (colStyle != null) {
            fontFamily = colStyle.getFontFamily();
        }
        if (StringUtils.isNotBlank((CharSequence)fontFamily)) {
            sb.append("font-family:" + fontFamily + ";");
        }
        int fontSize = 0;
        if (style != null) {
            fontSize = style.getFontSize();
        }
        if (rowStyle != null) {
            fontSize = rowStyle.getFontSize();
        }
        if (colStyle != null) {
            fontSize = colStyle.getFontSize();
        }
        if (fontSize > 0) {
            sb.append("font-size:" + fontSize + "pt;");
        }
        Boolean bold = null;
        if (style != null) {
            bold = style.getBold();
        }
        if (rowStyle != null) {
            bold = rowStyle.getBold();
        }
        if (colStyle != null) {
            bold = colStyle.getBold();
        }
        if (bold != null) {
            if (bold.booleanValue()) {
                sb.append("font-weight:bold;");
            } else {
                sb.append("font-weight:normal;");
            }
        }
        Boolean italic = null;
        if (style != null) {
            italic = style.getItalic();
        }
        if (rowStyle != null) {
            italic = rowStyle.getItalic();
        }
        if (colStyle != null) {
            italic = colStyle.getItalic();
        }
        if (italic != null) {
            if (italic.booleanValue()) {
                sb.append("font-style:italic;");
            } else {
                sb.append("font-style:normal;");
            }
        }
        Boolean underline = null;
        if (style != null) {
            underline = style.getUnderline();
        }
        if (rowStyle != null) {
            underline = rowStyle.getUnderline();
        }
        if (colStyle != null) {
            underline = colStyle.getUnderline();
        }
        if (underline != null) {
            if (underline.booleanValue()) {
                sb.append("text-decoration:underline;");
            } else {
                sb.append("text-decoration:none;");
            }
        }
        Alignment align = null;
        if (style != null) {
            align = style.getAlign();
        }
        if (rowStyle != null) {
            align = rowStyle.getAlign();
        }
        if (colStyle != null) {
            align = colStyle.getAlign();
        }
        if (align != null) {
            sb.append("text-align:" + align.name() + ";");
        }
        Alignment valign = null;
        if (style != null) {
            valign = style.getValign();
        }
        if (rowStyle != null) {
            valign = rowStyle.getValign();
        }
        if (colStyle != null) {
            valign = colStyle.getValign();
        }
        if (valign != null) {
            sb.append("vertical-align:" + valign.name() + ";");
        }
        Border border = null;
        if (style != null) {
            border = style.getLeftBorder();
        }
        if (border != null) {
            sb.append("border-left:" + border.getStyle().name() + " " + border.getWidth() + "px rgb(" + border.getColor() + ");");
        }
        Border rightBorder = null;
        if (style != null) {
            rightBorder = style.getRightBorder();
        }
        if (rightBorder != null) {
            sb.append("border-right:" + rightBorder.getStyle().name() + " " + rightBorder.getWidth() + "px rgb(" + rightBorder.getColor() + ");");
        }
        Border topBorder = null;
        if (style != null) {
            topBorder = style.getTopBorder();
        }
        if (topBorder != null) {
            sb.append("border-top:" + topBorder.getStyle().name() + " " + topBorder.getWidth() + "px rgb(" + topBorder.getColor() + ");");
        }
        Border bottomBorder = null;
        if (style != null) {
            bottomBorder = style.getBottomBorder();
        }
        if (bottomBorder != null) {
            sb.append("border-bottom:" + bottomBorder.getStyle().name() + " " + bottomBorder.getWidth() + "px rgb(" + bottomBorder.getColor() + ");");
        }
        if (sb.length() > 0) {
            sb.insert(0, "style=\"");
            sb.append("\"");
        }
        return sb.toString();
    }

    private int buildTableWidth(List<Column> columns) {
        int width = 0;
        for (Column col : columns) {
            width += col.getWidth();
        }
        return width;
    }
}

