/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.pdf.font;

import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.export.pdf.font.FontRegister;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FontBuilder
implements ApplicationContextAware {
    private static final Map<String, BaseFont> fontMap = new HashMap<String, BaseFont>();

    public static Font getFont(String fontName, int fontSize, boolean fontBold, boolean fontItalic, boolean underLine) {
        BaseFont baseFont = fontMap.get(fontName);
        Font font = null;
        font = baseFont != null ? new Font(baseFont) : FontFactory.getFont((String)fontName);
        font.setSize((float)fontSize);
        int fontStyle = 0;
        if (fontBold && fontItalic && underLine) {
            fontStyle = 7;
        } else if (fontBold) {
            fontStyle = fontItalic ? 3 : (underLine ? 5 : 1);
        } else if (fontItalic) {
            fontStyle = underLine ? 6 : (fontBold ? 3 : 2);
        } else if (underLine) {
            fontStyle = 4;
        }
        font.setStyle(fontStyle);
        return font;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection fontRegisters = applicationContext.getBeansOfType(FontRegister.class).values();
        for (FontRegister fontReg : fontRegisters) {
            String fontName = fontReg.getFontName();
            String fontPath = fontReg.getFontPath();
            if (StringUtils.isEmpty((CharSequence)fontPath) || StringUtils.isEmpty((CharSequence)fontName)) continue;
            try {
                BaseFont baseFont = this.getIdentityFont(fontPath, applicationContext);
                if (baseFont == null) {
                    throw new ReportComputeException("Font " + fontPath + " does not exist");
                }
                fontMap.put(fontName, baseFont);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ReportComputeException(e);
            }
        }
    }

    private BaseFont getIdentityFont(String fontPath, ApplicationContext applicationContext) throws DocumentException, IOException {
        if (!fontPath.startsWith("classpath:")) {
            fontPath = "classpath:" + fontPath;
        }
        String fontName = fontPath;
        int lastSlashPos = fontPath.lastIndexOf("/");
        if (lastSlashPos != -1) {
            fontName = fontPath.substring(lastSlashPos + 1, fontPath.length());
        }
        if (fontName.toLowerCase().endsWith(".ttc")) {
            fontName = String.valueOf(fontName) + ",0";
        }
        try (InputStream inputStream = null;){
            inputStream = applicationContext.getResource(fontPath).getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            BaseFont baseFont = BaseFont.createFont((String)fontName, (String)"Identity-H", (boolean)true, (boolean)true, (byte[])bytes, null);
            baseFont.setSubset(true);
            BaseFont baseFont2 = baseFont;
            return baseFont2;
        }
    }
}

