/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.word;

import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.BorderStyle;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.export.Producer;
import com.bstek.ureport.export.word.DxaUtils;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Image;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import com.bstek.ureport.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColumns;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPageOrientation;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class WordProducer
implements Producer {
    public static final String BEAN_ID = "ureport.wordExporter";

    @Override
    public void produce(Report report, OutputStream outputStream) {
        XWPFDocument document = new XWPFDocument();
        try {
            try {
                CTSectPr sectpr = document.getDocument().getBody().addNewSectPr();
                if (!sectpr.isSetPgSz()) {
                    sectpr.addNewPgSz();
                }
                CTPageSz pageSize = sectpr.getPgSz();
                Paper paper = report.getPaper();
                Orientation orientation = paper.getOrientation();
                if (orientation.equals((Object)Orientation.landscape)) {
                    pageSize.setOrient(STPageOrientation.LANDSCAPE);
                    pageSize.setH(BigInteger.valueOf(DxaUtils.points2dxa(paper.getWidth())));
                    pageSize.setW(BigInteger.valueOf(DxaUtils.points2dxa(paper.getHeight())));
                } else {
                    pageSize.setOrient(STPageOrientation.PORTRAIT);
                    pageSize.setW(BigInteger.valueOf(DxaUtils.points2dxa(paper.getWidth())));
                    pageSize.setH(BigInteger.valueOf(DxaUtils.points2dxa(paper.getHeight())));
                }
                int columnCount = paper.getColumnCount();
                if (paper.isColumnEnabled() && columnCount > 0) {
                    CTColumns cols = CTColumns.Factory.newInstance();
                    cols.setNum(new BigInteger(String.valueOf(columnCount)));
                    int columnMargin = paper.getColumnMargin();
                    cols.setSpace(new BigInteger(String.valueOf(DxaUtils.points2dxa(columnMargin))));
                    sectpr.setCols(cols);
                }
                CTPageMar pageMar = sectpr.addNewPgMar();
                pageMar.setLeft(BigInteger.valueOf(DxaUtils.points2dxa(paper.getLeftMargin())));
                pageMar.setRight(BigInteger.valueOf(DxaUtils.points2dxa(paper.getRightMargin())));
                pageMar.setTop(BigInteger.valueOf(DxaUtils.points2dxa(paper.getTopMargin())));
                pageMar.setBottom(BigInteger.valueOf(DxaUtils.points2dxa(paper.getBottomMargin())));
                List<Column> columns = report.getColumns();
                int totalColumn = this.buildColumnSize(columns);
                int tableWidth = this.buildTablePCTWidth(columns);
                List<Page> pages = report.getPages();
                Map<Row, Map<Column, Cell>> cellMap = report.getRowColCellMap();
                for (Page page : pages) {
                    List<Row> rows = page.getRows();
                    XWPFTable table = document.createTable(rows.size(), totalColumn);
                    table.getCTTbl().getTblPr().unsetTblBorders();
                    table.getCTTbl().addNewTblPr().addNewTblW().setW(BigInteger.valueOf(DxaUtils.points2dxa(tableWidth)));
                    for (Row row : rows) {
                        int height = row.getRealHeight();
                        int rowNumber = rows.indexOf(row);
                        XWPFTableRow tableRow = table.getRow(rowNumber);
                        tableRow.setHeight(DxaUtils.points2dxa(height));
                        Map<Column, Cell> colCell = cellMap.get(row);
                        for (Column col : columns) {
                            XWPFTableCell tableCell;
                            int width = col.getWidth();
                            if (width < 1) continue;
                            int colNumber = col.getColumnNumber() - 1;
                            Cell cell = colCell.get(col);
                            if (cell == null || (tableCell = tableRow.getCell(colNumber)) == null) continue;
                            tableCell.getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(DxaUtils.points2dxa(width)));
                            this.buildTableCellStyle(table, tableCell, cell, rowNumber, colNumber);
                        }
                    }
                }
                document.write(outputStream);
            }
            catch (Exception ex) {
                throw new ReportComputeException(ex);
            }
        }
        finally {
            try {
                document.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private int buildColumnSize(List<Column> columns) {
        int count = 0;
        int i = 0;
        while (i < columns.size()) {
            Column col = columns.get(i);
            int width = col.getWidth();
            if (width >= 1) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private void buildTableCellStyle(XWPFTable table, XWPFTableCell tableCell, Cell cell, int rowNumber, int columnNumber) {
        int i;
        int startRow;
        boolean underline;
        boolean italic;
        boolean bold;
        XWPFRun run;
        XWPFParagraph para;
        int colSpan;
        int rowSpan;
        CTTcPr cellProperties;
        CellStyle colStyle;
        CellStyle rowStyle;
        CellStyle customStyle;
        CellStyle style;
        block103: {
            XWPFTableCell c;
            int end;
            XWPFTableCell c2;
            int i2;
            int start;
            style = cell.getCellStyle();
            customStyle = cell.getCustomCellStyle();
            rowStyle = cell.getRow().getCustomCellStyle();
            colStyle = cell.getColumn().getCustomCellStyle();
            cellProperties = tableCell.getCTTc().addNewTcPr();
            Border leftBorder = style.getLeftBorder();
            Border rightBorder = style.getRightBorder();
            Border topBorder = style.getTopBorder();
            Border bottomBorder = style.getBottomBorder();
            if (customStyle != null) {
                if (customStyle.getLeftBorder() != null) {
                    leftBorder = customStyle.getLeftBorder();
                }
                if (customStyle.getRightBorder() != null) {
                    rightBorder = customStyle.getRightBorder();
                }
                if (customStyle.getTopBorder() != null) {
                    topBorder = customStyle.getTopBorder();
                }
                if (customStyle.getBottomBorder() != null) {
                    bottomBorder = customStyle.getBottomBorder();
                }
            }
            rowSpan = cell.getPageRowSpan();
            colSpan = cell.getColSpan();
            if (style.getLeftBorder() != null) {
                if (rowSpan > 0) {
                    start = rowNumber;
                    int end2 = start + rowSpan;
                    i2 = start;
                    while (i2 < end2) {
                        c2 = table.getRow(i2).getCell(columnNumber);
                        this.buildCellBorder(leftBorder, c2, 1);
                        ++i2;
                    }
                } else {
                    this.buildCellBorder(leftBorder, tableCell, 1);
                }
            }
            if (rightBorder != null) {
                int lastCol = columnNumber;
                if (colSpan > 0) {
                    lastCol += colSpan - 1;
                }
                if (rowSpan > 0) {
                    int start2 = rowNumber;
                    end = start2 + rowSpan;
                    int i3 = start2;
                    while (i3 < end) {
                        c = table.getRow(i3).getCell(lastCol);
                        this.buildCellBorder(style.getRightBorder(), c, 2);
                        ++i3;
                    }
                } else {
                    XWPFTableCell c3 = table.getRow(rowNumber).getCell(lastCol);
                    this.buildCellBorder(rightBorder, c3, 2);
                }
            }
            if (topBorder != null) {
                if (colSpan > 0) {
                    start = columnNumber;
                    int end3 = start + colSpan;
                    i2 = start;
                    while (i2 < end3) {
                        c2 = table.getRow(rowNumber).getCell(i2);
                        this.buildCellBorder(topBorder, c2, 3);
                        ++i2;
                    }
                } else {
                    this.buildCellBorder(topBorder, tableCell, 3);
                }
            }
            if (bottomBorder != null) {
                int lastRow = rowNumber;
                if (rowSpan > 0) {
                    lastRow += rowSpan - 1;
                }
                if (colSpan > 0) {
                    int start3 = columnNumber;
                    end = start3 + colSpan;
                    int i4 = start3;
                    while (i4 < end) {
                        c = table.getRow(lastRow).getCell(i4);
                        this.buildCellBorder(bottomBorder, c, 4);
                        ++i4;
                    }
                } else {
                    XWPFTableCell c4 = table.getRow(lastRow).getCell(columnNumber);
                    this.buildCellBorder(bottomBorder, c4, 4);
                }
            }
            List paras = tableCell.getParagraphs();
            para = null;
            para = paras != null && paras.size() > 0 ? (XWPFParagraph)paras.get(0) : tableCell.addParagraph();
            List runs = para.getRuns();
            run = null;
            run = runs != null && runs.size() > 0 ? (XWPFRun)runs.get(0) : para.createRun();
            Object value = cell.getData();
            if (value instanceof String) {
                String text = value.toString();
                if (text.contains("\n")) {
                    String[] line = text.split("\n");
                    run.setText(line[0], 0);
                    int i5 = 1;
                    while (i5 < line.length) {
                        run.addBreak();
                        run.setText(line[i5], i5);
                        ++i5;
                    }
                } else {
                    run.setText(text);
                }
            } else if (value instanceof Number) {
                run.setText(String.valueOf(value));
            } else if (value instanceof Boolean) {
                run.setText(value.toString());
            } else {
                if (value instanceof Image) {
                    Image img = (Image)value;
                    String path = img.getPath();
                    String imageType = "png";
                    if (StringUtils.isNotBlank((String)path)) {
                        if ((path = path.toLowerCase()).endsWith(".jpg") || path.endsWith(".jpeg")) {
                            imageType = "jpeg";
                        } else if (path.endsWith(".gif")) {
                            imageType = "gif";
                        }
                    }
                    String base64Data = img.getBase64Data();
                    InputStream inputStream = null;
                    try {
                        try {
                            inputStream = ImageUtils.base64DataToInputStream(base64Data);
                            BufferedImage bufferedImage = ImageIO.read(inputStream);
                            int width = bufferedImage.getWidth();
                            int height = bufferedImage.getHeight();
                            IOUtils.closeQuietly((InputStream)inputStream);
                            inputStream = ImageUtils.base64DataToInputStream(base64Data);
                            if (imageType.equals("jpeg")) {
                                run.addPicture(inputStream, 5, "ureport-" + rowNumber + "-" + columnNumber + ".jpg", Units.toEMU((double)width), Units.toEMU((double)height));
                            } else if (imageType.equals("png")) {
                                run.addPicture(inputStream, 6, "ureport-" + rowNumber + "-" + columnNumber + ".png", Units.toEMU((double)width), Units.toEMU((double)height));
                            } else if (imageType.equals("gif")) {
                                run.addPicture(inputStream, 8, "ureport-" + rowNumber + "-" + columnNumber + ".gif", Units.toEMU((double)width), Units.toEMU((double)height));
                            }
                            break block103;
                        }
                        catch (Exception ex) {
                            throw new ReportComputeException(ex);
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                }
                if (value instanceof Date) {
                    Date date = (Date)value;
                    SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    run.setText(sd.format(date));
                }
            }
        }
        String fontFamily = style.getFontFamily();
        if (customStyle != null && StringUtils.isNotBlank((String)customStyle.getFontFamily())) {
            fontFamily = customStyle.getFontFamily();
        }
        if (rowStyle != null && StringUtils.isNotBlank((String)rowStyle.getFontFamily())) {
            fontFamily = rowStyle.getFontFamily();
        }
        if (colStyle != null && StringUtils.isNotBlank((String)colStyle.getFontFamily())) {
            fontFamily = colStyle.getFontFamily();
        }
        if (StringUtils.isNotBlank((String)fontFamily)) {
            run.setFontFamily(fontFamily);
        }
        int fontSize = style.getFontSize();
        if (customStyle != null && customStyle.getFontSize() > 0) {
            fontSize = customStyle.getFontSize();
        }
        if (rowStyle != null && rowStyle.getFontSize() > 0) {
            fontSize = rowStyle.getFontSize();
        }
        if (colStyle != null && colStyle.getFontSize() > 0) {
            fontSize = colStyle.getFontSize();
        }
        if (fontSize > 0) {
            run.setFontSize(fontSize);
        }
        boolean bl = bold = style.getBold() == null ? false : style.getBold();
        if (customStyle != null && customStyle.getBold() != null) {
            bold = customStyle.getBold();
        }
        if (rowStyle != null && rowStyle.getBold() != null) {
            bold = rowStyle.getBold();
        }
        if (colStyle != null && colStyle.getBold() != null) {
            bold = colStyle.getBold();
        }
        if (bold) {
            run.setBold(true);
        }
        boolean bl2 = italic = style.getItalic() == null ? false : style.getItalic();
        if (customStyle != null && customStyle.getItalic() != null) {
            italic = customStyle.getItalic();
        }
        if (rowStyle != null && rowStyle.getItalic() != null) {
            italic = rowStyle.getItalic();
        }
        if (colStyle != null && colStyle.getItalic() != null) {
            italic = colStyle.getItalic();
        }
        if (italic) {
            run.setItalic(true);
        }
        boolean bl3 = underline = style.getUnderline() == null ? false : style.getUnderline();
        if (customStyle != null && customStyle.getUnderline() != null) {
            underline = customStyle.getUnderline();
        }
        if (rowStyle != null && rowStyle.getUnderline() != null) {
            underline = rowStyle.getUnderline();
        }
        if (colStyle != null && colStyle.getUnderline() != null) {
            underline = colStyle.getUnderline();
        }
        if (underline) {
            run.setUnderline(UnderlinePatterns.SINGLE);
        }
        String bgcolor = style.getBgcolor();
        if (customStyle != null && StringUtils.isNotBlank((String)customStyle.getBgcolor())) {
            bgcolor = customStyle.getBgcolor();
        }
        if (rowStyle != null && StringUtils.isNotBlank((String)rowStyle.getBgcolor())) {
            bgcolor = rowStyle.getBgcolor();
        }
        if (colStyle != null && StringUtils.isNotBlank((String)colStyle.getBgcolor())) {
            bgcolor = colStyle.getBgcolor();
        }
        if (bgcolor != null) {
            CTShd ctshd = cellProperties.addNewShd();
            ctshd.setFill((Object)this.toHex(bgcolor.split(",")));
        }
        String forecolor = style.getForecolor();
        if (customStyle != null && StringUtils.isNotBlank((String)customStyle.getForecolor())) {
            forecolor = customStyle.getForecolor();
        }
        if (rowStyle != null && StringUtils.isNotBlank((String)rowStyle.getForecolor())) {
            forecolor = rowStyle.getForecolor();
        }
        if (colStyle != null && StringUtils.isNotBlank((String)colStyle.getForecolor())) {
            forecolor = colStyle.getForecolor();
        }
        if (forecolor != null) {
            run.setColor(this.toHex(forecolor.split(",")));
        }
        Alignment align = style.getAlign();
        if (customStyle != null && customStyle.getAlign() != null) {
            align = customStyle.getAlign();
        }
        if (rowStyle != null && rowStyle.getAlign() != null) {
            align = rowStyle.getAlign();
        }
        if (align != null) {
            if (align.equals((Object)Alignment.left)) {
                para.setAlignment(ParagraphAlignment.LEFT);
            } else if (align.equals((Object)Alignment.right)) {
                para.setAlignment(ParagraphAlignment.RIGHT);
            } else if (align.equals((Object)Alignment.center)) {
                para.setAlignment(ParagraphAlignment.CENTER);
            }
        }
        align = style.getValign();
        if (customStyle != null && customStyle.getValign() != null) {
            align = customStyle.getValign();
        }
        if (rowStyle != null && rowStyle.getValign() != null) {
            align = rowStyle.getValign();
        }
        if (colStyle != null && colStyle.getValign() != null) {
            align = colStyle.getValign();
        }
        if (align != null) {
            CTVerticalJc verticalAlign = cellProperties.addNewVAlign();
            if (align.equals((Object)Alignment.top)) {
                verticalAlign.setVal(STVerticalJc.TOP);
            } else if (align.equals((Object)Alignment.middle)) {
                verticalAlign.setVal(STVerticalJc.CENTER);
            } else if (align.equals((Object)Alignment.bottom)) {
                verticalAlign.setVal(STVerticalJc.BOTTOM);
            }
        }
        int startCol = columnNumber;
        int endRow = startRow = rowNumber;
        int endCol = startCol;
        if (colSpan > 0) {
            endCol = startCol + colSpan - 1;
        }
        if (rowSpan > 0) {
            endRow = startRow + rowSpan - 1;
        }
        if (startCol != endCol) {
            if (rowSpan > 0) {
                i = startRow;
                while (i <= endRow) {
                    this.mergeCellsHorizontal(table, i, startCol, endCol);
                    ++i;
                }
            } else {
                this.mergeCellsHorizontal(table, startRow, startCol, endCol);
            }
        }
        if (startRow != endRow) {
            if (colSpan > 0) {
                i = startCol;
                while (i <= endCol) {
                    this.mergeCellsVertically(table, i, startRow, endRow);
                    ++i;
                }
            } else {
                this.mergeCellsVertically(table, startCol, startRow, endRow);
            }
        }
    }

    private void mergeCellsHorizontal(XWPFTable table, int row, int startCol, int endCol) {
        int cellIndex = startCol;
        while (cellIndex <= endCol) {
            XWPFTableCell cell = table.getRow(row).getCell(cellIndex);
            if (cellIndex == startCol) {
                cell.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.RESTART);
            } else {
                cell.getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.CONTINUE);
            }
            ++cellIndex;
        }
    }

    private void mergeCellsVertically(XWPFTable table, int col, int fromRow, int toRow) {
        int rowIndex = fromRow;
        while (rowIndex <= toRow) {
            XWPFTableCell cell = table.getRow(rowIndex).getCell(col);
            if (rowIndex == fromRow) {
                cell.getCTTc().addNewTcPr().addNewVMerge().setVal(STMerge.RESTART);
            } else {
                cell.getCTTc().addNewTcPr().addNewVMerge().setVal(STMerge.CONTINUE);
            }
            ++rowIndex;
        }
    }

    private void buildCellBorder(Border border, XWPFTableCell tableCell, int type) {
        String color;
        CTTcBorders borders;
        CTTcPr cellPropertie = tableCell.getCTTc().getTcPr();
        if (cellPropertie == null) {
            cellPropertie = tableCell.getCTTc().addNewTcPr();
        }
        if ((borders = cellPropertie.getTcBorders()) == null) {
            borders = cellPropertie.addNewTcBorders();
        }
        BorderStyle borderStyle = border.getStyle();
        CTBorder ctborder = null;
        if (type == 1) {
            ctborder = borders.addNewLeft();
        } else if (type == 2) {
            ctborder = borders.addNewRight();
        } else if (type == 3) {
            ctborder = borders.addNewTop();
        } else if (type == 4) {
            ctborder = borders.addNewBottom();
        }
        if (borderStyle.equals((Object)BorderStyle.dashed)) {
            ctborder.setVal(STBorder.DASHED);
        } else if (borderStyle.equals((Object)BorderStyle.doublesolid)) {
            ctborder.setVal(STBorder.DOUBLE);
        } else {
            ctborder.setVal(STBorder.SINGLE);
        }
        int borderWidth = border.getWidth();
        if (borderWidth > 1) {
            ctborder.setSz(BigInteger.valueOf(DxaUtils.points2dxa(borderWidth)));
        }
        if (StringUtils.isNotBlank((String)(color = border.getColor()))) {
            ctborder.setColor((Object)this.toHex(color.split(",")));
        }
    }

    private int buildTablePCTWidth(List<Column> columns) {
        int width = 0;
        for (Column col : columns) {
            width += col.getWidth();
        }
        return width;
    }

    private String toHex(String[] rgb) {
        StringBuffer sb = new StringBuffer();
        String R = Integer.toHexString(Integer.valueOf(rgb[0]));
        String G = Integer.toHexString(Integer.valueOf(rgb[1]));
        String B = Integer.toHexString(Integer.valueOf(rgb[2]));
        R = R.length() == 1 ? "0" + R : R;
        G = G.length() == 1 ? "0" + G : G;
        B = B.length() == 1 ? "0" + B : B;
        sb.append(R);
        sb.append(G);
        sb.append(B);
        return sb.toString();
    }
}

