/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

public class ApplicationTracker
extends Thread {
    private ApplicationContext applicationContext;

    public ApplicationTracker(ApplicationContext applicationContext) {
        this.setDaemon(true);
        this.applicationContext = applicationContext;
    }

    @Override
    public void run() {
        String target = "http://58.246.62.194:16808/product-server/service/producttracker";
        try {
            String info = this.buildInfo();
            target = String.valueOf(target) + "?" + info;
            URL url = new URL(target);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.connect();
            conn.getResponseCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String buildInfo() throws Exception {
        String user;
        String osVersion;
        String osArch;
        String osName;
        StringBuilder sb = new StringBuilder();
        Properties props = System.getProperties();
        try {
            String path = "classpath*:META-INF/maven/com.bstek.ureport/ureport2-core/pom.properties";
            InputStream inputStream = this.applicationContext.getResource(path).getInputStream();
            Properties mavenProperties = new Properties();
            mavenProperties.load(inputStream);
            String version = (String)mavenProperties.get("version");
            inputStream.close();
            sb.append("product=ureport2-core-" + URLEncoder.encode(version, "utf-8") + "&");
        }
        catch (Exception e) {
            sb.append("product=ureport2-core&");
        }
        String jdkVersion = props.getProperty("java.version");
        if (StringUtils.isNotBlank((CharSequence)jdkVersion)) {
            sb.append("jdkVersion=" + URLEncoder.encode(jdkVersion, "utf-8") + "&");
        }
        if (StringUtils.isNotBlank((CharSequence)(osName = props.getProperty("os.name")))) {
            sb.append("osName=" + URLEncoder.encode(osName, "utf-8") + "&");
        }
        if (StringUtils.isNotBlank((CharSequence)(osArch = props.getProperty("os.arch")))) {
            sb.append("osArch=" + URLEncoder.encode(osArch, "utf-8") + "&");
        }
        if (StringUtils.isNotBlank((CharSequence)(osVersion = props.getProperty("os.version")))) {
            sb.append("osVersion=" + URLEncoder.encode(osVersion, "utf-8") + "&");
        }
        if (StringUtils.isNotBlank((CharSequence)(user = props.getProperty("user.name")))) {
            sb.append("user=" + URLEncoder.encode(user, "utf-8"));
        }
        return sb.toString();
    }
}

