/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class FormatDateFunction
implements Function {
    private final String defaultPattern = "yyyy-MM-dd HH:mm:ss";

    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        if (dataList == null) {
            return "";
        }
        Object obj = null;
        String pattern = "yyyy-MM-dd HH:mm:ss";
        for (ExpressionData<?> data : dataList) {
            Object list;
            if (data instanceof ObjectListExpressionData) {
                ObjectListExpressionData listExpressionData = (ObjectListExpressionData)data;
                list = listExpressionData.getData();
                if (list.size() > 0) {
                    obj = list.get(0);
                }
                if (list.size() <= 1) continue;
                pattern = list.get(1).toString();
                continue;
            }
            if (data instanceof ObjectExpressionData) {
                obj = ((ObjectExpressionData)data).getData();
                continue;
            }
            if (!(data instanceof BindDataListExpressionData)) continue;
            BindDataListExpressionData bindDataList = (BindDataListExpressionData)data;
            list = bindDataList.getData();
            if (list.size() > 0) {
                obj = ((BindData)list.get(0)).getValue();
            }
            if (list.size() <= 1) continue;
            pattern = ((BindData)list.get(1)).getValue().toString();
        }
        if (obj == null) {
            throw new ReportComputeException("Function [formatdate] need a Date type parameter at least");
        }
        if (obj instanceof Date) {
            SimpleDateFormat sd = new SimpleDateFormat(pattern);
            return sd.format((Date)obj);
        }
        throw new ReportComputeException("Function [formatdate] first parameter is Date type");
    }

    @Override
    public String name() {
        return "formatdate";
    }
}

