/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

public class FormatNumberFunction
implements Function {
    private final String defaultPattern = "#";

    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        if (dataList == null) {
            return "";
        }
        Object obj = null;
        String pattern = "#";
        for (ExpressionData<?> data : dataList) {
            Object list;
            if (data instanceof ObjectListExpressionData) {
                ObjectListExpressionData listExpressionData = (ObjectListExpressionData)data;
                list = listExpressionData.getData();
                if (list.size() > 0) {
                    obj = list.get(0);
                }
                if (list.size() <= 1) continue;
                pattern = list.get(1).toString();
                continue;
            }
            if (data instanceof ObjectExpressionData) {
                obj = ((ObjectExpressionData)data).getData();
                continue;
            }
            if (!(data instanceof BindDataListExpressionData)) continue;
            BindDataListExpressionData bindDataList = (BindDataListExpressionData)data;
            list = bindDataList.getData();
            if (list.size() > 0) {
                obj = ((BindData)list.get(0)).getValue();
            }
            if (list.size() <= 1) continue;
            pattern = ((BindData)list.get(1)).getValue().toString();
        }
        if (obj == null) {
            throw new ReportComputeException("Function [formatnumber] need a number parameter at least");
        }
        BigDecimal bigData = Utils.toBigDecimal(obj);
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(bigData.doubleValue());
    }

    @Override
    public String name() {
        return "formatnumber";
    }
}

