/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.definition.Order;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class OrderFunction
implements Function {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        if (dataList == null || dataList.size() != 2) {
            throw new ReportComputeException("Function [order] need two parameters");
        }
        boolean result = this.computeOrder(dataList);
        Order orderData = Order.asc;
        if (!result) {
            orderData = Order.desc;
        }
        final Order order = orderData;
        ExpressionData<?> firstData = dataList.get(0);
        if (firstData instanceof ObjectListExpressionData) {
            ObjectListExpressionData data = (ObjectListExpressionData)firstData;
            Object list = data.getData();
            Collections.sort(list, new Comparator<Object>(){

                @Override
                public int compare(Object data1, Object data2) {
                    return OrderFunction.this.doOrder(data1, data2, order);
                }
            });
            return list;
        }
        if (firstData instanceof BindDataListExpressionData) {
            BindDataListExpressionData bindDataList = (BindDataListExpressionData)firstData;
            Object list = bindDataList.getData();
            ArrayList<Object> ls = new ArrayList<Object>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BindData bindData = (BindData)iterator.next();
                Object obj = bindData.getValue();
                if (obj == null) continue;
                ls.add(obj);
            }
            Collections.sort(ls, new Comparator<Object>(){

                @Override
                public int compare(Object data1, Object data2) {
                    return OrderFunction.this.doOrder(data1, data2, order);
                }
            });
            return ls;
        }
        return firstData.getData();
    }

    private int doOrder(Object data1, Object data2, Order order) {
        if (data1 == null || data2 == null) {
            return 1;
        }
        if (data1 instanceof Date) {
            Date d1 = (Date)data1;
            Date d2 = (Date)data2;
            if (order.equals((Object)Order.asc)) {
                return d1.compareTo(d2);
            }
            return d2.compareTo(d1);
        }
        if (data1 instanceof Number) {
            BigDecimal n1 = Utils.toBigDecimal(data1);
            BigDecimal n2 = Utils.toBigDecimal(data2);
            if (order.equals((Object)Order.asc)) {
                return n1.compareTo(n2);
            }
            return n2.compareTo(n1);
        }
        String str1 = data1.toString();
        String str2 = data2.toString();
        if (order.equals((Object)Order.asc)) {
            return str1.compareTo(str2);
        }
        return str2.compareTo(str1);
    }

    private boolean computeOrder(List<ExpressionData<?>> dataList) {
        boolean order = false;
        ExpressionData<?> secondData = dataList.get(1);
        if (secondData instanceof ObjectExpressionData) {
            ObjectExpressionData data = (ObjectExpressionData)secondData;
            Object obj = data.getData();
            if (obj == null) {
                throw new ReportComputeException("Function [order] second parameter can not be null");
            }
            if (obj instanceof Boolean) {
                order = (Boolean)obj;
                return order;
            }
            if (obj instanceof String) {
                order = Boolean.valueOf(obj.toString());
            } else {
                throw new ReportComputeException("Function [order] second parameter muse be boolean type.");
            }
        }
        return order;
    }

    @Override
    public String name() {
        return "order";
    }
}

