/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SumFunction
implements Function {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        if (dataList == null) {
            return 0;
        }
        BigDecimal total = new BigDecimal(0);
        for (ExpressionData<?> exprData : dataList) {
            Object obj;
            if (exprData instanceof ObjectListExpressionData) {
                ObjectListExpressionData listExpr = (ObjectListExpressionData)exprData;
                Object list = listExpr.getData();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object obj2 = iterator.next();
                    if (obj2 == null || StringUtils.isBlank((CharSequence)obj2.toString())) continue;
                    BigDecimal bigData = Utils.toBigDecimal(obj2);
                    total = total.add(bigData);
                }
                continue;
            }
            if (!(exprData instanceof ObjectExpressionData) || (obj = exprData.getData()) == null || !StringUtils.isNotBlank((CharSequence)obj.toString())) continue;
            BigDecimal bigData = Utils.toBigDecimal(obj);
            total = total.add(bigData);
        }
        return total;
    }

    @Override
    public String name() {
        return "sum";
    }
}

