/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.math;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.math.MathFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.util.List;

public class ChnFunction
extends MathFunction {
    private static final char[] cnNumbers = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    private static final String[] series = new String[]{"", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf"};

    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        ExpressionData<?> exprData;
        BigDecimal data = this.buildBigDecimal(dataList);
        int type = 0;
        if (dataList.size() == 2 && (exprData = dataList.get(1)) instanceof ObjectExpressionData) {
            ObjectExpressionData objData = (ObjectExpressionData)exprData;
            Object obj = objData.getData();
            if (obj == null) {
                throw new ReportComputeException("Pow Function second parameter can not be null.");
            }
            type = Utils.toBigDecimal(obj).intValue();
        }
        return this.buildChnString(data.toString(), type);
    }

    @Override
    public String name() {
        return "chn";
    }

    public String buildChnString(String original, int type) {
        int number;
        String integerPart = "";
        String floatPart = "";
        if (original.contains(".")) {
            int dotIndex = original.indexOf(".");
            integerPart = original.substring(0, dotIndex);
            floatPart = original.substring(dotIndex + 1);
        } else {
            integerPart = original;
        }
        if (integerPart.length() > 16) {
            throw new ReportComputeException("Chn function max support 16 bit integer,current is " + integerPart);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < integerPart.length()) {
            number = this.getNumber(integerPart.charAt(i));
            char num = cnNumbers[number];
            sb.append(num);
            if (type == 0) {
                String unit = series[integerPart.length() - 1 - i];
                sb.append(unit);
            }
            ++i;
        }
        if (floatPart.length() > 0) {
            sb.append("\u70b9");
            i = 0;
            while (i < floatPart.length()) {
                number = this.getNumber(floatPart.charAt(i));
                sb.append(cnNumbers[number]);
                ++i;
            }
        }
        return sb.toString();
    }

    private int getNumber(char c) {
        String str = String.valueOf(c);
        return Integer.parseInt(str);
    }
}

