/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.math;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class MathFunction
implements Function {
    protected List<BigDecimal> buildDataList(List<ExpressionData<?>> dataList) {
        if (dataList == null || dataList.size() == 0) {
            throw new ReportComputeException("Function [" + this.name() + "] need a lot of data parameter.");
        }
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        for (ExpressionData<?> data : dataList) {
            BigDecimal bigData;
            Iterator iterator;
            if (data instanceof ObjectListExpressionData) {
                ObjectListExpressionData objList = (ObjectListExpressionData)data;
                iterator = objList.getData().iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    bigData = Utils.toBigDecimal(obj);
                    if (bigData == null) continue;
                    list.add(bigData);
                }
                continue;
            }
            if (data instanceof ObjectExpressionData) {
                ObjectExpressionData objData = (ObjectExpressionData)data;
                BigDecimal bigData2 = Utils.toBigDecimal(objData.getData());
                if (bigData2 == null) continue;
                list.add(bigData2);
                continue;
            }
            if (!(data instanceof BindDataListExpressionData)) continue;
            BindDataListExpressionData bindDataListData = (BindDataListExpressionData)data;
            iterator = bindDataListData.getData().iterator();
            while (iterator.hasNext()) {
                BindData bindData = (BindData)iterator.next();
                bigData = Utils.toBigDecimal(bindData.getValue());
                if (bigData == null) continue;
                list.add(bigData);
            }
        }
        return list;
    }

    protected BigDecimal buildBigDecimal(List<ExpressionData<?>> dataList) {
        if (dataList == null || dataList.size() == 0) {
            throw new ReportComputeException("Function [" + this.name() + "] need a data of number parameter.");
        }
        BigDecimal number = null;
        ExpressionData<?> data = dataList.get(0);
        if (data instanceof ObjectListExpressionData) {
            ObjectListExpressionData listData = (ObjectListExpressionData)data;
            Object list = listData.getData();
            if (list == null || list.size() != 1) {
                throw new ReportComputeException("Function [" + this.name() + "] need a data of number parameter.");
            }
            Object obj = list.get(0);
            if (obj == null) {
                throw new ReportComputeException("Function [" + this.name() + "] parameter can not be null.");
            }
            number = Utils.toBigDecimal(obj);
        } else if (data instanceof ObjectExpressionData) {
            ObjectExpressionData objData = (ObjectExpressionData)data;
            Object obj = objData.getData();
            if (obj == null) {
                throw new ReportComputeException("Function [" + this.name() + "] parameter can not be null.");
            }
            number = Utils.toBigDecimal(obj);
        } else {
            throw new ReportComputeException("Function [" + this.name() + "] need a data of number parameter.");
        }
        return number;
    }
}

