/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.page;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.function.page.PageFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

public class PageAvgFunction
extends PageFunction {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        if (dataList == null) {
            return 0;
        }
        int size = 0;
        BigDecimal total = new BigDecimal(0);
        for (ExpressionData<?> exprData : dataList) {
            if (!(exprData instanceof ObjectListExpressionData)) continue;
            ObjectListExpressionData listExpr = (ObjectListExpressionData)exprData;
            Object list = listExpr.getData();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj == null) continue;
                BigDecimal bigData = Utils.toBigDecimal(obj);
                total = total.add(bigData);
                ++size;
            }
        }
        return total.divide(new BigDecimal(size), 8, 4);
    }

    @Override
    public String name() {
        return "pavg";
    }
}

