/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model;

import com.bstek.ureport.exception.ReportParseException;

public enum Operator {
    Add,
    Subtract,
    Multiply,
    Divide,
    Complementation;


    public static Operator parse(String op) {
        if (op.equals("+")) {
            return Add;
        }
        if (op.equals("-")) {
            return Subtract;
        }
        if (op.equals("*")) {
            return Multiply;
        }
        if (op.equals("/")) {
            return Divide;
        }
        if (op.equals("%")) {
            return Complementation;
        }
        throw new ReportParseException("Unknow operator :" + op);
    }

    public String toString() {
        switch (this) {
            case Add: {
                return " + ";
            }
            case Divide: {
                return " / ";
            }
            case Multiply: {
                return " * ";
            }
            case Subtract: {
                return " - ";
            }
            case Complementation: {
                return "%";
            }
        }
        throw new IllegalArgumentException("Unknow operator: [" + (Object)((Object)this) + "]");
    }
}

