/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseExpression
implements Expression {
    protected String expr;

    @Override
    public final ExpressionData<?> execute(Cell cell, Cell currentCell, Context context) {
        ExpressionData<?> data = this.compute(cell, currentCell, context);
        return data;
    }

    protected abstract ExpressionData<?> compute(Cell var1, Cell var2, Context var3);

    protected List<Cell> filterCells(Cell cell, Context context, Condition condition, List<Cell> targetCells) {
        if (condition == null) {
            return targetCells;
        }
        ArrayList<Cell> list = new ArrayList<Cell>();
        for (Cell targetCell : targetCells) {
            boolean conditionResult = true;
            List<Object> dataList = targetCell.getBindData();
            if (dataList == null) {
                conditionResult = false;
            } else {
                for (Object obj : dataList) {
                    boolean result = condition.filter(cell, targetCell, obj, context);
                    if (result) continue;
                    conditionResult = false;
                    break;
                }
            }
            if (!conditionResult) continue;
            list.add(targetCell);
        }
        return list;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public String getExpr() {
        return this.expr;
    }
}

