/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.model.Operator;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.utils.ElUtils;
import java.util.ArrayList;
import java.util.List;

public class JoinExpression
extends BaseExpression {
    private List<Operator> operators;
    private List<BaseExpression> expressions;

    public JoinExpression(List<Operator> operators, List<BaseExpression> expressions) {
        this.operators = operators;
        this.expressions = expressions;
    }

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        ExpressionData<Object> data;
        if (this.expressions.size() == 1) {
            return this.expressions.get(0).compute(cell, currentCell, context);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < this.expressions.size()) {
            ExpressionData<Object> d;
            BaseExpression expression = this.expressions.get(i);
            data = expression.execute(cell, currentCell, context);
            Object obj = null;
            if (data instanceof ObjectExpressionData) {
                d = (ObjectExpressionData)data;
                obj = ((ObjectExpressionData)d).getData();
            } else if (data instanceof ObjectListExpressionData) {
                d = (ObjectListExpressionData)data;
                obj = ((ObjectListExpressionData)d).getData();
            }
            if (obj == null) {
                obj = "";
            }
            list.add(obj);
            ++i;
        }
        String str = null;
        int i2 = 0;
        while (i2 < list.size()) {
            data = list.get(i2);
            if (str == null) {
                str = data instanceof String ? "\"" + data + "\"" : "" + data;
            } else {
                Operator op = this.operators.get(i2 - 1);
                str = data instanceof String ? String.valueOf(str) + (Object)((Object)op) + "\"" + data + "\"" : String.valueOf(str) + (Object)((Object)op) + data;
            }
            ++i2;
        }
        Object obj = ElUtils.eval(str);
        return new ObjectExpressionData(obj);
    }

    public List<BaseExpression> getExpressions() {
        return this.expressions;
    }
}

