/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr.ifelse;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ElseExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ElseIfExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ExpressionConditionList;
import com.bstek.ureport.model.Cell;
import java.util.List;

public class IfExpression
extends BaseExpression {
    private ExpressionConditionList conditionList;
    private Expression expression;
    private List<ElseIfExpression> elseIfExpressions;
    private ElseExpression elseExpression;

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        boolean result;
        if (this.conditionList != null && (result = this.conditionList.eval(context, cell, currentCell))) {
            return this.expression.execute(cell, currentCell, context);
        }
        if (this.elseIfExpressions != null) {
            for (ElseIfExpression elseIfExpr : this.elseIfExpressions) {
                if (!elseIfExpr.conditionsEval(cell, currentCell, context)) continue;
                return elseIfExpr.execute(cell, currentCell, context);
            }
        }
        if (this.elseExpression != null) {
            return this.elseExpression.execute(cell, currentCell, context);
        }
        return new ObjectExpressionData(null);
    }

    public void setConditionList(ExpressionConditionList conditionList) {
        this.conditionList = conditionList;
    }

    public void setElseExpression(ElseExpression elseExpression) {
        this.elseExpression = elseExpression;
    }

    public void setElseIfExpressions(List<ElseIfExpression> elseIfExpressions) {
        this.elseIfExpressions = elseIfExpressions;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ElseExpression getElseExpression() {
        return this.elseExpression;
    }

    public List<ElseIfExpression> getElseIfExpressions() {
        return this.elseIfExpressions;
    }
}

