/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr.set;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.set.CellName;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;

public class CellPairExpression
extends BaseExpression {
    private String startCellName;
    private String endCellName;

    public CellPairExpression(String startCellName, String endCellName) {
        this.startCellName = startCellName;
        this.endCellName = endCellName;
    }

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        List<Cell> cellList = this.buildCells(cell, context);
        if (cellList.size() > 1) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Cell targetCell : cellList) {
                list.add(targetCell.getData());
            }
            return new ObjectListExpressionData(list);
        }
        if (cellList.size() == 1) {
            return new ObjectExpressionData(cellList.get(0).getData());
        }
        return new ObjectExpressionData(null);
    }

    private List<Cell> buildCells(Cell cell, Context context) {
        int tmp;
        List<String> cellNameList = ExpressionUtils.getCellNameList();
        CellName startName = this.parseCellName(this.startCellName);
        int startPos = cellNameList.indexOf(startName.getName());
        int rowStart = startName.getNumber();
        CellName endName = this.parseCellName(this.endCellName);
        int endPos = cellNameList.indexOf(endName.getName());
        int rowEnd = endName.getNumber();
        if (startPos > endPos) {
            tmp = startPos;
            startPos = endPos;
            endPos = tmp;
        }
        if (rowStart > rowEnd) {
            tmp = rowStart;
            rowStart = rowEnd;
            rowEnd = tmp;
        }
        ArrayList<String> names = new ArrayList<String>();
        int i = startPos;
        while (i <= endPos) {
            names.add(cellNameList.get(i));
            ++i;
        }
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        for (String name : names) {
            int i2 = rowStart;
            while (i2 <= rowEnd) {
                String cellName = String.valueOf(name) + i2;
                List<Cell> cells = Utils.fetchTargetCells(cell, context, cellName);
                cellList.addAll(cells);
                ++i2;
            }
        }
        return cellList;
    }

    private CellName parseCellName(String name) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isDigit(c)) {
                sb1.append(c);
            } else {
                sb.append(c);
            }
            ++i;
        }
        String cellName = sb.toString();
        int number = Integer.valueOf(sb1.toString());
        return new CellName(cellName, number);
    }
}

