/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr.set;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;

public class FromToExpression
extends BaseExpression {
    private BaseExpression fromExpression;
    private BaseExpression toExpression;

    public FromToExpression(BaseExpression fromExpression, BaseExpression toExpression) {
        this.fromExpression = fromExpression;
        this.toExpression = toExpression;
    }

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        ExpressionData<?> fromData = this.fromExpression.execute(cell, currentCell, context);
        ExpressionData<?> toData = this.toExpression.execute(cell, currentCell, context);
        int from = this.convertFloatData(fromData);
        int to = this.convertFloatData(toData);
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = from;
        while (i <= to) {
            list.add(i);
            ++i;
        }
        return new ObjectListExpressionData(list);
    }

    private int convertFloatData(Object data) {
        if (data instanceof ObjectExpressionData) {
            Object obj = ((ObjectExpressionData)data).getData();
            return Utils.toBigDecimal(obj).intValue();
        }
        throw new ReportComputeException("Can not convert [" + data + "] to integer.");
    }
}

