/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr.set;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.expression.model.expr.set.CellExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;

public class WholeCellExpression
extends CellExpression {
    private Condition condition;

    public WholeCellExpression(String cellName) {
        super(cellName);
    }

    @Override
    public boolean supportPaging() {
        return false;
    }

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        while (!context.isCellPocessed(this.cellName)) {
            context.getReportBuilder().buildCell(context, null);
        }
        List<Cell> cells = context.getReport().getCellsMap().get(this.cellName);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Cell c : cells) {
            boolean result;
            Object obj = c.getData();
            if (this.condition != null && !(result = this.condition.filter(cell, currentCell, obj, context))) continue;
            list.add(obj);
        }
        if (list.size() == 1) {
            return new ObjectExpressionData(list.get(0));
        }
        return new ObjectListExpressionData(list);
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }
}

