/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.parse;

import com.bstek.ureport.dsl.ReportParserBaseVisitor;
import com.bstek.ureport.dsl.ReportParserParser;
import com.bstek.ureport.exception.ReportParseException;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.Op;
import com.bstek.ureport.expression.model.Operator;
import com.bstek.ureport.expression.model.condition.Join;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.expression.model.expr.JoinExpression;
import com.bstek.ureport.expression.model.expr.ParenExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ElseExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ElseIfExpression;
import com.bstek.ureport.expression.model.expr.ifelse.ExpressionCondition;
import com.bstek.ureport.expression.model.expr.ifelse.ExpressionConditionList;
import com.bstek.ureport.expression.model.expr.ifelse.IfExpression;
import com.bstek.ureport.expression.parse.builder.ExpressionBuilder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ExpressionVisitor
extends ReportParserBaseVisitor<Expression> {
    private List<ExpressionBuilder> expressionBuilders;

    public ExpressionVisitor(List<ExpressionBuilder> expressionBuilders) {
        this.expressionBuilders = expressionBuilders;
    }

    @Override
    public Expression visitExpression(ReportParserParser.ExpressionContext ctx) {
        ReportParserParser.ExprContext exprContext = ctx.expr();
        ReportParserParser.IfExprContext ifExprContext = ctx.ifExpr();
        ReportParserParser.CaseExprContext caseExprContext = ctx.caseExpr();
        ReportParserParser.TernaryExprContext ternaryExprContext = ctx.ternaryExpr();
        if (exprContext != null) {
            return this.parseExpr(exprContext);
        }
        if (ifExprContext != null) {
            ReportParserParser.ElsePartContext elsePartContext;
            IfExpression expr = new IfExpression();
            expr.setExpr(ctx.getText());
            ReportParserParser.IfPartContext ifPartContext = ifExprContext.ifPart();
            List<ReportParserParser.IfConditionContext> ifConditionContexts = ifPartContext.ifCondition();
            List<ReportParserParser.JoinContext> joinContexts = ifPartContext.join();
            expr.setConditionList(this.parseCondtionList(ifConditionContexts, joinContexts));
            ReportParserParser.ExprContext ec = ifPartContext.expr();
            Expression expression = this.parseExpr(ec);
            expr.setExpression(expression);
            List<ReportParserParser.ElseIfPartContext> elseIfPartContexts = ifExprContext.elseIfPart();
            if (elseIfPartContexts != null && elseIfPartContexts.size() > 0) {
                ArrayList<ElseIfExpression> elseIfExpressionList = new ArrayList<ElseIfExpression>();
                for (ReportParserParser.ElseIfPartContext elseIfContext : elseIfPartContexts) {
                    ifConditionContexts = elseIfContext.ifCondition();
                    joinContexts = elseIfContext.join();
                    ElseIfExpression elseIfExpr = new ElseIfExpression();
                    elseIfExpr.setConditionList(this.parseCondtionList(ifConditionContexts, joinContexts));
                    ec = elseIfContext.expr();
                    elseIfExpr.setExpr(elseIfContext.getText());
                    elseIfExpr.setExpression(this.parseExpr(ec));
                    elseIfExpressionList.add(elseIfExpr);
                }
                expr.setElseIfExpressions(elseIfExpressionList);
            }
            if ((elsePartContext = ifExprContext.elsePart()) != null) {
                ec = elsePartContext.expr();
                ElseExpression elseExpression = new ElseExpression();
                elseExpression.setExpr(elsePartContext.getText());
                elseExpression.setExpression(this.parseExpr(ec));
                expr.setElseExpression(elseExpression);
            }
            return expr;
        }
        if (caseExprContext != null) {
            IfExpression expr = new IfExpression();
            expr.setExpr(ctx.getText());
            ArrayList<ElseIfExpression> elseIfExpressionList = new ArrayList<ElseIfExpression>();
            expr.setElseIfExpressions(elseIfExpressionList);
            List<ReportParserParser.CasePartContext> casePartContexts = caseExprContext.casePart();
            for (ReportParserParser.CasePartContext casePartContext : casePartContexts) {
                List<ReportParserParser.IfConditionContext> ifConditionContexts = casePartContext.ifCondition();
                List<ReportParserParser.JoinContext> joinContexts = casePartContext.join();
                ElseIfExpression elseIfExpr = new ElseIfExpression();
                elseIfExpr.setConditionList(this.parseCondtionList(ifConditionContexts, joinContexts));
                elseIfExpr.setExpr(casePartContext.getText());
                ReportParserParser.ExprContext ec = casePartContext.expr();
                elseIfExpr.setExpression(this.parseExpr(ec));
                elseIfExpressionList.add(elseIfExpr);
            }
            return expr;
        }
        if (ternaryExprContext != null) {
            List<ReportParserParser.IfConditionContext> ifConditionContexts = ternaryExprContext.ifCondition();
            IfExpression expr = new IfExpression();
            expr.setConditionList(this.parseCondtionList(ifConditionContexts, ternaryExprContext.join()));
            ReportParserParser.ExprContext firstExprContext = ternaryExprContext.expr(0);
            ReportParserParser.ExprContext secondExprContext = ternaryExprContext.expr(1);
            expr.setExpression(this.parseExpr(firstExprContext));
            ElseExpression elseExpr = new ElseExpression();
            elseExpr.setExpression(this.parseExpr(secondExprContext));
            expr.setElseExpression(elseExpr);
            return expr;
        }
        throw new ReportParseException("Expression [" + ctx.getText() + "] is invalid.");
    }

    private Expression parseExpr(ReportParserParser.ExprContext exprContext) {
        ArrayList<BaseExpression> expressions = new ArrayList<BaseExpression>();
        ArrayList<Operator> operators = new ArrayList<Operator>();
        List<ReportParserParser.ItemContext> itemContexts = exprContext.item();
        List<TerminalNode> operatorNodes = exprContext.Operator();
        int i = 0;
        while (i < itemContexts.size()) {
            ReportParserParser.ItemContext itemContext = itemContexts.get(i);
            BaseExpression expr = this.parseItemContext(itemContext);
            expressions.add(expr);
            if (i > 0) {
                TerminalNode operatorNode = operatorNodes.get(i - 1);
                String op = operatorNode.getText();
                operators.add(Operator.parse(op));
            }
            ++i;
        }
        ParenExpression expression = new ParenExpression(operators, expressions);
        expression.setExpr(exprContext.getText());
        return expression;
    }

    private ExpressionConditionList parseCondtionList(List<ReportParserParser.IfConditionContext> ifConditionContexts, List<ReportParserParser.JoinContext> joinContexts) {
        ArrayList<ExpressionCondition> list = new ArrayList<ExpressionCondition>();
        ArrayList<Join> joins = new ArrayList<Join>();
        int i = 0;
        while (i < ifConditionContexts.size()) {
            ReportParserParser.IfConditionContext context = ifConditionContexts.get(i);
            ReportParserParser.ExprContext left = context.expr(0);
            ReportParserParser.ExprContext right = context.expr(1);
            Expression leftExpr = this.parseExpr(left);
            Expression rightExpr = this.parseExpr(right);
            Op op = Op.parse(context.OP().getText());
            ExpressionCondition condition = new ExpressionCondition(leftExpr, op, rightExpr);
            list.add(condition);
            if (i > 0) {
                ReportParserParser.JoinContext joinContext = joinContexts.get(i - 1);
                Join join = Join.valueOf(joinContext.getText());
                joins.add(join);
            }
            ++i;
        }
        return new ExpressionConditionList(list, joins);
    }

    private BaseExpression parseItemContext(ReportParserParser.ItemContext itemContext) {
        BaseExpression expression = null;
        if (itemContext instanceof ReportParserParser.SimpleJoinContext) {
            ReportParserParser.SimpleJoinContext simpleJoinContext = (ReportParserParser.SimpleJoinContext)itemContext;
            expression = this.visitSimpleJoin(simpleJoinContext);
        } else if (itemContext instanceof ReportParserParser.ParenJoinContext) {
            ReportParserParser.ParenJoinContext parenJoinContext = (ReportParserParser.ParenJoinContext)itemContext;
            expression = this.visitParenJoin(parenJoinContext);
        } else if (itemContext instanceof ReportParserParser.SingleParenJoinContext) {
            ReportParserParser.SingleParenJoinContext singleContext = (ReportParserParser.SingleParenJoinContext)itemContext;
            ReportParserParser.ItemContext childItemContext = singleContext.item();
            expression = this.parseItemContext(childItemContext);
        } else {
            throw new ReportParseException("Unknow context :" + (Object)((Object)itemContext));
        }
        return expression;
    }

    @Override
    public BaseExpression visitSimpleJoin(ReportParserParser.SimpleJoinContext ctx) {
        ArrayList<BaseExpression> expressions = new ArrayList<BaseExpression>();
        ArrayList<Operator> operators = new ArrayList<Operator>();
        List<ReportParserParser.UnitContext> unitContexts = ctx.unit();
        List<TerminalNode> operatorNodes = ctx.Operator();
        int i = 0;
        while (i < unitContexts.size()) {
            ReportParserParser.UnitContext unitContext = unitContexts.get(i);
            BaseExpression expr = this.buildExpression(unitContext);
            expressions.add(expr);
            if (i > 0) {
                TerminalNode operatorNode = operatorNodes.get(i - 1);
                String op = operatorNode.getText();
                operators.add(Operator.parse(op));
            }
            ++i;
        }
        JoinExpression expression = new JoinExpression(operators, expressions);
        expression.setExpr(ctx.getText());
        return expression;
    }

    @Override
    public BaseExpression visitParenJoin(ReportParserParser.ParenJoinContext ctx) {
        ArrayList<BaseExpression> expressions = new ArrayList<BaseExpression>();
        ArrayList<Operator> operators = new ArrayList<Operator>();
        List<ReportParserParser.ItemContext> itemContexts = ctx.item();
        List<TerminalNode> operatorNodes = ctx.Operator();
        int i = 0;
        while (i < itemContexts.size()) {
            ReportParserParser.ItemContext itemContext = itemContexts.get(i);
            BaseExpression expr = this.parseItemContext(itemContext);
            expressions.add(expr);
            if (i > 0) {
                TerminalNode operatorNode = operatorNodes.get(i - 1);
                String op = operatorNode.getText();
                operators.add(Operator.parse(op));
            }
            ++i;
        }
        ParenExpression expression = new ParenExpression(operators, expressions);
        expression.setExpr(ctx.getText());
        return expression;
    }

    private BaseExpression buildExpression(ReportParserParser.UnitContext unitContext) {
        for (ExpressionBuilder builder : this.expressionBuilders) {
            if (!builder.support(unitContext)) continue;
            return builder.build(unitContext);
        }
        throw new ReportParseException("Unknow context :" + (Object)((Object)unitContext));
    }
}

