/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.image;

import com.bstek.ureport.Utils;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.image.ImageProcessor;
import com.bstek.ureport.provider.image.ImageProvider;
import java.io.InputStream;
import java.util.Collection;

public class StaticImageProcessor
implements ImageProcessor<String> {
    @Override
    public InputStream getImage(String path) {
        Collection<ImageProvider> imageProviders = Utils.getImageProviders();
        ImageProvider targetImageProvider = null;
        for (ImageProvider provider : imageProviders) {
            if (!provider.support(path)) continue;
            targetImageProvider = provider;
            break;
        }
        if (targetImageProvider == null) {
            throw new ReportComputeException("Unsupport image path :" + path);
        }
        InputStream inputStream = targetImageProvider.getImage(path);
        return inputStream;
    }
}

