/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.parser.impl;

import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.PagingMode;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.PaperSize;
import com.bstek.ureport.definition.PaperType;
import com.bstek.ureport.parser.Parser;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class PaperParser
implements Parser<Paper> {
    @Override
    public Paper parse(Element element) {
        String columnEnabled;
        String bottomMargin;
        String topMargin;
        String rightMargin;
        Paper paper = new Paper();
        String orientation = element.attributeValue("orientation");
        paper.setOrientation(Orientation.valueOf(orientation));
        paper.setPaperType(PaperType.valueOf(element.attributeValue("type")));
        if (paper.getPaperType().equals((Object)PaperType.CUSTOM)) {
            paper.setWidth(Integer.valueOf(element.attributeValue("width")));
            paper.setHeight(Integer.valueOf(element.attributeValue("height")));
        } else {
            PaperSize size = paper.getPaperType().getPaperSize();
            paper.setWidth(size.getWidth());
            paper.setHeight(size.getHeight());
        }
        String leftMargin = element.attributeValue("left-margin");
        if (StringUtils.isNotBlank((String)leftMargin)) {
            paper.setLeftMargin(Integer.valueOf(leftMargin));
        }
        if (StringUtils.isNotBlank((String)(rightMargin = element.attributeValue("right-margin")))) {
            paper.setRightMargin(Integer.valueOf(rightMargin));
        }
        if (StringUtils.isNotBlank((String)(topMargin = element.attributeValue("top-margin")))) {
            paper.setTopMargin(Integer.valueOf(topMargin));
        }
        if (StringUtils.isNotBlank((String)(bottomMargin = element.attributeValue("bottom-margin")))) {
            paper.setBottomMargin(Integer.valueOf(bottomMargin));
        }
        paper.setPagingMode(PagingMode.valueOf(element.attributeValue("paging-mode")));
        if (paper.getPagingMode().equals((Object)PagingMode.fixrows)) {
            paper.setFixRows(Integer.valueOf(element.attributeValue("fixrows")));
        }
        if (StringUtils.isNotBlank((String)(columnEnabled = element.attributeValue("column-enabled")))) {
            paper.setColumnEnabled(Boolean.valueOf(columnEnabled));
        }
        if (paper.isColumnEnabled()) {
            paper.setColumnCount(Integer.valueOf(element.attributeValue("column-count")));
            paper.setColumnMargin(Integer.valueOf(element.attributeValue("column-margin")));
        }
        return paper;
    }
}

