/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.utils;

import com.bstek.ureport.utils.ArithUtils;
import java.util.Collections;
import java.util.Stack;

public class ElUtils {
    private static int[] operatPriority;

    static {
        int[] nArray = new int[8];
        nArray[1] = 3;
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[4] = -1;
        nArray[5] = 1;
        nArray[7] = 2;
        operatPriority = nArray;
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 3) {
            ++i;
        }
        String expr = "\"\u6211\u6765\u81ea\u4e2d\u56fd:\"+23%3+32";
        Object data = ElUtils.eval(expr);
        System.out.println(data);
        long end = System.currentTimeMillis();
        System.out.println(end - start);
    }

    public static Object eval(String expression) {
        expression = ElUtils.transform(expression);
        Object result = ElUtils.calculate(expression);
        return result;
    }

    private static String transform(String expression) {
        char[] arr = expression.toCharArray();
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == '-') {
                if (i == 0) {
                    arr[i] = 126;
                } else {
                    char c = arr[i - 1];
                    if (c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == 'E' || c == 'e') {
                        arr[i] = 126;
                    }
                }
            }
            ++i;
        }
        if (arr[0] == '~' || arr[1] == '(') {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }

    private static Object calculate(String expression) {
        Stack<String> postfixStack = new Stack<String>();
        Stack<Object> resultStack = new Stack<Object>();
        ElUtils.prepare(expression, postfixStack);
        Collections.reverse(postfixStack);
        while (!postfixStack.isEmpty()) {
            String currentValue = postfixStack.pop();
            if (!ElUtils.isOperator(currentValue.charAt(0))) {
                currentValue = currentValue.replace("~", "-");
                resultStack.push(currentValue);
                continue;
            }
            String secondValue = resultStack.pop().toString();
            String firstValue = resultStack.pop().toString();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            Object tempResult = ElUtils.calculate(firstValue, secondValue, currentValue.charAt(0));
            resultStack.push(tempResult);
        }
        return resultStack.pop();
    }

    /*
     * Unable to fully structure code
     */
    private static void prepare(String expression, Stack<String> postfixStack) {
        opStack = new Stack<Character>();
        opStack.push(Character.valueOf(','));
        arr = expression.toCharArray();
        currentIndex = 0;
        count = 0;
        prevData = null;
        i = 0;
        while (i < arr.length) {
            block12: {
                block14: {
                    block15: {
                        block13: {
                            currentOp = arr[i];
                            if (!ElUtils.isInvertedComma(currentOp)) break block13;
                            currentIndex = i + 1;
                            ++i;
                            count = 1;
                            while (i < arr.length) {
                                currentOp = arr[i];
                                if (ElUtils.isInvertedComma(currentOp)) {
                                    prevData = new String(arr, currentIndex, count - 1);
                                    break block12;
                                }
                                ++i;
                                ++count;
                            }
                            break block12;
                        }
                        if (!ElUtils.isOperator(currentOp)) break block14;
                        if (prevData != null) {
                            postfixStack.push(prevData);
                            prevData = null;
                        } else if (count > 0) {
                            data = new String(arr, currentIndex, count).trim();
                            postfixStack.push(data);
                        }
                        peekOp = ((Character)opStack.peek()).charValue();
                        if (currentOp != ')') ** GOTO lbl47
                        while (((Character)opStack.peek()).charValue() != '(') {
                            postfixStack.push(String.valueOf(opStack.pop()));
                        }
                        opStack.pop();
                        break block15;
lbl-1000:
                        // 1 sources

                        {
                            postfixStack.push(String.valueOf(opStack.pop()));
                            peekOp = ((Character)opStack.peek()).charValue();
lbl47:
                            // 2 sources

                            ** while (currentOp != '(' && peekOp != ',' && ElUtils.compare((char)currentOp, (char)peekOp))
                        }
lbl48:
                        // 1 sources

                        opStack.push(Character.valueOf(currentOp));
                    }
                    count = 0;
                    currentIndex = i + 1;
                    break block12;
                }
                ++count;
            }
            ++i;
        }
        if (prevData != null) {
            postfixStack.push(prevData);
        } else if (count > 1 || count == 1 && !ElUtils.isOperator(arr[currentIndex])) {
            postfixStack.push(new String(arr, currentIndex, count));
        }
        while (((Character)opStack.peek()).charValue() != ',') {
            postfixStack.push(String.valueOf(opStack.pop()));
        }
    }

    private static boolean isInvertedComma(char c) {
        return c == '\"';
    }

    private static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '(' || c == ')';
    }

    public static boolean compare(char cur, char peek) {
        if (cur == '%') {
            cur = (char)42;
        }
        if (peek == '%') {
            peek = (char)42;
        }
        boolean result = false;
        if (operatPriority[peek - 40] >= operatPriority[cur - 40]) {
            result = true;
        }
        return result;
    }

    private static Object calculate(String firstValue, String secondValue, char currentOp) {
        Object result = null;
        try {
            switch (currentOp) {
                case '+': {
                    result = ArithUtils.add(firstValue, secondValue);
                    break;
                }
                case '-': {
                    result = ArithUtils.sub(firstValue, secondValue);
                    break;
                }
                case '*': {
                    result = ArithUtils.mul(firstValue, secondValue);
                    break;
                }
                case '/': {
                    result = ArithUtils.div(firstValue, secondValue);
                    break;
                }
                case '%': {
                    result = ArithUtils.com(firstValue, secondValue);
                }
            }
        }
        catch (Exception ex) {
            String b;
            String a = firstValue == null ? "null" : firstValue.toString();
            String string = b = secondValue == null ? "null" : secondValue.toString();
            if (currentOp == '+') {
                result = String.valueOf(a) + b;
            }
            throw ex;
        }
        return result;
    }
}

