/*
 * Decompiled with CFR 0.152.
 */
package PduParser;

import PduParser.AcknowledgeInd;
import PduParser.CharacterSets;
import PduParser.DeliveryInd;
import PduParser.EncodedStringValue;
import PduParser.GenericPdu;
import PduParser.InvalidHeaderValueException;
import PduParser.NotificationInd;
import PduParser.NotifyRespInd;
import PduParser.PduBody;
import PduParser.PduContentTypes;
import PduParser.PduHeaders;
import PduParser.PduPart;
import PduParser.QuotedPrintable;
import PduParser.ReadOrigInd;
import PduParser.ReadRecInd;
import PduParser.RetrieveConf;
import PduParser.SendConf;
import PduParser.SendReq;
import com.zx.sms.common.util.CachedMillisecondClock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PduParser {
    private static final Logger logger = LoggerFactory.getLogger(PduParser.class);
    private static final int QUOTE = 127;
    private static final int LENGTH_QUOTE = 31;
    private static final int TEXT_MIN = 32;
    private static final int TEXT_MAX = 127;
    private static final int SHORT_INTEGER_MAX = 127;
    private static final int SHORT_LENGTH_MAX = 30;
    private static final int LONG_INTEGER_LENGTH_MAX = 8;
    private static final int QUOTED_STRING_FLAG = 34;
    private static final int END_STRING_FLAG = 0;
    private static final int TYPE_TEXT_STRING = 0;
    private static final int TYPE_QUOTED_STRING = 1;
    private static final int TYPE_TOKEN_STRING = 2;
    private static final int THE_FIRST_PART = 0;
    private static final int THE_LAST_PART = 1;
    private ByteArrayInputStream mPduDataStream = null;
    private PduHeaders mHeaders = null;
    private PduBody mBody = null;
    private static byte[] mTypeParam = null;
    private static byte[] mStartParam = null;
    private static final String LOG_TAG = "PduParser";
    private static final boolean DEBUG = false;
    private static final int UNSIGNED_INT_LIMIT = 2;

    private static void log(String text) {
        logger.warn(text);
    }

    public PduParser(byte[] pduDataStream) {
        this.mPduDataStream = new ByteArrayInputStream(pduDataStream);
    }

    public GenericPdu parse() {
        if (this.mPduDataStream == null) {
            return null;
        }
        this.mHeaders = this.parseHeaders(this.mPduDataStream);
        if (null == this.mHeaders) {
            return null;
        }
        int messageType = this.mHeaders.getOctet(140);
        if (!PduParser.checkMandatoryHeader(this.mHeaders)) {
            logger.warn("check mandatory headers failed!");
            return null;
        }
        this.mPduDataStream.mark(1);
        int count = PduParser.parseUnsignedInt(this.mPduDataStream);
        this.mPduDataStream.reset();
        if (132 == messageType && count >= 2) {
            byte[] contentType = this.mHeaders.getTextString(132);
            if (null == contentType) {
                logger.warn("Parse MESSAGE_TYPE_RETRIEVE_CONF Failed: content Type is null _0");
                return null;
            }
            String contentTypeStr = new String(contentType);
            if (!(contentTypeStr = contentTypeStr.toLowerCase()).equals("application/vnd.wap.multipart.mixed") && !contentTypeStr.equals("application/vnd.wap.multipart.related") && !contentTypeStr.equals("application/vnd.wap.multipart.alternative") && contentTypeStr.equals("text/plain")) {
                logger.debug("Content Type is text/plain");
                PduPart theOnlyPart = new PduPart();
                theOnlyPart.setContentType(contentType);
                theOnlyPart.setContentLocation(Long.toOctalString(CachedMillisecondClock.INS.now()).getBytes());
                theOnlyPart.setContentId("<part1>".getBytes());
                this.mPduDataStream.mark(1);
                int partDataLen = 0;
                while (this.mPduDataStream.read() != -1) {
                    ++partDataLen;
                }
                byte[] partData = new byte[partDataLen];
                logger.debug("got part length: " + partDataLen);
                this.mPduDataStream.reset();
                this.mPduDataStream.read(partData, 0, partDataLen);
                String showData = new String(partData);
                logger.debug("show data: " + showData);
                theOnlyPart.setData(partData);
                logger.debug("setData finish");
                PduBody onlyPartBody = new PduBody();
                onlyPartBody.addPart(theOnlyPart);
                RetrieveConf retrieveConf = null;
                try {
                    retrieveConf = new RetrieveConf(this.mHeaders, onlyPartBody);
                }
                catch (Exception e) {
                    logger.warn("new RetrieveConf has exception");
                }
                if (retrieveConf == null) {
                    logger.warn("retrieveConf is null");
                }
                return retrieveConf;
            }
        }
        if (128 == messageType || 132 == messageType) {
            this.mBody = PduParser.parseParts(this.mPduDataStream);
            if (null == this.mBody) {
                return null;
            }
        }
        switch (messageType) {
            case 128: {
                logger.debug("parse: MESSAGE_TYPE_SEND_REQ");
                SendReq sendReq = new SendReq(this.mHeaders, this.mBody);
                return sendReq;
            }
            case 129: {
                logger.debug("parse: MESSAGE_TYPE_SEND_CONF");
                SendConf sendConf = new SendConf(this.mHeaders);
                return sendConf;
            }
            case 130: {
                logger.debug("parse: MESSAGE_TYPE_NOTIFICATION_IND");
                NotificationInd notificationInd = new NotificationInd(this.mHeaders);
                return notificationInd;
            }
            case 131: {
                logger.debug("parse: MESSAGE_TYPE_NOTIFYRESP_IND");
                NotifyRespInd notifyRespInd = new NotifyRespInd(this.mHeaders);
                return notifyRespInd;
            }
            case 132: {
                logger.debug("parse: MESSAGE_TYPE_RETRIEVE_CONF");
                RetrieveConf retrieveConf = new RetrieveConf(this.mHeaders, this.mBody);
                byte[] contentType = retrieveConf.getContentType();
                if (null == contentType) {
                    logger.warn("Parse MESSAGE_TYPE_RETRIEVE_CONF Failed: content Type is null _1");
                    return null;
                }
                String ctTypeStr = new String(contentType);
                if ((ctTypeStr = ctTypeStr.toLowerCase()).equals("application/vnd.wap.multipart.mixed") || ctTypeStr.equals("application/vnd.wap.multipart.related") || ctTypeStr.equals("application/vnd.wap.multipart.alternative") || ctTypeStr.equals("text/plain")) {
                    return retrieveConf;
                }
                if (ctTypeStr.equals("application/vnd.wap.multipart.alternative")) {
                    PduPart firstPart = this.mBody.getPart(0);
                    this.mBody.removeAll();
                    this.mBody.addPart(0, firstPart);
                    return retrieveConf;
                }
                logger.warn("Parse MESSAGE_TYPE_RETRIEVE_CONF Failed: content Type is null _2");
                return null;
            }
            case 134: {
                logger.debug("parse: MESSAGE_TYPE_DELIVERY_IND");
                DeliveryInd deliveryInd = new DeliveryInd(this.mHeaders);
                return deliveryInd;
            }
            case 133: {
                logger.debug("parse: MESSAGE_TYPE_ACKNOWLEDGE_IND");
                AcknowledgeInd acknowledgeInd = new AcknowledgeInd(this.mHeaders);
                return acknowledgeInd;
            }
            case 136: {
                logger.debug("parse: MESSAGE_TYPE_READ_ORIG_IND");
                ReadOrigInd readOrigInd = new ReadOrigInd(this.mHeaders);
                return readOrigInd;
            }
            case 135: {
                logger.debug("parse: MESSAGE_TYPE_READ_REC_IND");
                ReadRecInd readRecInd = new ReadRecInd(this.mHeaders);
                return readRecInd;
            }
        }
        logger.warn("Parser doesn't support this message type in this version!");
        return null;
    }

    protected PduHeaders parseHeaders(ByteArrayInputStream pduDataStream) {
        if (pduDataStream == null) {
            return null;
        }
        boolean keepParsing = true;
        PduHeaders headers = new PduHeaders();
        block77: while (keepParsing && pduDataStream.available() > 0) {
            pduDataStream.mark(1);
            int headerField = PduParser.extractByteValue(pduDataStream);
            if (headerField >= 32 && headerField <= 127) {
                pduDataStream.reset();
                byte[] bVal = PduParser.parseWapString(pduDataStream, 0);
                continue;
            }
            switch (headerField) {
                case 140: {
                    int messageType = PduParser.extractByteValue(pduDataStream);
                    switch (messageType) {
                        case 137: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: {
                            return null;
                        }
                    }
                    try {
                        headers.setOctet(messageType, headerField);
                        break;
                    }
                    catch (InvalidHeaderValueException e) {
                        PduParser.log("Set invalid Octet value: " + messageType + " into the header filed: " + headerField);
                        return null;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Octet header field!");
                        return null;
                    }
                }
                case 134: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 148: 
                case 149: 
                case 153: 
                case 155: 
                case 156: 
                case 162: 
                case 163: 
                case 165: 
                case 167: 
                case 169: 
                case 171: 
                case 177: 
                case 180: 
                case 186: 
                case 187: 
                case 188: 
                case 191: {
                    int value = PduParser.extractByteValue(pduDataStream);
                    try {
                        headers.setOctet(value, headerField);
                        break;
                    }
                    catch (InvalidHeaderValueException e) {
                        PduParser.log("Set invalid Octet value: " + value + " into the header filed: " + headerField);
                        return null;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Octet header field!");
                        return null;
                    }
                }
                case 133: 
                case 142: 
                case 159: {
                    try {
                        long value = PduParser.parseLongInteger(pduDataStream);
                        headers.setLongInteger(value, headerField);
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Long-Integer header field!");
                        return null;
                    }
                }
                case 173: 
                case 175: 
                case 179: {
                    try {
                        long value = PduParser.parseIntegerValue(pduDataStream);
                        headers.setLongInteger(value, headerField);
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Long-Integer header field!");
                        return null;
                    }
                }
                case 131: 
                case 139: 
                case 152: 
                case 158: 
                case 183: 
                case 184: 
                case 185: 
                case 189: 
                case 190: {
                    Object value = PduParser.parseWapString(pduDataStream, 0);
                    if (null == value) continue block77;
                    try {
                        headers.setTextString((byte[])value, headerField);
                        break;
                    }
                    catch (NullPointerException e) {
                        PduParser.log("null pointer error!");
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Text-String header field!");
                        return null;
                    }
                }
                case 147: 
                case 150: 
                case 154: 
                case 166: 
                case 181: 
                case 182: {
                    Object value = PduParser.parseEncodedStringValue(pduDataStream);
                    if (null == value) continue block77;
                    try {
                        headers.setEncodedStringValue((EncodedStringValue)value, headerField);
                        break;
                    }
                    catch (NullPointerException e) {
                        PduParser.log("null pointer error!");
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Encoded-String-Value header field!");
                        return null;
                    }
                }
                case 129: 
                case 130: 
                case 151: {
                    Object value = PduParser.parseEncodedStringValue(pduDataStream);
                    if (null == value) continue block77;
                    byte[] address = ((EncodedStringValue)value).getTextString();
                    if (null != address) {
                        String str = new String(address);
                        int endIndex = str.indexOf("/");
                        if (endIndex > 0) {
                            str = str.substring(0, endIndex);
                        }
                        try {
                            ((EncodedStringValue)value).setTextString(str.getBytes());
                        }
                        catch (NullPointerException e) {
                            PduParser.log("null pointer error!");
                            return null;
                        }
                    }
                    try {
                        headers.appendEncodedStringValue((EncodedStringValue)value, headerField);
                        break;
                    }
                    catch (NullPointerException e) {
                        PduParser.log("null pointer error!");
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Encoded-String-Value header field!");
                        return null;
                    }
                }
                case 135: 
                case 136: 
                case 157: {
                    long timeValue;
                    PduParser.parseValueLength(pduDataStream);
                    int token = PduParser.extractByteValue(pduDataStream);
                    try {
                        timeValue = PduParser.parseLongInteger(pduDataStream);
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Long-Integer header field!");
                        return null;
                    }
                    if (129 == token) {
                        timeValue = CachedMillisecondClock.INS.now() / 1000L + timeValue;
                    }
                    try {
                        headers.setLongInteger(timeValue, headerField);
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Long-Integer header field!");
                        return null;
                    }
                }
                case 137: {
                    EncodedStringValue from = null;
                    PduParser.parseValueLength(pduDataStream);
                    int fromToken = PduParser.extractByteValue(pduDataStream);
                    if (128 == fromToken) {
                        byte[] address;
                        from = PduParser.parseEncodedStringValue(pduDataStream);
                        if (null != from && null != (address = from.getTextString())) {
                            String str = new String(address);
                            int endIndex = str.indexOf("/");
                            if (endIndex > 0) {
                                str = str.substring(0, endIndex);
                            }
                            try {
                                from.setTextString(str.getBytes());
                            }
                            catch (NullPointerException e) {
                                PduParser.log("null pointer error!");
                                return null;
                            }
                        }
                    } else {
                        try {
                            from = new EncodedStringValue("insert-address-token".getBytes());
                        }
                        catch (NullPointerException e) {
                            PduParser.log(headerField + "is not Encoded-String-Value header field!");
                            return null;
                        }
                    }
                    try {
                        headers.setEncodedStringValue(from, 137);
                        break;
                    }
                    catch (NullPointerException e) {
                        PduParser.log("null pointer error!");
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Encoded-String-Value header field!");
                        return null;
                    }
                }
                case 138: {
                    pduDataStream.mark(1);
                    int messageClass = PduParser.extractByteValue(pduDataStream);
                    if (messageClass >= 128) {
                        try {
                            if (128 == messageClass) {
                                headers.setTextString("personal".getBytes(), 138);
                                break;
                            }
                            if (129 == messageClass) {
                                headers.setTextString("advertisement".getBytes(), 138);
                                break;
                            }
                            if (130 == messageClass) {
                                headers.setTextString("informational".getBytes(), 138);
                                break;
                            }
                            if (131 != messageClass) continue block77;
                            headers.setTextString("auto".getBytes(), 138);
                            break;
                        }
                        catch (NullPointerException e) {
                            PduParser.log("null pointer error!");
                            break;
                        }
                        catch (RuntimeException e) {
                            PduParser.log(headerField + "is not Text-String header field!");
                            return null;
                        }
                    }
                    pduDataStream.reset();
                    byte[] messageClassString = PduParser.parseWapString(pduDataStream, 0);
                    if (null == messageClassString) continue block77;
                    try {
                        headers.setTextString(messageClassString, 138);
                        break;
                    }
                    catch (NullPointerException e) {
                        PduParser.log("null pointer error!");
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Text-String header field!");
                        return null;
                    }
                }
                case 141: {
                    int version = PduParser.parseShortInteger(pduDataStream);
                    try {
                        headers.setOctet(version, 141);
                        break;
                    }
                    catch (InvalidHeaderValueException e) {
                        PduParser.log("Set invalid Octet value: " + version + " into the header filed: " + headerField);
                        return null;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Octet header field!");
                        return null;
                    }
                }
                case 160: {
                    PduParser.parseValueLength(pduDataStream);
                    try {
                        PduParser.parseIntegerValue(pduDataStream);
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + " is not Integer-Value");
                        return null;
                    }
                    EncodedStringValue previouslySentBy = PduParser.parseEncodedStringValue(pduDataStream);
                    if (null == previouslySentBy) continue block77;
                    try {
                        headers.setEncodedStringValue(previouslySentBy, 160);
                        break;
                    }
                    catch (NullPointerException e) {
                        PduParser.log("null pointer error!");
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Encoded-String-Value header field!");
                        return null;
                    }
                }
                case 161: {
                    PduParser.parseValueLength(pduDataStream);
                    try {
                        PduParser.parseIntegerValue(pduDataStream);
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + " is not Integer-Value");
                        return null;
                    }
                    try {
                        long perviouslySentDate = PduParser.parseLongInteger(pduDataStream);
                        headers.setLongInteger(perviouslySentDate, 161);
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + "is not Long-Integer header field!");
                        return null;
                    }
                }
                case 164: {
                    PduParser.parseValueLength(pduDataStream);
                    PduParser.extractByteValue(pduDataStream);
                    PduParser.parseEncodedStringValue(pduDataStream);
                    break;
                }
                case 170: 
                case 172: {
                    PduParser.parseValueLength(pduDataStream);
                    PduParser.extractByteValue(pduDataStream);
                    try {
                        PduParser.parseIntegerValue(pduDataStream);
                        break;
                    }
                    catch (RuntimeException e) {
                        PduParser.log(headerField + " is not Integer-Value");
                        return null;
                    }
                }
                case 178: {
                    PduParser.parseContentType(pduDataStream, null);
                    break;
                }
                case 132: {
                    HashMap<Integer, Object> map = new HashMap<Integer, Object>();
                    byte[] contentType = PduParser.parseContentType(pduDataStream, map);
                    if (null != contentType) {
                        try {
                            headers.setTextString(contentType, 132);
                        }
                        catch (NullPointerException e) {
                            PduParser.log("null pointer error!");
                        }
                        catch (RuntimeException e) {
                            PduParser.log(headerField + "is not Text-String header field!");
                            return null;
                        }
                    }
                    mStartParam = (byte[])map.get(153);
                    mTypeParam = (byte[])map.get(131);
                    keepParsing = false;
                    break;
                }
                default: {
                    PduParser.log("Unknown header");
                }
            }
        }
        return headers;
    }

    protected static PduBody parseParts(ByteArrayInputStream pduDataStream) {
        if (pduDataStream == null) {
            return null;
        }
        int count = PduParser.parseUnsignedInt(pduDataStream);
        PduBody body = new PduBody();
        for (int i = 0; i < count; ++i) {
            int endPos;
            int partHeaderLen;
            Integer charset;
            int headerLength = PduParser.parseUnsignedInt(pduDataStream);
            int dataLength = PduParser.parseUnsignedInt(pduDataStream);
            PduPart part = new PduPart();
            int startPos = pduDataStream.available();
            if (startPos <= 0) {
                return null;
            }
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            byte[] contentType = PduParser.parseContentType(pduDataStream, map);
            if (null != contentType) {
                part.setContentType(contentType);
            } else {
                part.setContentType(PduContentTypes.contentTypes[0].getBytes());
            }
            byte[] name = (byte[])map.get(151);
            if (null != name) {
                part.setName(name);
            }
            if (null != (charset = (Integer)map.get(129))) {
                part.setCharset(charset);
            }
            if ((partHeaderLen = headerLength - (startPos - (endPos = pduDataStream.available()))) > 0 ? false == PduParser.parsePartHeaders(pduDataStream, part, partHeaderLen) : partHeaderLen < 0) {
                return null;
            }
            if (null == part.getContentLocation() && null == part.getName() && null == part.getFilename() && null == part.getContentId()) {
                part.setContentLocation(Long.toOctalString(CachedMillisecondClock.INS.now()).getBytes());
            }
            if (dataLength > 0) {
                byte[] partData = new byte[dataLength];
                String partContentType = new String(part.getContentType());
                int reallength = pduDataStream.read(partData, 0, dataLength);
                if (reallength < dataLength) {
                    byte[] tmp = new byte[reallength];
                    System.arraycopy(partData, 0, tmp, 0, reallength);
                    partData = tmp;
                }
                if (partContentType.equalsIgnoreCase("application/vnd.wap.multipart.alternative")) {
                    PduBody childBody = PduParser.parseParts(new ByteArrayInputStream(partData));
                    part = childBody.getPart(0);
                } else {
                    byte[] partDataEncoding = part.getContentTransferEncoding();
                    if (null != partDataEncoding) {
                        String encoding = new String(partDataEncoding);
                        if (encoding.equalsIgnoreCase("base64")) {
                            partData = Base64.decodeBase64((byte[])partData);
                        } else if (encoding.equalsIgnoreCase("quoted-printable")) {
                            partData = QuotedPrintable.decodeQuotedPrintable(partData);
                        }
                    }
                    if (null == partData) {
                        logger.warn("Decode part data error!");
                        return null;
                    }
                    part.setData(partData);
                }
            }
            if (0 == PduParser.checkPartPosition(part)) {
                body.addPart(0, part);
                continue;
            }
            body.addPart(part);
        }
        return body;
    }

    protected static int parseUnsignedInt(ByteArrayInputStream pduDataStream) {
        assert (null != pduDataStream);
        int result = 0;
        int temp = pduDataStream.read();
        if (temp == -1) {
            return temp;
        }
        while ((temp & 0x80) != 0) {
            result <<= 7;
            result |= temp & 0x7F;
            temp = pduDataStream.read();
            if (temp != -1) continue;
            return temp;
        }
        result <<= 7;
        return result |= temp & 0x7F;
    }

    protected static int parseValueLength(ByteArrayInputStream pduDataStream) {
        assert (null != pduDataStream);
        int temp = pduDataStream.read();
        assert (-1 != temp);
        int first = temp & 0xFF;
        if (first <= 30) {
            return first;
        }
        if (first == 31) {
            return PduParser.parseUnsignedInt(pduDataStream);
        }
        throw new RuntimeException("Value length > LENGTH_QUOTE!");
    }

    protected static EncodedStringValue parseEncodedStringValue(ByteArrayInputStream pduDataStream) {
        assert (null != pduDataStream);
        pduDataStream.mark(1);
        EncodedStringValue returnValue = null;
        int charset = 0;
        int temp = pduDataStream.read();
        assert (-1 != temp);
        int first = temp & 0xFF;
        pduDataStream.reset();
        if (first < 32) {
            PduParser.parseValueLength(pduDataStream);
            charset = PduParser.parseShortInteger(pduDataStream);
        }
        byte[] textString = PduParser.parseWapString(pduDataStream, 0);
        try {
            returnValue = 0 != charset ? new EncodedStringValue(charset, textString) : new EncodedStringValue(textString);
        }
        catch (Exception e) {
            return null;
        }
        return returnValue;
    }

    protected static byte[] parseWapString(ByteArrayInputStream pduDataStream, int stringType) {
        assert (null != pduDataStream);
        pduDataStream.mark(1);
        int temp = pduDataStream.read();
        assert (-1 != temp);
        if (1 == stringType && 34 == temp) {
            pduDataStream.mark(1);
        } else if (0 == stringType && 127 == temp) {
            pduDataStream.mark(1);
        } else {
            pduDataStream.reset();
        }
        return PduParser.getWapString(pduDataStream, stringType);
    }

    protected static boolean isTokenCharacter(int ch) {
        if (ch < 33 || ch > 126) {
            return false;
        }
        switch (ch) {
            case 34: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 92: 
            case 93: 
            case 123: 
            case 125: {
                return false;
            }
        }
        return true;
    }

    protected static boolean isText(int ch) {
        if (ch >= 32 && ch <= 126 || ch >= 128 && ch <= 255) {
            return true;
        }
        switch (ch) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    protected static byte[] getWapString(ByteArrayInputStream pduDataStream, int stringType) {
        assert (null != pduDataStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int temp = pduDataStream.read();
        assert (-1 != temp);
        while (-1 != temp && 0 != temp) {
            if (stringType == 2) {
                if (PduParser.isTokenCharacter(temp)) {
                    out.write(temp);
                }
            } else if (PduParser.isText(temp)) {
                out.write(temp);
            }
            temp = pduDataStream.read();
            assert (-1 != temp);
        }
        if (out.size() > 0) {
            return out.toByteArray();
        }
        return null;
    }

    protected static int extractByteValue(ByteArrayInputStream pduDataStream) {
        assert (null != pduDataStream);
        int temp = pduDataStream.read();
        assert (-1 != temp);
        return temp & 0xFF;
    }

    protected static int parseShortInteger(ByteArrayInputStream pduDataStream) {
        assert (null != pduDataStream);
        int temp = pduDataStream.read();
        assert (-1 != temp);
        return temp & 0x7F;
    }

    protected static long parseLongInteger(ByteArrayInputStream pduDataStream) {
        assert (null != pduDataStream);
        int temp = pduDataStream.read();
        assert (-1 != temp);
        int count = temp & 0xFF;
        if (count > 8) {
            throw new RuntimeException("Octet count greater than 8 and I can't represent that!");
        }
        long result = 0L;
        for (int i = 0; i < count; ++i) {
            temp = pduDataStream.read();
            assert (-1 != temp);
            result <<= 8;
            result += (long)(temp & 0xFF);
        }
        return result;
    }

    protected static long parseIntegerValue(ByteArrayInputStream pduDataStream) {
        assert (null != pduDataStream);
        pduDataStream.mark(1);
        int temp = pduDataStream.read();
        assert (-1 != temp);
        pduDataStream.reset();
        if (temp > 127) {
            return PduParser.parseShortInteger(pduDataStream);
        }
        return PduParser.parseLongInteger(pduDataStream);
    }

    protected static int skipWapValue(ByteArrayInputStream pduDataStream, int length) {
        assert (null != pduDataStream);
        byte[] area = new byte[length];
        int readLen = pduDataStream.read(area, 0, length);
        if (readLen < length) {
            return -1;
        }
        return readLen;
    }

    protected static void parseContentTypeParams(ByteArrayInputStream pduDataStream, HashMap<Integer, Object> map, Integer length) {
        assert (null != pduDataStream);
        assert (length > 0);
        int startPos = pduDataStream.available();
        int tempPos = 0;
        int lastLen = length;
        block8: while (0 < lastLen) {
            int param = pduDataStream.read();
            assert (-1 != param);
            --lastLen;
            switch (param) {
                case 131: 
                case 137: {
                    pduDataStream.mark(1);
                    int first = PduParser.extractByteValue(pduDataStream);
                    pduDataStream.reset();
                    if (first > 127) {
                        int index = PduParser.parseShortInteger(pduDataStream);
                        if (index < PduContentTypes.contentTypes.length) {
                            byte[] type = PduContentTypes.contentTypes[index].getBytes();
                            map.put(131, type);
                        }
                    } else {
                        byte[] type = PduParser.parseWapString(pduDataStream, 0);
                        if (null != type && null != map) {
                            map.put(131, type);
                        }
                    }
                    tempPos = pduDataStream.available();
                    lastLen = length - (startPos - tempPos);
                    continue block8;
                }
                case 138: 
                case 153: {
                    byte[] start = PduParser.parseWapString(pduDataStream, 0);
                    if (null != start && null != map) {
                        map.put(153, start);
                    }
                    tempPos = pduDataStream.available();
                    lastLen = length - (startPos - tempPos);
                    continue block8;
                }
                case 129: {
                    pduDataStream.mark(1);
                    int firstValue = PduParser.extractByteValue(pduDataStream);
                    pduDataStream.reset();
                    if (firstValue > 32 && firstValue < 127 || 0 == firstValue) {
                        byte[] charsetStr = PduParser.parseWapString(pduDataStream, 0);
                        try {
                            int charsetInt = CharacterSets.getMibEnumValue(new String(charsetStr));
                            map.put(129, charsetInt);
                        }
                        catch (UnsupportedEncodingException e) {
                            map.put(129, 0);
                        }
                    } else {
                        int charset = (int)PduParser.parseIntegerValue(pduDataStream);
                        if (map != null) {
                            map.put(129, charset);
                        }
                    }
                    tempPos = pduDataStream.available();
                    lastLen = length - (startPos - tempPos);
                    continue block8;
                }
                case 133: 
                case 151: {
                    byte[] name = PduParser.parseWapString(pduDataStream, 0);
                    if (null != name && null != map) {
                        map.put(151, name);
                    }
                    tempPos = pduDataStream.available();
                    lastLen = length - (startPos - tempPos);
                    continue block8;
                }
            }
            if (-1 == PduParser.skipWapValue(pduDataStream, lastLen)) continue;
            lastLen = 0;
        }
        if (0 != lastLen) {
            // empty if block
        }
    }

    protected static byte[] parseContentType(ByteArrayInputStream pduDataStream, HashMap<Integer, Object> map) {
        assert (null != pduDataStream);
        byte[] contentType = null;
        pduDataStream.mark(1);
        int temp = pduDataStream.read();
        assert (-1 != temp);
        pduDataStream.reset();
        int cur = temp & 0xFF;
        if (cur < 32) {
            int length = PduParser.parseValueLength(pduDataStream);
            int startPos = pduDataStream.available();
            pduDataStream.mark(1);
            temp = pduDataStream.read();
            assert (-1 != temp);
            pduDataStream.reset();
            int first = temp & 0xFF;
            if (first >= 32 && first <= 127) {
                contentType = PduParser.parseWapString(pduDataStream, 0);
            } else if (first > 127) {
                int index = PduParser.parseShortInteger(pduDataStream);
                if (index < PduContentTypes.contentTypes.length) {
                    contentType = PduContentTypes.contentTypes[index].getBytes();
                } else {
                    pduDataStream.reset();
                    contentType = PduParser.parseWapString(pduDataStream, 0);
                }
            } else {
                return PduContentTypes.contentTypes[0].getBytes();
            }
            int endPos = pduDataStream.available();
            int parameterLen = length - (startPos - endPos);
            if (parameterLen > 0) {
                PduParser.parseContentTypeParams(pduDataStream, map, parameterLen);
            }
            if (parameterLen < 0) {
                return PduContentTypes.contentTypes[0].getBytes();
            }
        } else {
            contentType = cur <= 127 ? PduParser.parseWapString(pduDataStream, 0) : PduContentTypes.contentTypes[PduParser.parseShortInteger(pduDataStream)].getBytes();
        }
        return contentType;
    }

    protected static boolean parsePartHeaders(ByteArrayInputStream pduDataStream, PduPart part, int length) {
        assert (null != pduDataStream);
        assert (null != part);
        assert (length > 0);
        int startPos = pduDataStream.available();
        int tempPos = 0;
        int lastLen = length;
        block7: while (0 < lastLen) {
            int header = pduDataStream.read();
            assert (-1 != header);
            --lastLen;
            if (header > 127) {
                switch (header) {
                    case 142: {
                        byte[] contentLocation = PduParser.parseWapString(pduDataStream, 0);
                        if (null != contentLocation) {
                            part.setContentLocation(contentLocation);
                        }
                        tempPos = pduDataStream.available();
                        lastLen = length - (startPos - tempPos);
                        break;
                    }
                    case 192: {
                        byte[] contentId = PduParser.parseWapString(pduDataStream, 1);
                        if (null != contentId) {
                            part.setContentId(contentId);
                        }
                        tempPos = pduDataStream.available();
                        lastLen = length - (startPos - tempPos);
                        break;
                    }
                    case 174: 
                    case 197: {
                        boolean contentDisposition = true;
                        if (!contentDisposition) continue block7;
                        int len = -1;
                        boolean validDispositionLength = true;
                        pduDataStream.mark(1);
                        try {
                            len = PduParser.parseValueLength(pduDataStream);
                        }
                        catch (RuntimeException e) {
                            len = 31;
                            validDispositionLength = false;
                            pduDataStream.reset();
                        }
                        pduDataStream.mark(1);
                        int thisStartPos = pduDataStream.available();
                        int thisEndPos = 0;
                        int value = pduDataStream.read();
                        if (validDispositionLength) {
                            if (value == 128) {
                                part.setContentDisposition(PduPart.DISPOSITION_FROM_DATA);
                            } else if (value == 129) {
                                part.setContentDisposition(PduPart.DISPOSITION_ATTACHMENT);
                            } else if (value == 130) {
                                part.setContentDisposition(PduPart.DISPOSITION_INLINE);
                            } else {
                                pduDataStream.reset();
                                part.setContentDisposition(PduParser.parseWapString(pduDataStream, 0));
                            }
                        } else {
                            pduDataStream.reset();
                            part.setContentDisposition(PduParser.parseWapString(pduDataStream, 0));
                        }
                        thisEndPos = pduDataStream.available();
                        if (thisStartPos - thisEndPos < len) {
                            value = pduDataStream.read();
                            if (value == 152) {
                                part.setFilename(PduParser.parseWapString(pduDataStream, 0));
                            }
                            if (thisStartPos - (thisEndPos = pduDataStream.available()) < len) {
                                int last = len - (thisStartPos - thisEndPos);
                                byte[] temp = new byte[last];
                                pduDataStream.read(temp, 0, last);
                            }
                        }
                        tempPos = pduDataStream.available();
                        lastLen = length - (startPos - tempPos);
                        break;
                    }
                    default: {
                        if (-1 == PduParser.skipWapValue(pduDataStream, lastLen)) {
                            return false;
                        }
                        lastLen = 0;
                        break;
                    }
                }
                continue;
            }
            if (header >= 32 && header <= 127) {
                byte[] tempHeader = PduParser.parseWapString(pduDataStream, 0);
                byte[] tempValue = PduParser.parseWapString(pduDataStream, 0);
                if ("Content-Transfer-Encoding".equalsIgnoreCase(new String(tempHeader))) {
                    part.setContentTransferEncoding(tempValue);
                }
                tempPos = pduDataStream.available();
                lastLen = length - (startPos - tempPos);
                continue;
            }
            if (-1 == PduParser.skipWapValue(pduDataStream, lastLen)) {
                return false;
            }
            lastLen = 0;
        }
        return 0 == lastLen;
    }

    private static int checkPartPosition(PduPart part) {
        byte[] contentType;
        byte[] contentId;
        assert (null != part);
        if (null == mTypeParam && null == mStartParam) {
            return 1;
        }
        if (null != mStartParam && null != (contentId = part.getContentId()) && Arrays.equals(mStartParam, contentId)) {
            return 0;
        }
        if (null != mTypeParam && null != (contentType = part.getContentType()) && Arrays.equals(mTypeParam, contentType)) {
            return 0;
        }
        return 1;
    }

    protected static boolean checkMandatoryHeader(PduHeaders headers) {
        if (null == headers) {
            return false;
        }
        int messageType = headers.getOctet(140);
        int mmsVersion = headers.getOctet(141);
        if (0 == mmsVersion) {
            return false;
        }
        switch (messageType) {
            case 128: {
                byte[] srContentType = headers.getTextString(132);
                if (null == srContentType) {
                    return false;
                }
                EncodedStringValue srFrom = headers.getEncodedStringValue(137);
                if (null == srFrom) {
                    return false;
                }
                byte[] srTransactionId = headers.getTextString(152);
                if (null != srTransactionId) break;
                return false;
            }
            case 129: {
                int scResponseStatus = headers.getOctet(146);
                if (0 == scResponseStatus) {
                    return false;
                }
                byte[] scTransactionId = headers.getTextString(152);
                if (null != scTransactionId) break;
                return false;
            }
            case 130: {
                byte[] niContentLocation = headers.getTextString(131);
                if (null == niContentLocation) {
                    return false;
                }
                long niExpiry = headers.getLongInteger(136);
                if (-1L == niExpiry) {
                    return false;
                }
                byte[] niMessageClass = headers.getTextString(138);
                if (null == niMessageClass) {
                    return false;
                }
                long niMessageSize = headers.getLongInteger(142);
                if (-1L == niMessageSize) {
                    return false;
                }
                byte[] niTransactionId = headers.getTextString(152);
                if (null != niTransactionId) break;
                return false;
            }
            case 131: {
                int nriStatus = headers.getOctet(149);
                if (0 == nriStatus) {
                    return false;
                }
                byte[] nriTransactionId = headers.getTextString(152);
                if (null != nriTransactionId) break;
                return false;
            }
            case 132: {
                byte[] rcContentType = headers.getTextString(132);
                if (null == rcContentType) {
                    return false;
                }
                long rcDate = headers.getLongInteger(133);
                if (-1L != rcDate) break;
                return false;
            }
            case 134: {
                long diDate = headers.getLongInteger(133);
                if (-1L == diDate) {
                    return false;
                }
                byte[] diMessageId = headers.getTextString(139);
                if (null == diMessageId) {
                    return false;
                }
                int diStatus = headers.getOctet(149);
                if (0 == diStatus) {
                    return false;
                }
                EncodedStringValue[] diTo = headers.getEncodedStringValues(151);
                if (null != diTo) break;
                return false;
            }
            case 133: {
                byte[] aiTransactionId = headers.getTextString(152);
                if (null != aiTransactionId) break;
                return false;
            }
            case 136: {
                long roDate = headers.getLongInteger(133);
                if (-1L == roDate) {
                    return false;
                }
                EncodedStringValue roFrom = headers.getEncodedStringValue(137);
                if (null == roFrom) {
                    return false;
                }
                byte[] roMessageId = headers.getTextString(139);
                if (null == roMessageId) {
                    return false;
                }
                int roReadStatus = headers.getOctet(155);
                if (0 == roReadStatus) {
                    return false;
                }
                EncodedStringValue[] roTo = headers.getEncodedStringValues(151);
                if (null != roTo) break;
                return false;
            }
            case 135: {
                EncodedStringValue rrFrom = headers.getEncodedStringValue(137);
                if (null == rrFrom) {
                    return false;
                }
                byte[] rrMessageId = headers.getTextString(139);
                if (null == rrMessageId) {
                    return false;
                }
                int rrReadStatus = headers.getOctet(155);
                if (0 == rrReadStatus) {
                    return false;
                }
                EncodedStringValue[] rrTo = headers.getEncodedStringValues(151);
                if (null != rrTo) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

