/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp;

import com.zx.sms.codec.cmpp.msg.CmppActiveTestResponseMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.CmppActiveTestResponse;
import com.zx.sms.codec.cmpp.packet.CmppPacketType;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.common.util.NettyByteBufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class CmppActiveTestResponseMessageCodec
extends MessageToMessageCodec<Message, CmppActiveTestResponseMessage> {
    private PacketType packetType;

    public CmppActiveTestResponseMessageCodec() {
        this(CmppPacketType.CMPPACTIVETESTRESPONSE);
    }

    public CmppActiveTestResponseMessageCodec(PacketType packetType) {
        this.packetType = packetType;
    }

    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        int commandId = msg.getHeader().getCommandId();
        if (this.packetType.getCommandId() != commandId) {
            out.add(msg);
            return;
        }
        CmppActiveTestResponseMessage responseMessage = new CmppActiveTestResponseMessage(msg.getHeader());
        ByteBuf bodyBuffer = Unpooled.wrappedBuffer((byte[])msg.getBodyBuffer());
        if (bodyBuffer.readableBytes() > 0) {
            responseMessage.setReserved(bodyBuffer.readByte());
        }
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(responseMessage);
    }

    protected void encode(ChannelHandlerContext ctx, CmppActiveTestResponseMessage msg, List<Object> out) throws Exception {
        ByteBuf bodyBuffer = ctx.alloc().buffer(CmppActiveTestResponse.RESERVED.getBodyLength());
        bodyBuffer.writeByte((int)msg.getReserved());
        msg.setBodyBuffer(NettyByteBufUtil.toArray(bodyBuffer, bodyBuffer.readableBytes()));
        msg.getHeader().setBodyLength(msg.getBodyBuffer().length);
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(msg);
    }
}

