/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.msg;

import com.zx.sms.BaseMessage;
import com.zx.sms.codec.cmpp.msg.DefaultHeader;
import com.zx.sms.codec.cmpp.msg.Header;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.cmpp.wap.UniqueLongMsgId;
import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import java.io.Serializable;

public class DefaultMessage
implements Message,
Cloneable {
    private static final long serialVersionUID = -4245789758843785127L;
    private PacketType packetType;
    private long timestamp = CachedMillisecondClock.INS.now();
    private long lifeTime = 0L;
    private Message request;
    private Header header;
    private byte[] buffer;
    private UniqueLongMsgId uniqueLongMsgId;
    private Serializable attachment;

    public DefaultMessage() {
    }

    public DefaultMessage(PacketType packetType, Header header) {
        this.setPacketType(packetType);
        if (header == null) {
            header = new DefaultHeader();
            header.setSequenceId(DefaultSequenceNumberUtil.getSequenceNo());
        }
        header.setCommandId(packetType.getCommandId());
        this.setHeader(header);
    }

    public DefaultMessage(PacketType packetType) {
        this(packetType, DefaultSequenceNumberUtil.getSequenceNo());
    }

    public DefaultMessage(PacketType packetType, int sequenceId) {
        this.setPacketType(packetType);
        DefaultHeader header = new DefaultHeader();
        header.setSequenceId(sequenceId);
        header.setCommandId(packetType.getCommandId());
        this.setHeader(header);
    }

    @Override
    public void setPacketType(PacketType packetType) {
        this.packetType = packetType;
    }

    @Override
    public PacketType getPacketType() {
        return this.packetType;
    }

    @Override
    public void setHeader(Header header) {
        this.header = header;
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void setBodyBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte[] getBodyBuffer() {
        return this.buffer;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public long getLifeTime() {
        return this.lifeTime;
    }

    @Override
    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    public String toString() {
        return "DefaultMessage [packetType=" + this.packetType + ", header=" + this.header + ", getClass()=" + this.getClass() + "]";
    }

    @Override
    public boolean isTerminated() {
        return this.lifeTime != 0L && this.timestamp + this.lifeTime * 1000L - CachedMillisecondClock.INS.now() < 0L;
    }

    @Override
    public Serializable getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Serializable attachment) {
        this.attachment = attachment;
    }

    protected DefaultMessage clone() throws CloneNotSupportedException {
        DefaultMessage msg = (DefaultMessage)super.clone();
        DefaultHeader newHeader = new DefaultHeader();
        newHeader.setNodeId(this.header.getNodeId());
        newHeader.setSequenceId(this.header.getSequenceId());
        newHeader.setCommandId(this.packetType.getCommandId());
        msg.setHeader(newHeader);
        msg.setTimestamp(CachedMillisecondClock.INS.now());
        return msg;
    }

    @Override
    public boolean isRequest() {
        long commandId = this.getHeader().getCommandId();
        return (commandId & 0x80000000L) == 0L;
    }

    @Override
    public boolean isResponse() {
        long commandId = this.getHeader().getCommandId();
        return (commandId & 0x80000000L) == 0x80000000L;
    }

    @Override
    public void setRequest(BaseMessage message) {
        this.request = (Message)message;
    }

    @Override
    public BaseMessage getRequest() {
        return this.request;
    }

    @Override
    public int getSequenceNo() {
        return this.getHeader().getSequenceId();
    }

    @Override
    public void setSequenceNo(int seq) {
        this.getHeader().setSequenceId(seq);
    }

    protected UniqueLongMsgId getUniqueLongMsgId() {
        return this.uniqueLongMsgId;
    }

    protected void setUniqueLongMsgId(UniqueLongMsgId uniqueLongMsgId) {
        this.uniqueLongMsgId = uniqueLongMsgId;
    }
}

