/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.packet;

import com.zx.sms.codec.cmpp.packet.CmppDataType;
import com.zx.sms.codec.cmpp.packet.DataType;
import com.zx.sms.codec.cmpp.packet.PacketStructure;

public enum CmppConnectRequest implements PacketStructure
{
    SOURCEADDR(CmppDataType.OCTERSTRING, true, 6),
    AUTHENTICATORSOURCE(CmppDataType.OCTERSTRING, true, 16),
    VERSION(CmppDataType.UNSIGNEDINT, true, 1),
    TIMESTAMP(CmppDataType.UNSIGNEDINT, true, 4);

    private DataType dataType;
    private boolean isFixFiledLength;
    private int length;
    private static final int bodyLength;

    private CmppConnectRequest(DataType dataType, boolean isFixFiledLength, int length) {
        this.dataType = dataType;
        this.isFixFiledLength = isFixFiledLength;
        this.length = length;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isFixFiledLength() {
        return this.isFixFiledLength;
    }

    @Override
    public boolean isFixPacketLength() {
        return true;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getBodyLength() {
        return bodyLength;
    }

    static {
        bodyLength = CmppConnectRequest.SOURCEADDR.length + CmppConnectRequest.AUTHENTICATORSOURCE.length + CmppConnectRequest.VERSION.length + CmppConnectRequest.TIMESTAMP.length;
    }
}

