/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.packet;

import com.zx.sms.codec.cmpp.CmppActiveTestRequestMessageCodec;
import com.zx.sms.codec.cmpp.CmppActiveTestResponseMessageCodec;
import com.zx.sms.codec.cmpp.CmppCancelRequestMessageCodec;
import com.zx.sms.codec.cmpp.CmppCancelResponseMessageCodec;
import com.zx.sms.codec.cmpp.CmppConnectRequestMessageCodec;
import com.zx.sms.codec.cmpp.CmppConnectResponseMessageCodec;
import com.zx.sms.codec.cmpp.CmppDeliverRequestMessageCodec;
import com.zx.sms.codec.cmpp.CmppDeliverResponseMessageCodec;
import com.zx.sms.codec.cmpp.CmppQueryRequestMessageCodec;
import com.zx.sms.codec.cmpp.CmppQueryResponseMessageCodec;
import com.zx.sms.codec.cmpp.CmppSubmitRequestMessageCodec;
import com.zx.sms.codec.cmpp.CmppSubmitResponseMessageCodec;
import com.zx.sms.codec.cmpp.CmppTerminateRequestMessageCodec;
import com.zx.sms.codec.cmpp.CmppTerminateResponseMessageCodec;
import com.zx.sms.codec.cmpp.packet.CmppActiveTestRequest;
import com.zx.sms.codec.cmpp.packet.CmppActiveTestResponse;
import com.zx.sms.codec.cmpp.packet.CmppCancelRequest;
import com.zx.sms.codec.cmpp.packet.CmppCancelResponse;
import com.zx.sms.codec.cmpp.packet.CmppConnectRequest;
import com.zx.sms.codec.cmpp.packet.CmppConnectResponse;
import com.zx.sms.codec.cmpp.packet.CmppDeliverRequest;
import com.zx.sms.codec.cmpp.packet.CmppDeliverResponse;
import com.zx.sms.codec.cmpp.packet.CmppQueryRequest;
import com.zx.sms.codec.cmpp.packet.CmppQueryResponse;
import com.zx.sms.codec.cmpp.packet.CmppSubmitRequest;
import com.zx.sms.codec.cmpp.packet.CmppSubmitResponse;
import com.zx.sms.codec.cmpp.packet.CmppTerminateRequest;
import com.zx.sms.codec.cmpp.packet.CmppTerminateResponse;
import com.zx.sms.codec.cmpp.packet.PacketStructure;
import com.zx.sms.codec.cmpp.packet.PacketType;
import io.netty.handler.codec.MessageToMessageCodec;

public enum CmppPacketType implements PacketType
{
    CMPPCONNECTREQUEST(1, CmppConnectRequest.class, CmppConnectRequestMessageCodec.class),
    CMPPCONNECTRESPONSE(-2147483647, CmppConnectResponse.class, CmppConnectResponseMessageCodec.class),
    CMPPTERMINATEREQUEST(2, CmppTerminateRequest.class, CmppTerminateRequestMessageCodec.class),
    CMPPTERMINATERESPONSE(-2147483646, CmppTerminateResponse.class, CmppTerminateResponseMessageCodec.class),
    CMPPSUBMITREQUEST(4, CmppSubmitRequest.class, CmppSubmitRequestMessageCodec.class),
    CMPPSUBMITRESPONSE(-2147483644, CmppSubmitResponse.class, CmppSubmitResponseMessageCodec.class),
    CMPPDELIVERREQUEST(5, CmppDeliverRequest.class, CmppDeliverRequestMessageCodec.class),
    CMPPDELIVERRESPONSE(-2147483643, CmppDeliverResponse.class, CmppDeliverResponseMessageCodec.class),
    CMPPQUERYREQUEST(6, CmppQueryRequest.class, CmppQueryRequestMessageCodec.class),
    CMPPQUERYRESPONSE(-2147483642, CmppQueryResponse.class, CmppQueryResponseMessageCodec.class),
    CMPPCANCELREQUEST(7, CmppCancelRequest.class, CmppCancelRequestMessageCodec.class),
    CMPPCANCELRESPONSE(-2147483641, CmppCancelResponse.class, CmppCancelResponseMessageCodec.class),
    CMPPACTIVETESTREQUEST(8, CmppActiveTestRequest.class, CmppActiveTestRequestMessageCodec.class),
    CMPPACTIVETESTRESPONSE(-2147483640, CmppActiveTestResponse.class, CmppActiveTestResponseMessageCodec.class);

    private int commandId;
    private Class<? extends PacketStructure> packetStructure;
    private Class<? extends MessageToMessageCodec> codec;

    private CmppPacketType(int commandId, Class<? extends PacketStructure> packetStructure, Class<? extends MessageToMessageCodec> codec) {
        this.commandId = commandId;
        this.packetStructure = packetStructure;
        this.codec = codec;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    @Override
    public PacketStructure[] getPacketStructures() {
        return this.packetStructure.getEnumConstants();
    }

    @Override
    public long getAllCommandId() {
        long defaultId = 0L;
        long allCommandId = 0L;
        for (CmppPacketType packetType : CmppPacketType.values()) {
            allCommandId |= (long)packetType.commandId;
        }
        return allCommandId ^ defaultId;
    }

    @Override
    public MessageToMessageCodec getCodec() {
        try {
            return this.codec.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

