/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.wap;

import com.zx.sms.BaseMessage;
import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.codec.cmpp.wap.SmsMessageHolder;
import com.zx.sms.codec.cmpp.wap.UniqueLongMsgId;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.connect.manager.EndpointEntity;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.marre.sms.SmsConcatMessage;
import org.marre.sms.SmsMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLongMessageHandler<T extends BaseMessage>
extends MessageToMessageCodec<T, T> {
    private final Logger logger = LoggerFactory.getLogger(AbstractLongMessageHandler.class);
    private EndpointEntity entity;

    public AbstractLongMessageHandler(EndpointEntity entity) {
        this.entity = entity;
    }

    protected void decode(ChannelHandlerContext ctx, T msg, List<Object> out) throws Exception {
        if ((this.entity == null || this.entity.getSupportLongmsg() == EndpointEntity.SupportLongMessage.BOTH || this.entity.getSupportLongmsg() == EndpointEntity.SupportLongMessage.RECV) && msg instanceof LongSMSMessage && ((LongSMSMessage)msg).needHandleLongMessage()) {
            LongSMSMessage lmsg = (LongSMSMessage)msg;
            UniqueLongMsgId uniqueId = lmsg.getUniqueLongMsgId();
            try {
                SmsMessageHolder hoder = LongMessageFrameHolder.INS.putAndget(this.entity, uniqueId.getId(), lmsg, this.entity != null && this.entity.isRecvLongMsgOnMultiLink());
                if (hoder != null) {
                    uniqueId.clearCacheKey();
                    this.resetMessageContent((BaseMessage)((Object)hoder.msg), hoder.smsMessage);
                    out.add(hoder.msg);
                }
            }
            catch (Exception ex) {
                this.logger.error("Decode Message Error ,entity : {} ,uniqueId : {} , msg dump :{}", new Object[]{this.entity.getId(), uniqueId, ByteBufUtil.hexDump((byte[])lmsg.generateFrame().getMsgContentBytes())});
            }
        } else {
            out.add(msg);
        }
    }

    protected void encode(ChannelHandlerContext ctx, T requestMessage, List<Object> out) throws Exception {
        if ((this.entity == null || this.entity.getSupportLongmsg() == EndpointEntity.SupportLongMessage.BOTH || this.entity.getSupportLongmsg() == EndpointEntity.SupportLongMessage.SEND) && requestMessage instanceof LongSMSMessage && ((LongSMSMessage)requestMessage).needHandleLongMessage()) {
            LongSMSMessage lmsg = (LongSMSMessage)requestMessage;
            SmsMessage msgcontent = lmsg.getSmsMessage();
            if (msgcontent instanceof SmsConcatMessage) {
                ((SmsConcatMessage)msgcontent).setSeqNoKey(lmsg.getSrcIdAndDestId());
            }
            List<LongMessageFrame> frameList = LongMessageFrameHolder.INS.splitmsgcontent(msgcontent);
            UniqueLongMsgId uniqueId = null;
            for (LongMessageFrame frame : frameList) {
                LongSMSMessage t = (LongSMSMessage)lmsg.generateMessage(frame);
                if (uniqueId == null) {
                    uniqueId = new UniqueLongMsgId(this.entity, ctx.channel(), t, DefaultSequenceNumberUtil.getSequenceNo(), false);
                    t.setUniqueLongMsgId(uniqueId);
                } else {
                    frame.setTimestamp(((BaseMessage)((Object)t)).getTimestamp());
                    frame.setSequence(((BaseMessage)((Object)t)).getSequenceNo());
                    t.setUniqueLongMsgId(new UniqueLongMsgId(uniqueId, frame));
                }
                out.add(t);
            }
        } else {
            out.add(requestMessage);
        }
    }

    protected abstract void resetMessageContent(T var1, SmsMessage var2);
}

