/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.wap;

import com.zx.sms.codec.cmpp.wap.InformationElement;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.common.NotSupportedException;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.CachedMillisecondClock;
import java.util.BitSet;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.marre.sms.AbstractSmsDcs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FrameHolder {
    private static final Logger logger = LoggerFactory.getLogger(FrameHolder.class);
    private String serviceNum;
    private int sequence;
    private long timestamp = CachedMillisecondClock.INS.now();
    private int totalLength = 0;
    int frameKey;
    private byte[][] content;
    private int totalbyteLength = 0;
    private BitSet idxBitset;
    private AbstractSmsDcs msgfmt;
    private InformationElement appUDHinfo;

    public void setAppUDHinfo(InformationElement appUDHinfo) {
        this.appUDHinfo = appUDHinfo;
    }

    public InformationElement getAppUDHinfo() {
        return this.appUDHinfo;
    }

    public void setServiceNum(String serviceNum) {
        this.serviceNum = serviceNum;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public FrameHolder(int frameKey, int totalLength) {
        this.frameKey = frameKey;
        this.totalLength = totalLength;
        this.content = new byte[totalLength][];
        this.idxBitset = new BitSet(totalLength);
    }

    public synchronized void merge(LongMessageFrame frame, byte[] content, int idx) throws NotSupportedException {
        if (this.idxBitset.get(idx)) {
            logger.warn("have received the same index:{} of Message seq:{}. do not merge this content.{},origin:{},{},{},new content:{}", new Object[]{idx, frame.getSequence(), this.serviceNum, LongMessageFrameHolder.buildTextMessage(this.content[idx], this.msgfmt).getText(), DateFormatUtils.format((long)this.getTimestamp(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()), this.getSequence(), LongMessageFrameHolder.buildTextMessage(content, this.msgfmt).getText()});
            throw new NotSupportedException("received the same index");
        }
        if (this.content.length <= idx || idx < 0) {
            logger.warn("have received error index:{} of Message seq:{} content length:{}. do not merge this content.{},{},{},{}", new Object[]{idx, frame.getSequence(), this.content.length, this.serviceNum, DateFormatUtils.format((long)this.getTimestamp(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()), this.getSequence(), LongMessageFrameHolder.buildTextMessage(content, this.msgfmt).getText()});
            throw new NotSupportedException("have received error index");
        }
        this.idxBitset.set(idx);
        if (this.msgfmt != null && this.msgfmt.getValue() != frame.getMsgfmt().getValue()) {
            String txt = new String(content, CMPPCommonUtil.switchCharset(frame.getMsgfmt().getAlphabet()));
            this.content[idx] = txt.getBytes(CMPPCommonUtil.switchCharset(this.msgfmt.getAlphabet()));
        } else {
            this.content[idx] = content;
        }
        this.totalbyteLength += this.content[idx].length;
    }

    public synchronized boolean isComplete() {
        return this.totalLength == this.idxBitset.cardinality();
    }

    public synchronized byte[] mergeAllcontent() {
        if (this.totalLength == 1) {
            return this.content[0];
        }
        byte[] ret = new byte[this.totalbyteLength];
        int idx = 0;
        for (int i = 0; i < this.totalLength; ++i) {
            if (this.content[i] == null || this.content[i].length <= 0) continue;
            System.arraycopy(this.content[i], 0, ret, idx, this.content[i].length);
            idx += this.content[i].length;
        }
        return ret;
    }

    public AbstractSmsDcs getMsgfmt() {
        return this.msgfmt;
    }

    public void setMsgfmt(AbstractSmsDcs msgfmt) {
        this.msgfmt = msgfmt;
    }

    public int getTotalLength() {
        return this.totalLength;
    }
}

