/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.wap;

import PduParser.GenericPdu;
import PduParser.NotificationInd;
import PduParser.PduParser;
import com.zx.sms.BaseMessage;
import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.LongMessageFrameCache;
import com.zx.sms.codec.LongMessageFrameProvider;
import com.zx.sms.codec.cmpp.wap.FrameHolder;
import com.zx.sms.codec.cmpp.wap.InformationElement;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameProviderInner;
import com.zx.sms.codec.cmpp.wap.SmsMessageHolder;
import com.zx.sms.codec.cmpp.wap.UniqueLongMsgId;
import com.zx.sms.codec.cmpp.wap.WspTypeDecoder;
import com.zx.sms.codec.smpp.msg.BaseSm;
import com.zx.sms.common.NotSupportedException;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.common.util.StandardCharsets;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.smpp.SMPPEndpointEntity;
import es.rickyepoderi.wbxml.definition.WbXmlInitialization;
import es.rickyepoderi.wbxml.stream.WbXmlInputFactory;
import io.netty.buffer.ByteBufUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXSource;
import org.marre.sms.AbstractSmsDcs;
import org.marre.sms.SmppSmsDcs;
import org.marre.sms.SmsException;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsPdu;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsPort;
import org.marre.sms.SmsPortAddressedTextMessage;
import org.marre.sms.SmsSimTookitSecurityMessage;
import org.marre.sms.SmsTextMessage;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUdhIei;
import org.marre.sms.SmsUserData;
import org.marre.wap.push.SmsMmsNotificationMessage;
import org.marre.wap.push.SmsWapPushMessage;
import org.marre.wap.push.WapSIPush;
import org.marre.wap.push.WapSLPush;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public enum LongMessageFrameHolder {
    INS;

    private static final Logger logger;
    private static LongMessageFrameProvider provider;
    private static LongMessageFrameCache clusterMap;
    private static LongMessageFrameCache jvmMap;
    public static final boolean hasClusterLongMessageFrameProvider;

    private SmsMessage generatorSmsMessage(FrameHolder fh, LongMessageFrame frame) throws NotSupportedException {
        byte[] contents = fh.mergeAllcontent();
        InformationElement udheader = fh.getAppUDHinfo();
        if (udheader == null) {
            return LongMessageFrameHolder.buildTextMessage(contents, fh.getMsgfmt());
        }
        if (SmsUdhIei.APP_PORT_16BIT.equals(udheader.udhIei)) {
            int destport = ((udheader.infoEleData[0] & 0xFF) << 8 | udheader.infoEleData[1] & 0xFF) & 0xFFFF;
            int srcport = ((udheader.infoEleData[2] & 0xFF) << 8 | udheader.infoEleData[3] & 0xFF) & 0xFFFF;
            if (destport == SmsPort.WAP_PUSH.getPort() && srcport == SmsPort.WAP_WSP.getPort()) {
                return this.parseWapPdu(contents);
            }
            if (destport == SmsPort.NOKIA_MULTIPART_MESSAGE.getPort() && srcport == SmsPort.ZERO.getPort()) {
                throw new NotSupportedException("Nokia\u624b\u673a\u652f\u6301\u7684OTA\u56fe\u7247\u683c\u5f0f,\u65e0\u6cd5\u89e3\u6790");
            }
            if (destport == SmsPort.OTA_SETTINGS_BROWSER.getPort()) {
                throw new NotSupportedException("Nokia\u624b\u673a\u652f\u6301\u7684OTA\u6d4f\u89c8\u5668\u4e66\u7b7e,\u65e0\u6cd5\u89e3\u6790");
            }
            logger.warn("UnsupportedportMessage UDH:0x{} udhdata:{},pdu:[{}]", new Object[]{ByteBufUtil.hexDump((byte[])new byte[]{udheader.udhIei.getValue()}), ByteBufUtil.hexDump((byte[])udheader.infoEleData), ByteBufUtil.hexDump((byte[])contents)});
            SmsTextMessage text = LongMessageFrameHolder.buildTextMessage(contents, fh.getMsgfmt());
            return new SmsPortAddressedTextMessage(new SmsPort(destport), new SmsPort(srcport), text);
        }
        if (frame.getTppid() == 127 && (SmsUdhIei.COMMAND_PACKET.equals(udheader.udhIei) || SmsUdhIei.COMMAND_RESPONSE_PACKET.equals(udheader.udhIei))) {
            SmsSimTookitSecurityMessage sts = new SmsSimTookitSecurityMessage(udheader.udhIei.getValue(), udheader.infoEleData, contents);
            return sts;
        }
        logger.warn("Unsupported UDH:0x{} udhdata:{},pdu:[{}]", new Object[]{ByteBufUtil.hexDump((byte[])new byte[]{udheader.udhIei.getValue()}), ByteBufUtil.hexDump((byte[])udheader.infoEleData), ByteBufUtil.hexDump((byte[])contents)});
        return LongMessageFrameHolder.buildTextMessage(contents, fh.getMsgfmt());
    }

    static SmsTextMessage buildTextMessage(byte[] bytes, AbstractSmsDcs msgfmt) {
        String text = null;
        switch (msgfmt.getAlphabet()) {
            case GSM: {
                text = SmsPduUtil.unencodedSeptetsToString(bytes);
                break;
            }
            default: {
                text = new String(bytes, CMPPCommonUtil.switchCharset(msgfmt.getAlphabet()));
            }
        }
        return new SmsTextMessage(text, msgfmt);
    }

    public String getPartTextMsg(LongMessageFrame frame) {
        if (!frame.isConcatMsg()) {
            return LongMessageFrameHolder.buildTextMessage(frame.getPayloadbytes(0), frame.getMsgfmt()).getText();
        }
        UserDataHeader header = this.parseUserDataHeader(frame.getMsgContentBytes());
        byte[] payload = frame.getPayloadbytes(header.headerlength);
        return LongMessageFrameHolder.buildTextMessage(payload, frame.getMsgfmt()).getText();
    }

    public FrameHolder parseFrameKey(LongMessageFrame frame) {
        if (frame.isConcatMsg()) {
            try {
                FrameHolder fh = this.createFrameHolder("", frame);
                return fh;
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
        }
        return null;
    }

    public SmsMessageHolder putAndget(EndpointEntity entity, String longSmsKey, LongSMSMessage msg, boolean isRecvLongMsgOnMultiLink) throws NotSupportedException {
        LongMessageFrame frame = msg.generateFrame();
        if (entity != null && entity instanceof SMPPEndpointEntity && msg instanceof BaseSm) {
            BaseSm smppMsg = (BaseSm)((Object)msg);
            SMPPEndpointEntity smppSMPPEndpointEntity = (SMPPEndpointEntity)entity;
            frame.setMsgfmt(new SmppSmsDcs(smppMsg.getDataCoding(), smppSMPPEndpointEntity.getDefauteSmsAlphabet()));
        }
        if (!frame.isConcatMsg()) {
            SmsTextMessage smsmsg = LongMessageFrameHolder.buildTextMessage(frame.getPayloadbytes(0), frame.getMsgfmt());
            return new SmsMessageHolder(smsmsg, msg);
        }
        try {
            FrameHolder fh = this.createFrameHolder(longSmsKey, frame);
            if (fh == null) {
                return null;
            }
            if (fh.isComplete()) {
                return new SmsMessageHolder(this.generatorSmsMessage(fh, frame), msg);
            }
            String mapKey = longSmsKey + "." + fh.frameKey + "." + fh.getTotalLength();
            frame.setTimestamp(((BaseMessage)((Object)msg)).getTimestamp());
            boolean complete = this.setAndget(msg, mapKey, frame, isRecvLongMsgOnMultiLink);
            if (complete) {
                List<LongMessageFrame> allFrame = this.getAndDel(mapKey, isRecvLongMsgOnMultiLink);
                FrameHolder firstF = this.createFrameHolder(mapKey, allFrame.get(0));
                for (int i = 1; i < allFrame.size(); ++i) {
                    try {
                        firstF = this.mergeFrameHolder(firstF, allFrame.get(i));
                        continue;
                    }
                    catch (NotSupportedException notSupportedException) {
                        // empty catch block
                    }
                }
                if (firstF.isComplete()) {
                    LongSMSMessage fullMsg = (LongSMSMessage)msg.generateMessage(allFrame.get(0));
                    if (fullMsg instanceof BaseMessage) {
                        ((BaseMessage)((Object)fullMsg)).setSequenceNo(allFrame.get(0).getSequence());
                    }
                    if (fullMsg.getUniqueLongMsgId() != null) {
                        fullMsg.setUniqueLongMsgId(new UniqueLongMsgId(fullMsg.getUniqueLongMsgId(), allFrame.get(0)));
                    }
                    for (int i = 1; i < allFrame.size(); ++i) {
                        LongMessageFrame tmp = allFrame.get(i);
                        LongSMSMessage frag = (LongSMSMessage)fullMsg.generateMessage(tmp);
                        if (frag.getUniqueLongMsgId() != null) {
                            frag.setUniqueLongMsgId(new UniqueLongMsgId(frag.getUniqueLongMsgId(), tmp));
                        }
                        if (frag instanceof BaseMessage) {
                            ((BaseMessage)((Object)frag)).setSequenceNo(tmp.getSequence());
                        }
                        fullMsg.addFragment(frag);
                    }
                    return new SmsMessageHolder(this.generatorSmsMessage(firstF, frame), fullMsg);
                }
                throw new NotSupportedException("not here");
            }
        }
        catch (Exception ex) {
            logger.warn("Merge Long SMS Error. entity : {} , dump:{}.\n {} ", new Object[]{entity.getId(), ByteBufUtil.hexDump((byte[])frame.getMsgContentBytes()), msg, ex});
            throw new NotSupportedException(ex.getMessage());
        }
        return null;
    }

    private void warning(boolean isMulti) {
        if (isMulti && !hasClusterLongMessageFrameProvider) {
            logger.warn("you use JVM cache for LongMessageFrameCache .When Long message fragments sent by multiple connections , messages will be lost , Cause memory leak");
        }
    }

    private boolean setAndget(LongSMSMessage msg, String key, LongMessageFrame currFrame, boolean isMulti) {
        if (isMulti) {
            this.warning(isMulti);
            return clusterMap.addAndGet(msg, key, currFrame);
        }
        return jvmMap.addAndGet(msg, key, currFrame);
    }

    Long getUniqueLongMsgId(String cacheKey, boolean isMulti) {
        if (isMulti) {
            return clusterMap.getUniqueLongMsgId(cacheKey);
        }
        return jvmMap.getUniqueLongMsgId(cacheKey);
    }

    void clearUniqueLongMsgIdCacheKey(String cacheKey, boolean isMulti) {
        if (isMulti) {
            clusterMap.clearUniqueLongMsgIdCacheKey(cacheKey);
        } else {
            jvmMap.clearUniqueLongMsgIdCacheKey(cacheKey);
        }
    }

    private List<LongMessageFrame> getAndDel(String key, boolean isMulti) {
        if (isMulti) {
            return clusterMap.getAndDel(key);
        }
        return jvmMap.getAndDel(key);
    }

    public List<LongMessageFrame> splitmsgcontent(SmsMessage content) throws SmsException {
        ArrayList<LongMessageFrame> result = new ArrayList<LongMessageFrame>();
        SmsPdu[] pdus = content.getPdus();
        boolean i = true;
        for (SmsPdu aMsgPdu : pdus) {
            byte[] udh = aMsgPdu.getUserDataHeaders();
            LongMessageFrame frame = new LongMessageFrame();
            SmsUdhElement[] udhe = aMsgPdu.getUdhElements_();
            int pkseq = 1;
            short pktot = 1;
            short pknum = 1;
            if (udhe != null && udhe.length > 0) {
                byte[] udhdata;
                SmsUdhElement firstudh = udhe[0];
                if (SmsUdhIei.CONCATENATED_8BIT.equals(firstudh.getUdhIei_())) {
                    udhdata = firstudh.getUdhIeiData();
                    pkseq = this.byteToInt(udhdata[0]);
                    pktot = (short)this.byteToInt(udhdata[1]);
                    pknum = (short)this.byteToInt(udhdata[2]);
                } else if (SmsUdhIei.CONCATENATED_16BIT.equals(firstudh.getUdhIei_())) {
                    udhdata = firstudh.getUdhIeiData();
                    pkseq = ((udhdata[0] & 0xFF) << 8 | udhdata[1] & 0xFF) & 0xFFFF;
                    pktot = (short)this.byteToInt(udhdata[2]);
                    pknum = (short)this.byteToInt(udhdata[3]);
                }
            }
            frame.setPkseq(pkseq);
            frame.setPktotal(pktot);
            frame.setPknumber(pknum);
            frame.setMsgfmt(aMsgPdu.getDcs());
            frame.setTpudhi(udh != null ? (short)1 : 0);
            ByteArrayOutputStream btos = new ByteArrayOutputStream(200);
            frame.setMsgLength((short)LongMessageFrameHolder.encodeOctetPdu(aMsgPdu, btos));
            frame.setMsgContentBytes(btos.toByteArray());
            result.add(frame);
        }
        return result;
    }

    private FrameHolder mergeFrameHolder(FrameHolder fh, LongMessageFrame frame) throws NotSupportedException {
        byte[] msgcontent = frame.getMsgContentBytes();
        UserDataHeader header = this.parseUserDataHeader(msgcontent);
        if (header.infoElement.size() > 0) {
            for (InformationElement udhi : header.infoElement) {
                if (SmsUdhIei.CONCATENATED_8BIT.equals(udhi.udhIei)) {
                    int idx = this.byteToInt(udhi.infoEleData[2]);
                    fh.merge(frame, frame.getPayloadbytes(header.headerlength), idx - 1);
                    break;
                }
                if (!SmsUdhIei.CONCATENATED_16BIT.equals(udhi.udhIei)) continue;
                int idx = this.byteToInt(udhi.infoEleData[3]);
                fh.merge(frame, frame.getPayloadbytes(header.headerlength), idx - 1);
                break;
            }
            return fh;
        }
        throw new NotSupportedException("Not Support LongMsg");
    }

    private int byteToInt(byte b) {
        return b & 0xFF;
    }

    private FrameHolder createFrameHolder(String serviceNum, LongMessageFrame frame) throws NotSupportedException {
        byte[] msgcontent = frame.getMsgContentBytes();
        UserDataHeader header = this.parseUserDataHeader(msgcontent);
        if (header.infoElement.size() > 0) {
            FrameHolder frameholder = null;
            InformationElement appudhinfo = null;
            int i = 0;
            int frameKey = 0;
            short pknumber = 1;
            short pkTotle = 1;
            for (InformationElement udhi : header.infoElement) {
                if (SmsUdhIei.CONCATENATED_8BIT.equals(udhi.udhIei)) {
                    frameKey = this.byteToInt(udhi.infoEleData[i++]);
                    pkTotle = (short)this.byteToInt(udhi.infoEleData[i++]);
                    frameholder = new FrameHolder(frameKey, pkTotle);
                    pknumber = (short)this.byteToInt(udhi.infoEleData[i++]);
                    frame.setPkseq(frameKey);
                    frame.setPktotal(pkTotle);
                    frame.setPknumber(pknumber);
                    continue;
                }
                if (SmsUdhIei.CONCATENATED_16BIT.equals(udhi.udhIei)) {
                    frameKey = (udhi.infoEleData[i] & 0xFF) << 8 | udhi.infoEleData[i + 1] & 0xFF & 0xFFFF;
                    i += 2;
                    pkTotle = (short)this.byteToInt(udhi.infoEleData[i++]);
                    frameholder = new FrameHolder(frameKey, pkTotle);
                    pknumber = (short)this.byteToInt(udhi.infoEleData[i++]);
                    frame.setPkseq(frameKey);
                    frame.setPktotal(pkTotle);
                    frame.setPknumber(pknumber);
                    continue;
                }
                appudhinfo = udhi;
            }
            if (frameholder == null) {
                frameholder = new FrameHolder(0, 1);
            }
            frameholder.setAppUDHinfo(appudhinfo);
            frameholder.setMsgfmt(frame.getMsgfmt());
            frameholder.setSequence(frame.getSequence());
            frameholder.setServiceNum(serviceNum);
            frameholder.merge(frame, frame.getPayloadbytes(header.headerlength), pknumber - 1);
            return frameholder;
        }
        throw new NotSupportedException("Not Support LongMsg");
    }

    private UserDataHeader parseUserDataHeader(byte[] pdu) {
        UserDataHeader udh = new UserDataHeader();
        udh.headerlength = pdu[0];
        udh.infoElement = new ArrayList<InformationElement>();
        int i = 1;
        while (i < udh.headerlength) {
            InformationElement t = new InformationElement();
            t.udhIei = SmsUdhIei.valueOf(pdu[i++]);
            t.infoEleLength = pdu[i++];
            t.infoEleData = new byte[t.infoEleLength];
            if (t.infoEleLength > 0) {
                System.arraycopy(pdu, i, t.infoEleData, 0, t.infoEleLength);
                i += t.infoEleLength;
            }
            udh.infoElement.add(t);
        }
        return udh;
    }

    public static byte[] octetStream2septetStream(byte[] octets, int setptetCnt) {
        byte[] septets = new byte[setptetCnt];
        int ind = 0;
        septets[ind++] = (byte)(octets[0] & 0x7F);
        for (int i = 1; i < octets.length; ++i) {
            int mod = (i + 6) % 7 + 1;
            byte b = (byte)(octets[i] << mod);
            byte a = (byte)((octets[i - 1] & 0xFF) >>> 8 - mod & 0x7F);
            septets[ind++] = (byte)((b | a) & 0x7F);
            if (i % 7 != 0) continue;
            septets[ind++] = (byte)(octets[i] & 0x7F);
        }
        if (octets.length * 8 == setptetCnt * 7) {
            septets[ind++] = (byte)(octets[octets.length - 1] >>> 1 & 0x7F);
        }
        return septets;
    }

    public static int octetLengthfromseptetsLength(int septetLength) {
        return (int)Math.ceil((double)(septetLength * 7) / 8.0);
    }

    private SmsMessage parseWapPdu(byte[] pdu) {
        int binaryContentType;
        int headerStartIndex;
        WspTypeDecoder pduDecoder;
        int headerLength;
        int pduType;
        int transactionId;
        block32: {
            String mimeType;
            block31: {
                int index = 0;
                transactionId = pdu[index++] & 0xFF;
                pduType = pdu[index++] & 0xFF;
                headerLength = 0;
                if (pduType != 6 && pduType != 7) {
                    return null;
                }
                pduDecoder = new WspTypeDecoder(pdu);
                if (!pduDecoder.decodeUintvarInteger(index)) {
                    return null;
                }
                headerLength = (int)pduDecoder.getValue32();
                headerStartIndex = index += pduDecoder.getDecodedDataLength();
                if (!pduDecoder.decodeContentType(index)) {
                    return null;
                }
                mimeType = pduDecoder.getValueString();
                if (mimeType != null) break block31;
                binaryContentType = (int)pduDecoder.getValue32();
                switch (binaryContentType) {
                    case 74: {
                        mimeType = "application/vnd.oma.drm.rights+xml";
                        break block32;
                    }
                    case 75: {
                        mimeType = "application/vnd.oma.drm.rights+wbxml";
                        break block32;
                    }
                    case 46: {
                        mimeType = "application/vnd.wap.sic";
                        break block32;
                    }
                    case 48: {
                        mimeType = "application/vnd.wap.slc";
                        break block32;
                    }
                    case 50: {
                        mimeType = "application/vnd.wap.coc";
                        break block32;
                    }
                    case 62: {
                        mimeType = "application/vnd.wap.mms-message";
                        break block32;
                    }
                    case 784: {
                        mimeType = "application/vnd.docomo.pf";
                        break block32;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (mimeType.equals("application/vnd.oma.drm.rights+xml")) {
                binaryContentType = 74;
            } else if (mimeType.equals("application/vnd.oma.drm.rights+wbxml")) {
                binaryContentType = 75;
            } else if (mimeType.equals("application/vnd.wap.sic")) {
                binaryContentType = 46;
            } else if (mimeType.equals("application/vnd.wap.slc")) {
                binaryContentType = 48;
            } else if (mimeType.equals("application/vnd.wap.coc")) {
                binaryContentType = 50;
            } else if (mimeType.equals("application/vnd.wap.mms-message")) {
                binaryContentType = 62;
            } else if (mimeType.equals("application/vnd.docomo.pf")) {
                binaryContentType = 784;
            } else {
                return null;
            }
        }
        index += pduDecoder.getDecodedDataLength();
        switch (binaryContentType) {
            case 46: {
                return this.dispatchWapPdu_PushWBXML(pdu, transactionId, pduType, headerStartIndex, headerLength, XMLFact.SIinFact);
            }
            case 48: {
                return this.dispatchWapPdu_PushWBXML(pdu, transactionId, pduType, headerStartIndex, headerLength, XMLFact.SLinFact);
            }
            case 62: {
                return this.dispatchWapPdu_MMS(pdu, transactionId, pduType, headerStartIndex, headerLength);
            }
        }
        return null;
    }

    private SmsMessage dispatchWapPdu_PushWBXML(byte[] pdu, int transactionId, int pduType, int headerStartIndex, int headerLength, XMLInputFactory inFact) {
        byte[] header = new byte[headerLength];
        System.arraycopy(pdu, headerStartIndex, header, 0, header.length);
        int dataIndex = headerStartIndex + headerLength;
        byte[] data = new byte[pdu.length - dataIndex];
        System.arraycopy(pdu, dataIndex, data, 0, data.length);
        try {
            Node uri;
            NamedNodeMap attrs;
            Document doc = this.wbxmlStream2Doc(inFact, new ByteArrayInputStream(data), false);
            Node node = doc.getFirstChild();
            if ("si".equals(node.getNodeName())) {
                NodeList nl = node.getChildNodes();
                if (nl != null && nl.getLength() > 0) {
                    for (int index = 0; index < nl.getLength(); ++index) {
                        Node uri2;
                        NamedNodeMap attrs2;
                        Node indication = nl.item(index);
                        if (!"indication".equals(indication.getNodeName()) || (attrs2 = indication.getAttributes()) == null || (uri2 = attrs2.getNamedItem("href")) == null) continue;
                        String uriStr = uri2.getNodeValue();
                        Node message = indication.getFirstChild();
                        String text = message != null ? message.getNodeValue() : "";
                        WapSIPush si = new WapSIPush(uriStr, text);
                        return new SmsWapPushMessage(si);
                    }
                }
            } else if ("sl".equals(node.getNodeName()) && (attrs = node.getAttributes()) != null && (uri = attrs.getNamedItem("href")) != null) {
                String uriStr = uri.getNodeValue();
                WapSLPush sl = new WapSLPush(uriStr);
                return new SmsWapPushMessage(sl);
            }
        }
        catch (Exception e) {
            logger.error("pdu = [{}]", (Object)ByteBufUtil.hexDump((byte[])pdu));
        }
        return null;
    }

    private SmsMessage dispatchWapPdu_MMS(byte[] pdu, int transactionId, int pduType, int headerStartIndex, int headerLength) {
        byte[] header = new byte[headerLength];
        System.arraycopy(pdu, headerStartIndex, header, 0, header.length);
        int dataIndex = headerStartIndex + headerLength;
        byte[] data = new byte[pdu.length - dataIndex];
        System.arraycopy(pdu, dataIndex, data, 0, data.length);
        PduParser parse = new PduParser(data);
        GenericPdu notify = parse.parse();
        if (notify != null && notify instanceof NotificationInd) {
            String msgclass;
            NotificationInd nind = (NotificationInd)notify;
            SmsMmsNotificationMessage mms = new SmsMmsNotificationMessage(new String(nind.getContentLocation(), StandardCharsets.US_ASCII), nind.getMessageSize());
            mms.setExpiry((int)(nind.getExpiry() - CachedMillisecondClock.INS.now() / 1000L));
            if (nind.getFrom() != null) {
                mms.setFrom(nind.getFrom().getString());
            }
            if ("personal".equals(msgclass = new String(nind.getMessageClass(), StandardCharsets.UTF_8))) {
                mms.setMessageClass(0);
            } else if ("advertisement".equals(msgclass)) {
                mms.setMessageClass(1);
            } else if ("auto".equals(msgclass)) {
                mms.setMessageClass(3);
            } else if ("informational".equals(msgclass)) {
                mms.setMessageClass(2);
            }
            if (nind.getSubject() != null) {
                mms.setSubject(nind.getSubject().getString());
            }
            if (nind.getTransactionId() != null) {
                mms.setTransactionId(new String(nind.getTransactionId()));
            }
            return mms;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document wbxmlStream2Doc(XMLInputFactory inFact, InputStream in, boolean event) throws Exception {
        XMLStreamReader xmlStreamReader = null;
        XMLEventReader xmlEventReader = null;
        try {
            if (event) {
                xmlEventReader = inFact.createXMLEventReader(in);
            } else {
                xmlStreamReader = inFact.createXMLStreamReader(in);
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            StAXSource staxSource = event ? new StAXSource(xmlEventReader) : new StAXSource(xmlStreamReader);
            DOMResult domResult = new DOMResult();
            xformer.transform(staxSource, domResult);
            Document doc = (Document)domResult.getNode();
            doc.normalize();
            Document document = doc;
            return document;
        }
        finally {
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (xmlEventReader != null) {
                try {
                    xmlEventReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static int encodeOctetPdu(SmsPdu pdu, OutputStream baos) throws SmsException {
        SmsUserData userData = pdu.getUserData();
        byte[] ud = userData.getData();
        byte[] udh = pdu.getUserDataHeaders();
        int length = 0;
        try {
            int nUdhBytes;
            int nUdBytes = userData.getLength();
            int n = nUdhBytes = udh == null ? 0 : udh.length;
            if (nUdhBytes == 0) {
                length = nUdBytes;
                baos.write(ud);
            } else {
                length = nUdBytes + nUdhBytes;
                baos.write(udh);
                baos.write(ud);
            }
            baos.close();
        }
        catch (IOException ex) {
            throw new SmsException(ex);
        }
        return length;
    }

    static {
        logger = LoggerFactory.getLogger(LongMessageFrameHolder.class);
        jvmMap = new LongMessageFrameProviderInner().create();
        ServiceLoader<LongMessageFrameProvider> p = ServiceLoader.load(LongMessageFrameProvider.class);
        for (LongMessageFrameProvider i : p) {
            logger.info("LongMessageFrameProvider search ... found " + i.getClass() + ". order : " + i.order());
            if (provider != null && provider.order() >= i.order()) continue;
            provider = i;
        }
        if (provider == null || LongMessageFrameProviderInner.class.equals(provider.getClass())) {
            clusterMap = jvmMap;
            logger.warn("not found other " + LongMessageFrameProvider.class + " Implementation class . use LongMessageFrameProviderInner.class");
        } else {
            logger.info("would use " + provider.getClass() + " for cluster Merge.");
            clusterMap = provider.create();
        }
        hasClusterLongMessageFrameProvider = provider != null && !LongMessageFrameProviderInner.class.equals(provider.getClass());
    }

    private static enum XMLFact {
        INS;

        private static final XMLInputFactory SLinFact;
        private static final XMLInputFactory SIinFact;

        private static XMLInputFactory createSLinFact() {
            WbXmlInputFactory inFact = new WbXmlInputFactory();
            ((XMLInputFactory)inFact).setProperty(WbXmlInputFactory.DEFINITION_PROPERTY, WbXmlInitialization.getDefinitionByName("SL 1.0"));
            return inFact;
        }

        private static XMLInputFactory createSIinFact() {
            WbXmlInputFactory inFact = new WbXmlInputFactory();
            ((XMLInputFactory)inFact).setProperty(WbXmlInputFactory.DEFINITION_PROPERTY, WbXmlInitialization.getDefinitionByName("SI 1.0"));
            return inFact;
        }

        static {
            SLinFact = XMLFact.createSLinFact();
            SIinFact = XMLFact.createSIinFact();
        }
    }

    private class UserDataHeader {
        int headerlength;
        List<InformationElement> infoElement;

        private UserDataHeader() {
        }
    }
}

