/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.wap;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.LongMessageFrameCache;
import com.zx.sms.codec.LongMessageFrameProvider;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongMessageFrameProviderInner
implements LongMessageFrameProvider {
    private static final Logger logger = LoggerFactory.getLogger(LongMessageFrameProviderInner.class);
    private static final RemovalListener<String, ImmutablePair<BitSet, List<LongMessageFrame>>> removealListener = new RemovalListener<String, ImmutablePair<BitSet, List<LongMessageFrame>>>(){

        public void onRemoval(RemovalNotification<String, ImmutablePair<BitSet, List<LongMessageFrame>>> notification) {
            RemovalCause cause = notification.getCause();
            ImmutablePair h = (ImmutablePair)notification.getValue();
            switch (cause) {
                case EXPIRED: 
                case SIZE: 
                case COLLECTED: {
                    logger.error("Long Message Lost cause by {}. {}", (Object)cause, (Object)LongMessageFrameProviderInner.longMessageFrameListToString((List)h.right));
                }
            }
        }
    };
    private static Cache<String, ImmutablePair<BitSet, List<LongMessageFrame>>> cache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.HOURS).removalListener(removealListener).build();
    private static ConcurrentMap<String, ImmutablePair<BitSet, List<LongMessageFrame>>> map = cache.asMap();
    private static final LoadingCache<String, Long> UniqCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Long>(){

        public Long load(String key) throws Exception {
            return new Long(DefaultSequenceNumberUtil.getSequenceNo());
        }
    });

    @Override
    public LongMessageFrameCache create() {
        return new LongMessageFrameCacheInner();
    }

    @Override
    public int order() {
        return 0;
    }

    private static String longMessageFrameListToString(List<LongMessageFrame> list) {
        StringBuffer sb = new StringBuffer();
        for (LongMessageFrame m : list) {
            sb.append(m.toString()).append("\n");
        }
        return sb.toString();
    }

    private class LongMessageFrameCacheInner
    implements LongMessageFrameCache {
        private LongMessageFrameCacheInner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAndGet(LongSMSMessage msg, String key, LongMessageFrame currFrame) {
            int pkTotal = currFrame.getPktotal() & 0xFF;
            int pkNumber = currFrame.getPknumber() & 0xFF;
            ImmutablePair oldFramePair = (ImmutablePair)map.get(key);
            if (oldFramePair != null) {
                ((List)oldFramePair.right).add(currFrame);
                BitSet bitSet = (BitSet)oldFramePair.left;
                synchronized (bitSet) {
                    ((BitSet)oldFramePair.left).set(pkNumber);
                    return pkTotal == ((BitSet)oldFramePair.left).cardinality();
                }
            }
            ArrayList<LongMessageFrame> currFrameList = new ArrayList<LongMessageFrame>();
            currFrameList.add(currFrame);
            BitSet currBitSet = new BitSet(pkTotal);
            currBitSet.set(pkNumber);
            ImmutablePair newFramePair = ImmutablePair.of((Object)currBitSet, Collections.synchronizedList(currFrameList));
            oldFramePair = map.putIfAbsent(key, newFramePair);
            if (oldFramePair != null) {
                ((List)oldFramePair.right).add(currFrame);
                BitSet bitSet = (BitSet)oldFramePair.left;
                synchronized (bitSet) {
                    ((BitSet)oldFramePair.left).set(pkNumber);
                    return pkTotal == ((BitSet)oldFramePair.left).cardinality();
                }
            }
            return pkTotal == 1;
        }

        @Override
        public List<LongMessageFrame> getAndDel(String key) {
            ImmutablePair pair = (ImmutablePair)map.remove(key);
            return (List)pair.right;
        }

        @Override
        public Long getUniqueLongMsgId(String cacheKey) {
            return (Long)UniqCache.getUnchecked((Object)cacheKey);
        }

        @Override
        public void clearUniqueLongMsgIdCacheKey(String cacheKey) {
            if (cacheKey != null) {
                UniqCache.invalidate((Object)cacheKey);
            }
        }
    }
}

