/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.wap;

import com.zx.sms.BaseMessage;
import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.wap.FrameHolder;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.connect.manager.EndpointEntity;
import io.netty.channel.Channel;
import java.io.Serializable;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueLongMsgId
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(UniqueLongMsgId.class);
    private static final long serialVersionUID = 1L;
    private String id;
    private String entityId;
    private String channelId;
    private SocketAddress remoteAddr;
    private SocketAddress localAddr;
    private long timestamp;
    private int sequenceNo;
    private int pkseq;
    private short pktotal;
    private short pknumber;
    private boolean createdByRead;
    private String cacheKey;
    private boolean recvLongMsgOnMultiLink = false;

    UniqueLongMsgId(String id) {
        this.id = id;
    }

    UniqueLongMsgId(EndpointEntity entity, Channel ch, LongSMSMessage lmsg, long lId, boolean createdByRead) {
        String srcIdAndDestId = lmsg.getSrcIdAndDestId();
        this.entityId = entity != null ? entity.getId() : "";
        this.recvLongMsgOnMultiLink = entity != null ? entity.isRecvLongMsgOnMultiLink() : false;
        LongMessageFrame frame = lmsg.generateFrame();
        FrameHolder fh = LongMessageFrameHolder.INS.parseFrameKey(frame);
        if (lmsg.getUniqueLongMsgId() == null) {
            StringBuffer keysb = new StringBuffer(this.entityId);
            if (!(ch == null || entity != null && entity.isRecvLongMsgOnMultiLink())) {
                keysb.append(".").append(ch.id().asShortText());
            }
            keysb.append(".").append(srcIdAndDestId);
            if (fh != null && fh.getTotalLength() > 1) {
                keysb.append(".").append(fh.frameKey).append(".").append(fh.getTotalLength());
                if (createdByRead) {
                    this.cacheKey = keysb.toString();
                    Long longId = LongMessageFrameHolder.INS.getUniqueLongMsgId(this.cacheKey, this.recvLongMsgOnMultiLink);
                    keysb.append(".").append(longId);
                } else {
                    keysb.append(".").append(lId);
                }
            } else {
                keysb.append(".").append(DefaultSequenceNumberUtil.getSequenceNo());
            }
            this.createdByRead = createdByRead;
            this.id = keysb.toString();
        } else {
            this.id = lmsg.getUniqueLongMsgId().getId();
            this.createdByRead = lmsg.getUniqueLongMsgId().isCreatedByRead();
        }
        if (ch != null) {
            this.channelId = ch.id().asShortText();
            this.remoteAddr = ch.remoteAddress();
            this.localAddr = ch.localAddress();
        }
        this.timestamp = ((BaseMessage)((Object)lmsg)).getTimestamp();
        this.sequenceNo = ((BaseMessage)((Object)lmsg)).getSequenceNo();
        this.pknumber = frame.getPknumber();
        this.pktotal = frame.getPktotal();
        this.pkseq = frame.getPkseq();
    }

    public UniqueLongMsgId(EndpointEntity entity, LongSMSMessage lmsg) {
        this(entity, null, lmsg, DefaultSequenceNumberUtil.getSequenceNo(), false);
    }

    public UniqueLongMsgId(UniqueLongMsgId id, Channel ch) {
        this.id = id.getId();
        this.entityId = id.getEntityId();
        this.channelId = ch.id().asShortText();
        this.remoteAddr = ch.remoteAddress();
        this.localAddr = ch.localAddress();
        this.createdByRead = id.isCreatedByRead();
        this.recvLongMsgOnMultiLink = id.isRecvLongMsgOnMultiLink();
        this.timestamp = id.getTimestamp();
        this.sequenceNo = id.getSequenceNo();
        this.pknumber = id.getPknumber();
        this.pktotal = id.getPktotal();
        this.pkseq = id.getPkseq();
    }

    public UniqueLongMsgId(UniqueLongMsgId id, LongMessageFrame frame) {
        this.id = id.getId();
        this.entityId = id.getEntityId();
        this.channelId = id.getChannelId();
        this.remoteAddr = id.getRemoteAddr();
        this.localAddr = id.getLocalAddr();
        this.createdByRead = id.isCreatedByRead();
        this.recvLongMsgOnMultiLink = id.isRecvLongMsgOnMultiLink();
        this.timestamp = frame.getTimestamp();
        this.sequenceNo = frame.getSequence();
        this.pknumber = frame.getPknumber();
        this.pktotal = frame.getPktotal();
        this.pkseq = frame.getPkseq();
    }

    public String getId() {
        return this.id;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public SocketAddress getRemoteAddr() {
        return this.remoteAddr;
    }

    public SocketAddress getLocalAddr() {
        return this.localAddr;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getSequenceNo() {
        return this.sequenceNo;
    }

    public int getPkseq() {
        return this.pkseq;
    }

    public short getPktotal() {
        return this.pktotal;
    }

    public short getPknumber() {
        return this.pknumber;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public boolean isCreatedByRead() {
        return this.createdByRead;
    }

    public boolean isRecvLongMsgOnMultiLink() {
        return this.recvLongMsgOnMultiLink;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniqueLongMsgId other = (UniqueLongMsgId)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "UniqueLongMsgId [id=" + this.id + ", entityId=" + this.entityId + ", timestamp=" + this.timestamp + ", sequenceNo=" + this.sequenceNo + ", pkseq=" + this.pkseq + ", pktotal=" + this.pktotal + ", pknumber=" + this.pknumber + ", channelId=" + this.channelId + ", remoteAddr=" + this.remoteAddr + ", localAddr=" + this.localAddr + ", createdByRead=" + this.createdByRead + "]";
    }

    void clearCacheKey() {
        LongMessageFrameHolder.INS.clearUniqueLongMsgIdCacheKey(this.cacheKey, this.recvLongMsgOnMultiLink);
    }
}

