/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp20;

import com.zx.sms.codec.cmpp.msg.CmppDeliverRequestMessage;
import com.zx.sms.codec.cmpp.msg.CmppReportRequestMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.CmppReportRequest;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.cmpp20.packet.Cmpp20DeliverRequest;
import com.zx.sms.codec.cmpp20.packet.Cmpp20PacketType;
import com.zx.sms.codec.cmpp20.packet.Cmpp20ReportRequest;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.DefaultMsgIdUtil;
import com.zx.sms.common.util.NettyByteBufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.marre.sms.SmsDcs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cmpp20DeliverRequestMessageCodec
extends MessageToMessageCodec<Message, CmppDeliverRequestMessage> {
    private final Logger logger = LoggerFactory.getLogger(Cmpp20DeliverRequestMessageCodec.class);
    private PacketType packetType;

    public Cmpp20DeliverRequestMessageCodec() {
        this(Cmpp20PacketType.CMPPDELIVERREQUEST);
    }

    public Cmpp20DeliverRequestMessageCodec(PacketType packetType) {
        this.packetType = packetType;
    }

    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        int commandId = msg.getHeader().getCommandId();
        if (this.packetType.getCommandId() != commandId) {
            out.add(msg);
            return;
        }
        CmppDeliverRequestMessage requestMessage = new CmppDeliverRequestMessage(msg.getHeader());
        ByteBuf bodyBuffer = Unpooled.wrappedBuffer((byte[])msg.getBodyBuffer());
        requestMessage.setMsgId(DefaultMsgIdUtil.bytes2MsgId(NettyByteBufUtil.toArray(bodyBuffer, Cmpp20DeliverRequest.MSGID.getLength())));
        requestMessage.setDestId(bodyBuffer.readCharSequence(Cmpp20DeliverRequest.DESTID.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setServiceid(bodyBuffer.readCharSequence(Cmpp20DeliverRequest.SERVICEID.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setTppid(bodyBuffer.readUnsignedByte());
        requestMessage.setTpudhi(bodyBuffer.readUnsignedByte());
        requestMessage.setMsgfmt(new SmsDcs((byte)bodyBuffer.readUnsignedByte()));
        requestMessage.setSrcterminalId(bodyBuffer.readCharSequence(Cmpp20DeliverRequest.SRCTERMINALID.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        short registeredDelivery = bodyBuffer.readUnsignedByte();
        short frameLength = (short)(bodyBuffer.readUnsignedByte() & 0xFFFF);
        if (registeredDelivery == 0) {
            byte[] contentbytes = new byte[frameLength];
            bodyBuffer.readBytes(contentbytes);
            requestMessage.setMsgContentBytes(contentbytes);
            requestMessage.setMsgLength(frameLength);
        } else {
            boolean errorProto = false;
            if (frameLength != Cmpp20ReportRequest.DESTTERMINALID.getBodyLength()) {
                if (frameLength == 71) {
                    errorProto = true;
                }
                this.logger.warn("CmppDeliverRequestMessage20 - MsgContent length is {}. should be {}.", (Object)frameLength, (Object)Cmpp20ReportRequest.DESTTERMINALID.getBodyLength());
            }
            requestMessage.setReportRequestMessage(new CmppReportRequestMessage());
            requestMessage.getReportRequestMessage().setMsgId(DefaultMsgIdUtil.bytes2MsgId(NettyByteBufUtil.toArray(bodyBuffer, Cmpp20ReportRequest.MSGID.getLength())));
            requestMessage.getReportRequestMessage().setStat(bodyBuffer.readCharSequence(Cmpp20ReportRequest.STAT.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
            requestMessage.getReportRequestMessage().setSubmitTime(bodyBuffer.readCharSequence(Cmpp20ReportRequest.SUBMITTIME.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
            requestMessage.getReportRequestMessage().setDoneTime(bodyBuffer.readCharSequence(Cmpp20ReportRequest.DONETIME.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
            requestMessage.getReportRequestMessage().setDestterminalId(bodyBuffer.readCharSequence(errorProto ? CmppReportRequest.DESTTERMINALID.getLength() : Cmpp20ReportRequest.DESTTERMINALID.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
            requestMessage.getReportRequestMessage().setSmscSequence(bodyBuffer.readUnsignedInt());
        }
        requestMessage.setReserved(bodyBuffer.readCharSequence(Cmpp20DeliverRequest.RESERVED.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(requestMessage);
    }

    protected void encode(ChannelHandlerContext ctx, CmppDeliverRequestMessage requestMessage, List<Object> out) throws Exception {
        ByteBuf bodyBuffer = ctx.alloc().buffer(Cmpp20DeliverRequest.DESTID.getBodyLength() + requestMessage.getMsgLength());
        bodyBuffer.writeBytes(DefaultMsgIdUtil.msgId2Bytes(requestMessage.getMsgId()));
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getDestId().getBytes(GlobalConstance.defaultTransportCharset), Cmpp20DeliverRequest.DESTID.getLength(), 0));
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getServiceid().getBytes(GlobalConstance.defaultTransportCharset), Cmpp20DeliverRequest.SERVICEID.getLength(), 0));
        bodyBuffer.writeByte((int)requestMessage.getTppid());
        bodyBuffer.writeByte((int)requestMessage.getTpudhi());
        bodyBuffer.writeByte((int)requestMessage.getMsgfmt().getValue());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getSrcterminalId().getBytes(GlobalConstance.defaultTransportCharset), Cmpp20DeliverRequest.SRCTERMINALID.getLength(), 0));
        bodyBuffer.writeByte(requestMessage.isReport() ? 1 : 0);
        if (!requestMessage.isReport()) {
            bodyBuffer.writeByte((int)requestMessage.getMsgLength());
            bodyBuffer.writeBytes(requestMessage.getMsgContentBytes());
        } else {
            bodyBuffer.writeByte(Cmpp20ReportRequest.DESTTERMINALID.getBodyLength());
            bodyBuffer.writeBytes(DefaultMsgIdUtil.msgId2Bytes(requestMessage.getReportRequestMessage().getMsgId()));
            bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getReportRequestMessage().getStat().getBytes(GlobalConstance.defaultTransportCharset), Cmpp20ReportRequest.STAT.getLength(), 0));
            bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getReportRequestMessage().getSubmitTime().getBytes(GlobalConstance.defaultTransportCharset), Cmpp20ReportRequest.SUBMITTIME.getLength(), 0));
            bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getReportRequestMessage().getDoneTime().getBytes(GlobalConstance.defaultTransportCharset), Cmpp20ReportRequest.DONETIME.getLength(), 0));
            bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getReportRequestMessage().getDestterminalId().getBytes(GlobalConstance.defaultTransportCharset), Cmpp20ReportRequest.DESTTERMINALID.getLength(), 0));
            bodyBuffer.writeInt((int)requestMessage.getReportRequestMessage().getSmscSequence());
        }
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getReserved().getBytes(GlobalConstance.defaultTransportCharset), Cmpp20DeliverRequest.RESERVED.getLength(), 0));
        requestMessage.setBodyBuffer(NettyByteBufUtil.toArray(bodyBuffer, bodyBuffer.readableBytes()));
        requestMessage.getHeader().setBodyLength(requestMessage.getBodyBuffer().length);
        out.add(requestMessage);
        ReferenceCountUtil.release((Object)bodyBuffer);
    }
}

