/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp7F;

import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp7F.packet.Cmpp7FPacketType;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class CMPP7FMessageCodecAggregator
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(CMPP7FMessageCodecAggregator.class);
    private ConcurrentHashMap<Integer, MessageToMessageCodec> codecMap = new ConcurrentHashMap();

    private CMPP7FMessageCodecAggregator() {
        for (Cmpp7FPacketType packetType : Cmpp7FPacketType.values()) {
            this.codecMap.put(packetType.getCommandId(), packetType.getCodec());
        }
    }

    public static CMPP7FMessageCodecAggregator getInstance() {
        return CMPP7FMessageCodecAggregatorHolder.instance;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        int commandId = ((Message)msg).getHeader().getCommandId();
        MessageToMessageCodec codec = this.codecMap.get(commandId);
        codec.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        try {
            int commandId = ((Message)msg).getHeader().getCommandId();
            MessageToMessageCodec codec = this.codecMap.get(commandId);
            codec.write(ctx, msg, promise);
        }
        catch (Exception ex) {
            promise.tryFailure((Throwable)ex);
        }
    }

    private static class CMPP7FMessageCodecAggregatorHolder {
        private static final CMPP7FMessageCodecAggregator instance = new CMPP7FMessageCodecAggregator();

        private CMPP7FMessageCodecAggregatorHolder() {
        }
    }
}

