/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.sgip12.codec;

import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.sgip12.msg.SgipBindResponseMessage;
import com.zx.sms.codec.sgip12.packet.SgipBindResponse;
import com.zx.sms.codec.sgip12.packet.SgipPacketType;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.NettyByteBufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class SgipBindResponseMessageCodec
extends MessageToMessageCodec<Message, SgipBindResponseMessage> {
    private PacketType packetType;

    public SgipBindResponseMessageCodec() {
        this(SgipPacketType.BINDRESPONSE);
    }

    public SgipBindResponseMessageCodec(PacketType packetType) {
        this.packetType = packetType;
    }

    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        int commandId = msg.getHeader().getCommandId();
        if (this.packetType.getCommandId() != commandId) {
            out.add(msg);
            return;
        }
        SgipBindResponseMessage responseMessage = new SgipBindResponseMessage(msg.getHeader());
        responseMessage.setTimestamp(msg.getTimestamp());
        ByteBuf bodyBuffer = Unpooled.wrappedBuffer((byte[])msg.getBodyBuffer());
        responseMessage.setResult(bodyBuffer.readUnsignedByte());
        responseMessage.setReserve(bodyBuffer.readCharSequence(SgipBindResponse.RESERVE.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(responseMessage);
    }

    protected void encode(ChannelHandlerContext ctx, SgipBindResponseMessage responseMessage, List<Object> out) throws Exception {
        ByteBuf bodyBuffer = ctx.alloc().buffer(SgipBindResponse.RESERVE.getBodyLength());
        bodyBuffer.writeByte((int)responseMessage.getResult());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(responseMessage.getReserve().getBytes(GlobalConstance.defaultTransportCharset), SgipBindResponse.RESERVE.getLength(), 0));
        responseMessage.setBodyBuffer(NettyByteBufUtil.toArray(bodyBuffer, bodyBuffer.readableBytes()));
        responseMessage.getHeader().setBodyLength(responseMessage.getBodyBuffer().length);
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(responseMessage);
    }
}

