/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.sgip12.codec;

import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.sgip12.msg.SgipDeliverResponseMessage;
import com.zx.sms.codec.sgip12.packet.SgipDeliverResponse;
import com.zx.sms.codec.sgip12.packet.SgipPacketType;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.NettyByteBufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class SgipDeliverResponseMessageCodec
extends MessageToMessageCodec<Message, SgipDeliverResponseMessage> {
    private PacketType packetType;

    public SgipDeliverResponseMessageCodec() {
        this(SgipPacketType.DELIVERRESPONSE);
    }

    public SgipDeliverResponseMessageCodec(PacketType packetType) {
        this.packetType = packetType;
    }

    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        int commandId = msg.getHeader().getCommandId();
        if (this.packetType.getCommandId() != commandId) {
            out.add(msg);
            return;
        }
        SgipDeliverResponseMessage responseMessage = new SgipDeliverResponseMessage(msg.getHeader());
        responseMessage.setTimestamp(msg.getTimestamp());
        ByteBuf bodyBuffer = Unpooled.wrappedBuffer((byte[])msg.getBodyBuffer());
        responseMessage.setResult(bodyBuffer.readUnsignedByte());
        responseMessage.setReserve(bodyBuffer.readCharSequence(SgipDeliverResponse.RESERVE.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(responseMessage);
    }

    protected void encode(ChannelHandlerContext ctx, SgipDeliverResponseMessage msg, List<Object> out) throws Exception {
        ByteBuf bodyBuffer = ctx.alloc().buffer(SgipDeliverResponse.RESULT.getBodyLength());
        bodyBuffer.writeByte((int)msg.getResult());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(msg.getReserve().getBytes(GlobalConstance.defaultTransportCharset), SgipDeliverResponse.RESERVE.getLength(), 0));
        msg.setBodyBuffer(NettyByteBufUtil.toArray(bodyBuffer, bodyBuffer.readableBytes()));
        msg.getHeader().setBodyLength(msg.getBodyBuffer().length);
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(msg);
    }
}

