/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.sgip12.codec;

import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.sgip12.packet.SgipPacketType;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SgipMessageCodecAggregator
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(SgipMessageCodecAggregator.class);
    private ConcurrentHashMap<Integer, MessageToMessageCodec> codecMap = new ConcurrentHashMap();

    private SgipMessageCodecAggregator() {
        for (SgipPacketType packetType : SgipPacketType.values()) {
            this.codecMap.put(packetType.getCommandId(), packetType.getCodec());
        }
    }

    public static SgipMessageCodecAggregator getInstance() {
        return SgipMessageCodecAggregatorHolder.instance;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        int commandId = ((Message)msg).getHeader().getCommandId();
        MessageToMessageCodec codec = this.codecMap.get(commandId);
        codec.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        try {
            int commandId = ((Message)msg).getHeader().getCommandId();
            MessageToMessageCodec codec = this.codecMap.get(commandId);
            codec.write(ctx, msg, promise);
        }
        catch (Exception ex) {
            promise.tryFailure((Throwable)ex);
        }
    }

    private static class SgipMessageCodecAggregatorHolder {
        private static final SgipMessageCodecAggregator instance = new SgipMessageCodecAggregator();

        private SgipMessageCodecAggregatorHolder() {
        }
    }
}

