/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.sgip12.codec;

import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.sgip12.msg.SgipReportRequestMessage;
import com.zx.sms.codec.sgip12.packet.SgipPacketType;
import com.zx.sms.codec.sgip12.packet.SgipReportRequest;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.common.util.NettyByteBufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class SgipReportRequestMessageCodec
extends MessageToMessageCodec<Message, SgipReportRequestMessage> {
    private PacketType packetType;

    public SgipReportRequestMessageCodec() {
        this(SgipPacketType.REPORTREQUEST);
    }

    public SgipReportRequestMessageCodec(PacketType packetType) {
        this.packetType = packetType;
    }

    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        int commandId = msg.getHeader().getCommandId();
        if (this.packetType.getCommandId() != commandId) {
            out.add(msg);
            return;
        }
        SgipReportRequestMessage requestMessage = new SgipReportRequestMessage(msg.getHeader());
        requestMessage.setTimestamp(msg.getTimestamp());
        ByteBuf bodyBuffer = Unpooled.wrappedBuffer((byte[])msg.getBodyBuffer());
        byte[] seqbytes = new byte[SgipReportRequest.SUBMITSEQUENCENUMBER.getLength()];
        bodyBuffer.readBytes(seqbytes);
        requestMessage.setSequenceId(DefaultSequenceNumberUtil.bytes2SequenceN(seqbytes));
        requestMessage.setReporttype(bodyBuffer.readUnsignedByte());
        requestMessage.setUsernumber(bodyBuffer.readCharSequence(SgipReportRequest.USERNUMBER.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setState(bodyBuffer.readUnsignedByte());
        requestMessage.setErrorcode(bodyBuffer.readUnsignedByte());
        requestMessage.setReserve(bodyBuffer.readCharSequence(SgipReportRequest.RESERVE.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(requestMessage);
    }

    protected void encode(ChannelHandlerContext ctx, SgipReportRequestMessage msg, List<Object> out) throws Exception {
        ByteBuf bodyBuffer = ctx.alloc().buffer(SgipReportRequest.USERNUMBER.getBodyLength());
        bodyBuffer.writeBytes(DefaultSequenceNumberUtil.sequenceN2Bytes(msg.getSequenceId()));
        bodyBuffer.writeByte((int)msg.getReporttype());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(msg.getUsernumber().getBytes(GlobalConstance.defaultTransportCharset), SgipReportRequest.USERNUMBER.getLength(), 0));
        bodyBuffer.writeByte((int)msg.getState());
        bodyBuffer.writeByte((int)msg.getErrorcode());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(msg.getReserve().getBytes(GlobalConstance.defaultTransportCharset), SgipReportRequest.RESERVE.getLength(), 0));
        msg.setBodyBuffer(NettyByteBufUtil.toArray(bodyBuffer, bodyBuffer.readableBytes()));
        ReferenceCountUtil.release((Object)bodyBuffer);
        msg.getHeader().setBodyLength(msg.getBodyBuffer().length);
        out.add(msg);
    }
}

