/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.sgip12.msg;

import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.msg.Header;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.codec.cmpp.wap.UniqueLongMsgId;
import com.zx.sms.codec.sgip12.msg.SgipDefaultMessage;
import com.zx.sms.codec.sgip12.packet.SgipPacketType;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.marre.sms.SgipSmsDcs;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsMsgClass;

public class SgipSubmitRequestMessage
extends SgipDefaultMessage
implements LongSMSMessage<SgipSubmitRequestMessage> {
    private static final long serialVersionUID = 5265747696709571791L;
    private String spnumber = "";
    private String chargenumber = "";
    private String[] usernumber = null;
    private String corpid = "";
    private String servicetype = "";
    private short feetype = (short)2;
    private String feevalue = "";
    private String givenvalue = "";
    private short agentflag = 0;
    private short morelatetomtflag = 0;
    private short priority = (short)9;
    private String expiretime = "";
    private String scheduletime = "";
    private short reportflag = 1;
    private short tppid = 0;
    private short tpudhi = 0;
    private SgipSmsDcs msgfmt = SgipSmsDcs.getGeneralDataCodingDcs(SmsAlphabet.ASCII, SmsMsgClass.CLASS_UNKNOWN);
    private short messagetype = 0;
    private int messagelength = 120;
    private String reserve = "";
    private byte[] msgContentBytes = GlobalConstance.emptyBytes;
    private SmsMessage msg;
    private List<SgipSubmitRequestMessage> fragments = null;

    public SgipSubmitRequestMessage() {
        super(SgipPacketType.SUBMITREQUEST);
    }

    public SgipSubmitRequestMessage(Header header) {
        super((PacketType)SgipPacketType.SUBMITREQUEST, header);
    }

    @Override
    public boolean isReport() {
        return false;
    }

    public String getSpnumber() {
        return this.spnumber;
    }

    public void setSpnumber(String spnumber) {
        this.spnumber = spnumber;
    }

    public String getChargenumber() {
        return this.chargenumber;
    }

    public void setChargenumber(String chargenumber) {
        this.chargenumber = chargenumber;
    }

    public short getUsercount() {
        return (short)this.usernumber.length;
    }

    public String[] getUsernumber() {
        return this.usernumber;
    }

    public void setUsernumber(String[] usernumber) {
        this.usernumber = usernumber;
    }

    public void setUsernumber(String usernumber) {
        this.usernumber = new String[]{usernumber};
    }

    public String getCorpid() {
        return this.corpid;
    }

    public void setCorpid(String corpid) {
        this.corpid = corpid;
    }

    public String getServicetype() {
        return this.servicetype;
    }

    public void setServicetype(String servicetype) {
        this.servicetype = servicetype;
    }

    public short getFeetype() {
        return this.feetype;
    }

    public void setFeetype(short feetype) {
        this.feetype = feetype;
    }

    public String getFeevalue() {
        return this.feevalue;
    }

    public void setFeevalue(String feevalue) {
        this.feevalue = feevalue;
    }

    public String getGivenvalue() {
        return this.givenvalue;
    }

    public void setGivenvalue(String givenvalue) {
        this.givenvalue = givenvalue;
    }

    public short getAgentflag() {
        return this.agentflag;
    }

    public void setAgentflag(short agentflag) {
        this.agentflag = agentflag;
    }

    public short getMorelatetomtflag() {
        return this.morelatetomtflag;
    }

    public void setMorelatetomtflag(short morelatetomtflag) {
        this.morelatetomtflag = morelatetomtflag;
    }

    public short getPriority() {
        return this.priority;
    }

    public void setPriority(short priority) {
        this.priority = priority;
    }

    public String getExpiretime() {
        return this.expiretime;
    }

    public void setExpiretime(String expiretime) {
        this.expiretime = expiretime;
    }

    public String getScheduletime() {
        return this.scheduletime;
    }

    public void setScheduletime(String scheduletime) {
        this.scheduletime = scheduletime;
    }

    public short getReportflag() {
        return this.reportflag;
    }

    public void setReportflag(short reportflag) {
        this.reportflag = reportflag;
    }

    public short getTppid() {
        return this.tppid;
    }

    public void setTppid(short tppid) {
        this.tppid = tppid;
    }

    public short getTpudhi() {
        return this.tpudhi;
    }

    public void setTpudhi(short tpudhi) {
        this.tpudhi = tpudhi;
    }

    public short getMessagetype() {
        return this.messagetype;
    }

    public void setMessagetype(short messagetype) {
        this.messagetype = messagetype;
    }

    public int getMessagelength() {
        return this.messagelength;
    }

    public void setMessagelength(int messagelength) {
        this.messagelength = messagelength;
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }

    public byte[] getMsgContentBytes() {
        return this.msgContentBytes;
    }

    public void setMsgContentBytes(byte[] msgContentBytes) {
        this.msgContentBytes = msgContentBytes;
    }

    public String getMsgContent() {
        if (this.msg instanceof SmsMessage) {
            return this.msg.toString();
        }
        if (this.msgContentBytes != null && this.msgContentBytes.length > 0) {
            LongMessageFrame frame = this.generateFrame();
            return LongMessageFrameHolder.INS.getPartTextMsg(frame);
        }
        return "";
    }

    public void setMsgContent(String msgContent) {
        this.setMsgContent(this.buildSmsMessage(msgContent));
    }

    public void setMsgContent(SmsMessage msg) {
        this.msg = msg;
    }

    @Override
    public SmsMessage getSmsMessage() {
        return this.msg;
    }

    @Override
    public SgipSubmitRequestMessage clone() throws CloneNotSupportedException {
        return (SgipSubmitRequestMessage)super.clone();
    }

    public SgipSmsDcs getMsgfmt() {
        return this.msgfmt;
    }

    public void setMsgfmt(SgipSmsDcs msgfmt) {
        this.msgfmt = msgfmt;
    }

    @Override
    public LongMessageFrame generateFrame() {
        LongMessageFrame frame = new LongMessageFrame();
        frame.setTppid(this.getTppid());
        frame.setTpudhi(this.getTpudhi());
        frame.setMsgfmt(this.getMsgfmt());
        frame.setMsgContentBytes(this.getMsgContentBytes());
        frame.setMsgLength((short)this.getMessagelength());
        frame.setSequence(this.getSequenceNo());
        return frame;
    }

    @Override
    public SgipSubmitRequestMessage generateMessage(LongMessageFrame frame) throws Exception {
        SgipSubmitRequestMessage requestMessage = this.clone();
        requestMessage.setTpudhi(frame.getTpudhi());
        requestMessage.setMsgfmt((SgipSmsDcs)frame.getMsgfmt());
        requestMessage.setMsgContentBytes(frame.getMsgContentBytes());
        requestMessage.setMessagelength(frame.getMsgLength());
        if (frame.getPknumber() != 1) {
            requestMessage.getHeader().setSequenceId(DefaultSequenceNumberUtil.getSequenceNo());
        }
        requestMessage.setMsgContent((SmsMessage)null);
        return requestMessage;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SgipSubmitRequestMessage [corpid=").append(this.corpid).append(", spnumber=").append(this.spnumber).append(", destterminalId=").append(Arrays.toString(this.usernumber)).append(", msgContent=").append(this.getMsgContent()).append(", seq=").append(this.getSequenceNumber()).append(", Header=").append(this.getHeader()).append("]");
        return sb.toString();
    }

    @Override
    public List<SgipSubmitRequestMessage> getFragments() {
        return this.fragments;
    }

    @Override
    public void addFragment(SgipSubmitRequestMessage fragment) {
        if (this.fragments == null) {
            this.fragments = new ArrayList<SgipSubmitRequestMessage>();
        }
        this.fragments.add(fragment);
    }

    @Override
    public UniqueLongMsgId getUniqueLongMsgId() {
        return super.getUniqueLongMsgId();
    }

    @Override
    public void setUniqueLongMsgId(UniqueLongMsgId id) {
        super.setUniqueLongMsgId(id);
    }

    @Override
    public boolean needHandleLongMessage() {
        return true;
    }

    @Override
    public String getSrcIdAndDestId() {
        return StringUtils.join((Object[])this.getUsernumber(), (String)"|") + this.getSpnumber();
    }
}

