/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.sgip12.packet;

import com.zx.sms.codec.cmpp.packet.PacketStructure;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.sgip12.codec.SgipBindRequestMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipBindResponseMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipDeliverRequestMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipDeliverResponseMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipReportRequestMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipReportResponseMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipSubmitRequestMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipSubmitResponseMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipUnbindRequestMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipUnbindResponseMessageCodec;
import com.zx.sms.codec.sgip12.packet.SgipBindRequest;
import com.zx.sms.codec.sgip12.packet.SgipBindResponse;
import com.zx.sms.codec.sgip12.packet.SgipDeliverRequest;
import com.zx.sms.codec.sgip12.packet.SgipDeliverResponse;
import com.zx.sms.codec.sgip12.packet.SgipReportRequest;
import com.zx.sms.codec.sgip12.packet.SgipReportResponse;
import com.zx.sms.codec.sgip12.packet.SgipSubmitRequest;
import com.zx.sms.codec.sgip12.packet.SgipSubmitResponse;
import com.zx.sms.codec.sgip12.packet.SgipUnbindRequest;
import com.zx.sms.codec.sgip12.packet.SgipUnbindResponse;
import io.netty.handler.codec.MessageToMessageCodec;

public enum SgipPacketType implements PacketType
{
    BINDREQUEST(1, SgipBindRequest.class, SgipBindRequestMessageCodec.class),
    BINDRESPONSE(-2147483647, SgipBindResponse.class, SgipBindResponseMessageCodec.class),
    UNBINDREQUEST(2, SgipUnbindRequest.class, SgipUnbindRequestMessageCodec.class),
    UNBINDRESPONSE(-2147483646, SgipUnbindResponse.class, SgipUnbindResponseMessageCodec.class),
    SUBMITREQUEST(3, SgipSubmitRequest.class, SgipSubmitRequestMessageCodec.class),
    SUBMITRESPONSE(-2147483645, SgipSubmitResponse.class, SgipSubmitResponseMessageCodec.class),
    DELIVERREQUEST(4, SgipDeliverRequest.class, SgipDeliverRequestMessageCodec.class),
    DELIVERRESPONSE(-2147483644, SgipDeliverResponse.class, SgipDeliverResponseMessageCodec.class),
    REPORTREQUEST(5, SgipReportRequest.class, SgipReportRequestMessageCodec.class),
    REPORTRESPONSE(-2147483643, SgipReportResponse.class, SgipReportResponseMessageCodec.class);

    private int commandId;
    private Class<? extends PacketStructure> packetStructure;
    private Class<? extends MessageToMessageCodec> codec;

    private SgipPacketType(int commandId, Class<? extends PacketStructure> packetStructure, Class<? extends MessageToMessageCodec> codec) {
        this.commandId = commandId;
        this.packetStructure = packetStructure;
        this.codec = codec;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    @Override
    public PacketStructure[] getPacketStructures() {
        return this.packetStructure.getEnumConstants();
    }

    @Override
    public long getAllCommandId() {
        long defaultId = 0L;
        long allCommandId = 0L;
        for (SgipPacketType packetType : SgipPacketType.values()) {
            allCommandId |= (long)packetType.commandId;
        }
        return allCommandId ^ defaultId;
    }

    @Override
    public MessageToMessageCodec getCodec() {
        try {
            return this.codec.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

