/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smgp.msg;

import com.zx.sms.codec.smgp.util.SMGPMsgIdUtil;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.CachedMillisecondClock;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class MsgId
implements Serializable {
    private static final long serialVersionUID = 945466149547731811L;
    private static final AtomicInteger _sequenceId = new AtomicInteger(RandomUtils.nextInt());
    private int month;
    private int day;
    private int hour;
    private int minutes;
    private int gateId;
    private int sequenceId;
    private byte[] originarr;

    public MsgId() {
        this(CachedMillisecondClock.INS.now());
    }

    public MsgId(int gateId) {
        this(CachedMillisecondClock.INS.now(), gateId, _sequenceId.incrementAndGet());
    }

    public MsgId(long timeMillis) {
        this(timeMillis, CMPPCommonUtil.RandomGateID, _sequenceId.incrementAndGet());
    }

    public MsgId(byte[] arr) {
        this.originarr = new byte[10];
        System.arraycopy(arr, 0, this.originarr, 0, 10);
    }

    public MsgId(String msgIds) {
        this.setGateId(Integer.parseInt(msgIds.substring(0, 6)));
        this.setMonth(Integer.parseInt(msgIds.substring(6, 8)));
        this.setDay(Integer.parseInt(msgIds.substring(8, 10)));
        this.setHour(Integer.parseInt(msgIds.substring(10, 12)));
        this.setMinutes(Integer.parseInt(msgIds.substring(12, 14)));
        this.setSequenceId(Integer.parseInt(msgIds.substring(14, 20)));
    }

    public MsgId(long timeMillis, int gateId, int sequenceId) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        this.setMonth(cal.get(2) + 1);
        this.setDay(cal.get(5));
        this.setHour(cal.get(11));
        this.setMinutes(cal.get(12));
        this.setGateId(gateId);
        this.setSequenceId(sequenceId);
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getGateId() {
        return this.gateId;
    }

    public void setGateId(int gateId) {
        Validate.isTrue((gateId < 1000000 && gateId >= 0 ? 1 : 0) != 0, (String)("gateId must be non-negative  and  less 1000000 .now is " + gateId), (Object[])new Object[0]);
        this.gateId = gateId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = (sequenceId & 0xFFFFFF) % 1000000;
    }

    public String toString() {
        if (this.originarr != null && this.originarr.length > 0) {
            return String.valueOf(Hex.encodeHex((byte[])this.originarr));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.leftPad((String)String.valueOf(this.gateId), (int)6, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.month), (int)2, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.day), (int)2, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.hour), (int)2, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.minutes), (int)2, (char)'0')).append(StringUtils.leftPad((String)String.valueOf(this.sequenceId), (int)6, (char)'0'));
        return sb.toString();
    }

    public String toHexString(boolean toLowerCase) {
        return Hex.encodeHexString((byte[])SMGPMsgIdUtil.msgId2Bytes(this), (boolean)toLowerCase);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.originarr != null && this.originarr.length > 0) {
            return Arrays.hashCode(this.originarr);
        }
        result = 31 * result + this.day;
        result = 31 * result + this.gateId;
        result = 31 * result + this.hour;
        result = 31 * result + this.minutes;
        result = 31 * result + this.month;
        result = 31 * result + this.sequenceId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MsgId other = (MsgId)obj;
        if (this.originarr != null && this.originarr.length > 0) {
            return Arrays.equals(this.originarr, other.originarr);
        }
        if (this.day != other.day) {
            return false;
        }
        if (this.gateId != other.gateId) {
            return false;
        }
        if (this.hour != other.hour) {
            return false;
        }
        if (this.minutes != other.minutes) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        return this.sequenceId == other.sequenceId;
    }
}

