/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smgp.msg;

import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.codec.cmpp.wap.UniqueLongMsgId;
import com.zx.sms.codec.smgp.msg.MsgId;
import com.zx.sms.codec.smgp.msg.SMGPBaseMessage;
import com.zx.sms.codec.smgp.msg.SMGPReportData;
import com.zx.sms.codec.smgp.tlv.TLVByte;
import com.zx.sms.codec.smgp.tlv.TLVString;
import com.zx.sms.codec.smgp.util.ByteUtil;
import com.zx.sms.codec.smgp.util.SMGPMsgIdUtil;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.marre.sms.SMGPSmsDcs;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsMsgClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMGPDeliverMessage
extends SMGPBaseMessage
implements LongSMSMessage<SMGPDeliverMessage> {
    private static final Logger logger = LoggerFactory.getLogger(SMGPDeliverMessage.class);
    private static final long serialVersionUID = -6960208317220566142L;
    private MsgId msgId = new MsgId();
    private boolean isReport;
    private SMGPSmsDcs msgFmt = SMGPSmsDcs.getGeneralDataCodingDcs(SmsAlphabet.ASCII, SmsMsgClass.CLASS_UNKNOWN);
    private String recvTime = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
    private String srcTermId;
    private String destTermId;
    private byte[] bMsgContent;
    private String reserve = "";
    private SmsMessage msg;
    private SMGPReportData report;
    private TLVByte tpPid = new TLVByte(1);
    private TLVByte tpUdhi = new TLVByte(2);
    private TLVString linkId = new TLVString(3);
    private TLVByte srcTermType = new TLVByte(13);
    private TLVString srcTermPseudo = new TLVString(14);
    private TLVByte submitMsgType = new TLVByte(11);
    private TLVByte spDealResult = new TLVByte(12);
    private List<SMGPDeliverMessage> fragments = null;

    public SMGPDeliverMessage() {
        this.commandId = 3;
        this.registerOptional(this.tpPid);
        this.registerOptional(this.tpUdhi);
        this.registerOptional(this.linkId);
        this.registerOptional(this.srcTermType);
        this.registerOptional(this.srcTermPseudo);
        this.registerOptional(this.submitMsgType);
        this.registerOptional(this.spDealResult);
    }

    public void setTpPid(byte value) {
        this.tpPid.setValue(value);
    }

    public byte getTpPid() {
        return this.tpPid.getValue();
    }

    public void setTpUdhi(byte value) {
        this.tpUdhi.setValue(value);
    }

    public byte getTpUdhi() {
        return this.tpUdhi.getValue();
    }

    public void setLinkId(String value) {
        this.linkId.setValue(value);
    }

    public String getLinkId() {
        return this.linkId.getValue();
    }

    public void setSrcTermType(byte value) {
        this.srcTermType.setValue(value);
    }

    public byte getSrcTermType() {
        return this.srcTermType.getValue();
    }

    public void setSrcTermPseudo(String value) {
        this.srcTermPseudo.setValue(value);
    }

    public String getSrcTermPseudo() {
        return this.srcTermPseudo.getValue();
    }

    public void setSubmitMsgType(byte value) {
        this.submitMsgType.setValue(value);
    }

    public byte getSubmitMsgType() {
        return this.submitMsgType.getValue();
    }

    public void setSpDealResult(byte value) {
        this.spDealResult.setValue(value);
    }

    public byte getSpDealResult() {
        return this.spDealResult.getValue();
    }

    @Override
    protected int setBody(byte[] bodyBytes, int version) throws Exception {
        int msgLength;
        int offset = 0;
        byte[] tmp = null;
        byte[] msgId = new byte[10];
        System.arraycopy(bodyBytes, offset, msgId, 0, 10);
        this.msgId = SMGPMsgIdUtil.bytes2MsgId(msgId);
        this.isReport = bodyBytes[offset += 10] == 1;
        this.msgFmt = new SMGPSmsDcs(bodyBytes[++offset]);
        tmp = new byte[14];
        System.arraycopy(bodyBytes, ++offset, tmp, 0, 14);
        this.recvTime = new String(ByteUtil.rtrimBytes(tmp));
        tmp = new byte[21];
        System.arraycopy(bodyBytes, offset += 14, tmp, 0, 21);
        this.srcTermId = new String(ByteUtil.rtrimBytes(tmp));
        tmp = new byte[21];
        System.arraycopy(bodyBytes, offset += 21, tmp, 0, 21);
        this.destTermId = new String(ByteUtil.rtrimBytes(tmp));
        int b = bodyBytes[offset += 21];
        ++offset;
        int n = msgLength = b >= 0 ? b : 256 + b;
        if (msgLength > 0) {
            tmp = new byte[msgLength];
            System.arraycopy(bodyBytes, offset, tmp, 0, msgLength);
            offset += msgLength;
            if (this.isReport()) {
                SMGPReportData tmpreport = new SMGPReportData();
                tmpreport.fromBytes(tmp);
                this.report = tmpreport;
            } else {
                this.bMsgContent = tmp;
            }
        }
        tmp = new byte[8];
        System.arraycopy(bodyBytes, offset, tmp, 0, 8);
        this.reserve = new String(ByteUtil.rtrimBytes(tmp));
        return offset += 8;
    }

    @Override
    protected byte[] getBody(int version) throws Exception {
        int msgLength = 0;
        byte[] msgContent = null;
        if (this.isReport()) {
            msgContent = this.report.toBytes();
            msgLength = msgContent.length;
        } else {
            msgContent = this.bMsgContent;
            msgLength = this.bMsgContent.length;
        }
        int len = 69 + msgLength + 8;
        int offset = 0;
        byte[] bodyBytes = new byte[len];
        byte[] b_msgId = SMGPMsgIdUtil.msgId2Bytes(this.msgId);
        System.arraycopy(b_msgId, 0, bodyBytes, offset, 10);
        bodyBytes[offset += 10] = this.isReport ? (byte)1 : 0;
        bodyBytes[++offset] = this.msgFmt.getValue();
        ByteUtil.rfillBytes(this.recvTime.getBytes(), 14, bodyBytes, ++offset);
        ByteUtil.rfillBytes(this.srcTermId.getBytes(), 21, bodyBytes, offset += 14);
        ByteUtil.rfillBytes(this.destTermId.getBytes(), 21, bodyBytes, offset += 21);
        bodyBytes[offset += 21] = (byte)msgLength;
        ByteUtil.rfillBytes(msgContent, msgLength, bodyBytes, ++offset);
        ByteUtil.rfillBytes(this.reserve.getBytes(), 8, bodyBytes, offset += msgLength);
        offset += 8;
        return bodyBytes;
    }

    public MsgId getMsgId() {
        return this.msgId;
    }

    public void setMsgId(MsgId msgId) {
        this.msgId = msgId;
    }

    @Override
    public boolean isReport() {
        return this.isReport;
    }

    public SMGPSmsDcs getMsgFmt() {
        return this.msgFmt;
    }

    public void setMsgFmt(SMGPSmsDcs msgFmt) {
        this.msgFmt = msgFmt;
    }

    public String getRecvTime() {
        return this.recvTime;
    }

    public void setRecvTime(String recvTime) {
        this.recvTime = recvTime;
    }

    public void setRecvTime(Date recvTime) {
        this.recvTime = DateFormatUtils.format((Date)recvTime, (String)"yyyyMMddHHmmss");
    }

    public String getSrcTermId() {
        return this.srcTermId;
    }

    public void setSrcTermId(String srcTermId) {
        this.srcTermId = srcTermId;
    }

    public String getDestTermId() {
        return this.destTermId;
    }

    public void setDestTermId(String destTermId) {
        this.destTermId = destTermId;
    }

    public byte[] getBMsgContent() {
        return this.bMsgContent;
    }

    public void setBMsgContent(byte[] msgContent) {
        this.bMsgContent = msgContent;
    }

    public void setMsgContent(String msgContent) {
        this.setMsgContent(this.buildSmsMessage(msgContent));
    }

    public void setMsgContent(SmsMessage msg) {
        this.msg = msg;
    }

    @Override
    public SmsMessage getSmsMessage() {
        return this.msg;
    }

    public SMGPReportData getReport() {
        return this.report;
    }

    public void setReport(SMGPReportData report) {
        this.report = report;
        this.isReport = true;
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }

    private String msgIdString() {
        return this.msgId.toString();
    }

    public String getMsgContent() {
        if (this.msg instanceof SmsMessage) {
            return this.msg.toString();
        }
        if (this.bMsgContent != null && this.bMsgContent.length > 0) {
            LongMessageFrame frame = this.generateFrame();
            return LongMessageFrameHolder.INS.getPartTextMsg(frame);
        }
        return "";
    }

    @Override
    public String toString() {
        if (this.isReport) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SMGPDeliverMessage:[sequenceNumber=").append(this.sequenceString()).append(",");
            buffer.append("msgId=").append(this.msgIdString()).append(",");
            buffer.append("recvTime=").append(this.recvTime).append(",");
            buffer.append("srcTermId=").append(this.srcTermId).append(",");
            buffer.append("destTermId=").append(this.destTermId).append(",");
            buffer.append("ReportDate=").append(this.getReport()).append("]");
            return buffer.toString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SMGPDeliverMessage:[sequenceNumber=").append(this.sequenceString()).append(",");
        buffer.append("msgId=").append(this.msgIdString()).append(",");
        buffer.append("recvTime=").append(this.recvTime).append(",");
        buffer.append("srcTermId=").append(this.srcTermId).append(",");
        buffer.append("destTermId=").append(this.destTermId).append(",");
        buffer.append("msgContent=").append(this.getMsgContent()).append("]");
        return buffer.toString();
    }

    @Override
    public SMGPDeliverMessage clone() throws CloneNotSupportedException {
        return (SMGPDeliverMessage)super.clone();
    }

    @Override
    public LongMessageFrame generateFrame() {
        LongMessageFrame frame = new LongMessageFrame();
        frame.setTppid(this.getTpPid());
        frame.setTpudhi(this.getTpUdhi());
        frame.setMsgfmt(this.getMsgFmt());
        frame.setMsgContentBytes(this.getBMsgContent());
        frame.setMsgLength((short)this.bMsgContent.length);
        frame.setSequence(this.getSequenceNo());
        return frame;
    }

    @Override
    public SMGPDeliverMessage generateMessage(LongMessageFrame frame) throws Exception {
        SMGPDeliverMessage requestMessage = this.clone();
        requestMessage.setTpUdhi((byte)frame.getTpudhi());
        requestMessage.setMsgFmt((SMGPSmsDcs)frame.getMsgfmt());
        requestMessage.setBMsgContent(frame.getMsgContentBytes());
        if (frame.getPknumber() != 1) {
            requestMessage.setSequenceNo(DefaultSequenceNumberUtil.getSequenceNo());
            requestMessage.setMsgId(new MsgId());
        }
        requestMessage.setMsgContent((SmsMessage)null);
        return requestMessage;
    }

    @Override
    public List<SMGPDeliverMessage> getFragments() {
        return this.fragments;
    }

    @Override
    public void addFragment(SMGPDeliverMessage fragment) {
        if (this.fragments == null) {
            this.fragments = new ArrayList<SMGPDeliverMessage>();
        }
        this.fragments.add(fragment);
    }

    @Override
    public UniqueLongMsgId getUniqueLongMsgId() {
        return super.getUniqueLongMsgId();
    }

    @Override
    public void setUniqueLongMsgId(UniqueLongMsgId id) {
        super.setUniqueLongMsgId(id);
    }

    @Override
    public boolean needHandleLongMessage() {
        return !this.isReport();
    }

    @Override
    public String getSrcIdAndDestId() {
        return this.getSrcTermId() + this.getDestTermId();
    }
}

