/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smgp.msg;

import com.zx.sms.codec.smgp.msg.SMGPBaseMessage;
import com.zx.sms.codec.smgp.util.ByteUtil;

public class SMGPLoginMessage
extends SMGPBaseMessage {
    private static final long serialVersionUID = -2752058312140181133L;
    private String clientId;
    private byte[] clientAuth = new byte[16];
    private byte loginMode;
    private byte version;

    public SMGPLoginMessage() {
        this.commandId = 1;
    }

    @Override
    protected int setBody(byte[] bodyBytes, int version) throws Exception {
        int offset = 0;
        byte[] tmp = null;
        tmp = new byte[8];
        System.arraycopy(bodyBytes, offset, tmp, 0, 8);
        this.clientId = new String(ByteUtil.rtrimBytes(tmp));
        System.arraycopy(bodyBytes, offset += 8, this.clientAuth, 0, 16);
        this.loginMode = bodyBytes[offset += 16];
        this.setTimestamp(ByteUtil.byte2int(bodyBytes, ++offset));
        this.version = bodyBytes[offset += 4];
        return ++offset;
    }

    @Override
    protected byte[] getBody(int version) throws Exception {
        int len = 30;
        int offset = 0;
        byte[] bodyBytes = new byte[len];
        ByteUtil.rfillBytes(this.clientId.getBytes(), 8, bodyBytes, offset);
        System.arraycopy(this.clientAuth, 0, bodyBytes, offset += 8, 16);
        bodyBytes[offset += 16] = this.loginMode;
        ByteUtil.int2byte((int)this.getTimestamp(), bodyBytes, ++offset);
        bodyBytes[offset += 4] = this.version;
        ++offset;
        return bodyBytes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public byte[] getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(byte[] clientAuth) {
        this.clientAuth = clientAuth;
    }

    public byte getLoginMode() {
        return this.loginMode;
    }

    public void setLoginMode(byte loginMode) {
        this.loginMode = loginMode;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SMGPLoginMessage:[sequenceNumber=").append(this.sequenceString()).append(",");
        buffer.append("clientId=").append(this.clientId).append(",");
        buffer.append("loginMode=").append(this.loginMode).append(",");
        buffer.append("timestamp=").append(this.getTimestamp()).append(",");
        buffer.append("version=").append(this.version).append("]");
        return buffer.toString();
    }
}

