/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smgp.msg;

import com.google.common.base.CharMatcher;
import com.zx.sms.codec.smgp.msg.MsgId;
import com.zx.sms.codec.smgp.util.ByteUtil;
import com.zx.sms.codec.smgp.util.SMGPMsgIdUtil;
import com.zx.sms.common.util.StandardCharsets;
import java.io.Serializable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMGPReportData
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(SMGPReportData.class);
    public static final int LENGTH = 66 + "id: sub: dlvrd: submit date: done date: stat: err: text:".length();
    private MsgId msgId;
    private String sub = "001";
    private String dlvrd = "001";
    private String subTime;
    private String doneTime;
    private String stat;
    private String err = "";
    private String txt = "";

    public boolean fromBytes(byte[] bytes) throws Exception {
        try {
            int offset = 0;
            byte[] tmp = null;
            byte[] msgId = new byte[10];
            System.arraycopy(bytes, offset += "id:".length(), msgId, 0, 10);
            this.msgId = SMGPMsgIdUtil.bytes2MsgId(msgId);
            offset += 10;
            tmp = new byte[3];
            System.arraycopy(bytes, offset += " sub:".length(), tmp, 0, 3);
            this.sub = new String(ByteUtil.rtrimBytes(tmp));
            offset += 3;
            tmp = new byte[3];
            System.arraycopy(bytes, offset += " dlvrd:".length(), tmp, 0, 3);
            this.dlvrd = new String(ByteUtil.rtrimBytes(tmp));
            offset += 3;
            tmp = new byte[10];
            System.arraycopy(bytes, offset += " submit date:".length(), tmp, 0, 10);
            this.subTime = new String(ByteUtil.rtrimBytes(tmp));
            offset += 10;
            tmp = new byte[10];
            System.arraycopy(bytes, offset += " done date:".length(), tmp, 0, 10);
            this.doneTime = new String(ByteUtil.rtrimBytes(tmp));
            offset += 10;
            tmp = new byte[7];
            System.arraycopy(bytes, offset += " stat:".length(), tmp, 0, 7);
            this.stat = new String(ByteUtil.rtrimBytes(tmp));
            offset += 7;
            tmp = new byte[3];
            System.arraycopy(bytes, offset += " err:".length(), tmp, 0, 3);
            this.err = new String(ByteUtil.rtrimBytes(tmp));
            offset += 3;
            tmp = new byte[20];
            System.arraycopy(bytes, offset += " text:".length(), tmp, 0, bytes.length - offset);
            byte[] text_length = new byte[]{tmp[0], tmp[1], tmp[2]};
            String t_text_length = StringUtils.trim((String)new String(text_length, StandardCharsets.US_ASCII));
            if (tmp[0] > 0 && tmp[1] > 0 && tmp[2] > 0 && this.isAllOfASCII(text_length) && StringUtils.isNumeric((CharSequence)t_text_length)) {
                byte[] t_text_txt = new byte[17];
                System.arraycopy(bytes, offset + 3, t_text_txt, 0, 17);
                this.txt = this.isAllOfASCII(t_text_txt) ? t_text_length + new String(ByteUtil.rtrimBytes(t_text_txt), StandardCharsets.US_ASCII) : t_text_length + new String(ByteUtil.rtrimBytes(t_text_txt), StandardCharsets.UTF_16BE);
            } else {
                this.txt = this.isAllOfASCII(tmp) ? new String(ByteUtil.rtrimBytes(tmp), StandardCharsets.US_ASCII) : new String(ByteUtil.rtrimBytes(tmp), StandardCharsets.UTF_16BE);
            }
            offset += 20;
            return true;
        }
        catch (Exception ex) {
            logger.warn("parse data err length:{} ; 0x{}", (Object)bytes.length, (Object)Hex.encodeHexString((byte[])bytes));
            return true;
        }
    }

    private boolean isAllOfASCII(byte[] seq) {
        for (byte b : seq) {
            if (b >= 0 && b <= 127) continue;
            return false;
        }
        return true;
    }

    public byte[] toBytes() throws Exception {
        byte[] tmp;
        int offset = 0;
        byte[] bytes = new byte[LENGTH];
        System.arraycopy("id:".getBytes(), 0, bytes, offset, "id:".length());
        byte[] b_msgId = SMGPMsgIdUtil.msgId2Bytes(this.msgId);
        System.arraycopy(b_msgId, 0, bytes, offset += "id:".length(), 10);
        System.arraycopy(" sub:".getBytes(), 0, bytes, offset += 10, " sub:".length());
        ByteUtil.rfillBytes(this.sub.getBytes(), 3, bytes, offset += " sub:".length());
        System.arraycopy(" dlvrd:".getBytes(), 0, bytes, offset += 3, " dlvrd:".length());
        ByteUtil.rfillBytes(this.dlvrd.getBytes(), 3, bytes, offset += " dlvrd:".length());
        System.arraycopy(" submit date:".getBytes(), 0, bytes, offset += 3, " submit date:".length());
        ByteUtil.rfillBytes(this.subTime.getBytes(), 10, bytes, offset += " submit date:".length());
        System.arraycopy(" done date:".getBytes(), 0, bytes, offset += 10, " done date:".length());
        ByteUtil.rfillBytes(this.doneTime.getBytes(), 10, bytes, offset += " done date:".length());
        System.arraycopy(" stat:".getBytes(), 0, bytes, offset += 10, " stat:".length());
        ByteUtil.rfillBytes(this.stat.getBytes(), 7, bytes, offset += " stat:".length());
        System.arraycopy(" err:".getBytes(), 0, bytes, offset += 7, " err:".length());
        ByteUtil.rfillBytes(this.err.getBytes(), 3, bytes, offset += " err:".length());
        System.arraycopy(" text:".getBytes(), 0, bytes, offset += 3, " text:".length());
        offset += " text:".length();
        if (StringUtils.isNotBlank((CharSequence)this.txt) && this.txt.length() > 3 && this.isAllOfASCII(this.txt.substring(0, 3).getBytes()) && StringUtils.isNumeric((CharSequence)this.txt.substring(0, 3))) {
            ByteUtil.rfillBytes(this.txt.substring(0, 3).getBytes(), 3, bytes, offset);
            String txt_content = this.txt.substring(3);
            if (CharMatcher.ASCII.matchesAllOf((CharSequence)txt_content)) {
                byte[] tmp2 = txt_content.getBytes(StandardCharsets.US_ASCII);
                ByteUtil.rfillBytes(tmp2, 17, bytes, offset + 3);
            } else {
                byte[] tmp3 = txt_content.getBytes(StandardCharsets.UTF_16BE);
                ByteUtil.rfillBytes(tmp3, 17, bytes, offset + 3);
            }
        } else if (CharMatcher.ASCII.matchesAllOf((CharSequence)this.txt)) {
            tmp = this.txt.getBytes(StandardCharsets.US_ASCII);
            ByteUtil.rfillBytes(tmp, 20, bytes, offset);
        } else {
            tmp = this.txt.getBytes(StandardCharsets.UTF_16BE);
            ByteUtil.rfillBytes(tmp, 20, bytes, offset);
        }
        offset += 20;
        return bytes;
    }

    public String getDlvrd() {
        return this.dlvrd;
    }

    public void setDlvrd(String dlvrd) {
        this.dlvrd = dlvrd;
    }

    public String getDoneTime() {
        return this.doneTime;
    }

    public void setDoneTime(String doneTime) {
        this.doneTime = doneTime;
    }

    public String getErr() {
        return this.err;
    }

    public void setErr(String err) {
        this.err = err;
    }

    public MsgId getMsgId() {
        return this.msgId;
    }

    public void setMsgId(MsgId msgId) {
        this.msgId = msgId;
    }

    public String getStat() {
        return this.stat;
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public String getSubTime() {
        return this.subTime;
    }

    public void setSubTime(String subTime) {
        this.subTime = subTime;
    }

    public String getTxt() {
        return this.txt;
    }

    public void setTxt(String txt) {
        this.txt = txt == null ? "" : txt;
    }

    private String msgIdString() {
        return this.msgId.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{msgId=").append(this.msgIdString()).append(",").append("sub=").append(this.sub).append(",").append("dlvrd=").append(this.dlvrd).append(",").append("subTime=").append(this.subTime).append(",").append("doneTime=").append(this.doneTime).append(",").append("stat=").append(this.stat).append(",").append("err=").append(this.err).append(",").append("text=").append(this.txt).append("}");
        return buffer.toString();
    }
}

