/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp;

import com.zx.sms.codec.smpp.RecoverablePduException;
import com.zx.sms.codec.smpp.UnrecoverablePduException;
import com.zx.sms.common.util.ByteBufUtil;
import com.zx.sms.common.util.PduUtil;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import org.apache.commons.codec.binary.Hex;

public class Address
implements Serializable {
    private byte ton;
    private byte npi;
    private String address;

    public Address() {
        this(0, 0, null);
    }

    public Address(byte ton, byte npi, String address) {
        this.ton = ton;
        this.npi = npi;
        this.address = address;
    }

    public byte getTon() {
        return this.ton;
    }

    public void setTon(byte value) {
        this.ton = value;
    }

    public byte getNpi() {
        return this.npi;
    }

    public void setNpi(byte value) {
        this.npi = value;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) {
        this.address = value;
    }

    public int calculateByteSize() {
        return 2 + PduUtil.calculateByteSizeOfNullTerminatedString(this.address);
    }

    public void read(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.ton = buffer.readByte();
        this.npi = buffer.readByte();
        this.address = ByteBufUtil.readNullTerminatedString(buffer);
    }

    public void write(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        buffer.writeByte((int)this.ton);
        buffer.writeByte((int)this.npi);
        ByteBufUtil.writeNullTerminatedString(buffer, this.address);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(40);
        buffer.append("0x");
        buffer.append(Hex.encodeHexString((byte[])new byte[]{this.ton}));
        buffer.append(" 0x");
        buffer.append(Hex.encodeHexString((byte[])new byte[]{this.npi}));
        buffer.append(" [");
        buffer.append(this.address);
        buffer.append("]");
        return buffer.toString();
    }
}

