/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp;

import com.zx.sms.codec.smpp.NotEnoughDataInBufferException;
import com.zx.sms.codec.smpp.PduTranscoder;
import com.zx.sms.codec.smpp.PduTranscoderContext;
import com.zx.sms.codec.smpp.RecoverablePduException;
import com.zx.sms.codec.smpp.UnknownCommandIdException;
import com.zx.sms.codec.smpp.UnrecoverablePduException;
import com.zx.sms.codec.smpp.msg.AlertNotification;
import com.zx.sms.codec.smpp.msg.BindReceiver;
import com.zx.sms.codec.smpp.msg.BindReceiverResp;
import com.zx.sms.codec.smpp.msg.BindTransceiver;
import com.zx.sms.codec.smpp.msg.BindTransceiverResp;
import com.zx.sms.codec.smpp.msg.BindTransmitter;
import com.zx.sms.codec.smpp.msg.BindTransmitterResp;
import com.zx.sms.codec.smpp.msg.CancelSm;
import com.zx.sms.codec.smpp.msg.CancelSmResp;
import com.zx.sms.codec.smpp.msg.DataSm;
import com.zx.sms.codec.smpp.msg.DataSmResp;
import com.zx.sms.codec.smpp.msg.DeliverSm;
import com.zx.sms.codec.smpp.msg.DeliverSmResp;
import com.zx.sms.codec.smpp.msg.EnquireLink;
import com.zx.sms.codec.smpp.msg.EnquireLinkResp;
import com.zx.sms.codec.smpp.msg.GenericNack;
import com.zx.sms.codec.smpp.msg.PartialPdu;
import com.zx.sms.codec.smpp.msg.PartialPduResp;
import com.zx.sms.codec.smpp.msg.Pdu;
import com.zx.sms.codec.smpp.msg.PduResponse;
import com.zx.sms.codec.smpp.msg.QuerySm;
import com.zx.sms.codec.smpp.msg.QuerySmResp;
import com.zx.sms.codec.smpp.msg.ReplaceSm;
import com.zx.sms.codec.smpp.msg.ReplaceSmResp;
import com.zx.sms.codec.smpp.msg.SubmitSm;
import com.zx.sms.codec.smpp.msg.SubmitSmResp;
import com.zx.sms.codec.smpp.msg.Unbind;
import com.zx.sms.codec.smpp.msg.UnbindResp;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.common.util.HexUtil;
import com.zx.sms.common.util.PduUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

public class DefaultPduTranscoder
implements PduTranscoder {
    private final PduTranscoderContext context;

    public DefaultPduTranscoder(PduTranscoderContext context) {
        this.context = context;
    }

    @Override
    public ByteBuf encode(Pdu pdu, ByteBufAllocator allocator) throws UnrecoverablePduException, RecoverablePduException {
        PduResponse response;
        if (pdu instanceof PduResponse && (response = (PduResponse)pdu).getResultMessage() == null) {
            response.setResultMessage(this.context.lookupResultMessage(pdu.getCommandStatus()));
        }
        if (!pdu.hasCommandLengthCalculated()) {
            pdu.calculateAndSetCommandLength();
        }
        if (!pdu.hasSequenceNumberAssigned()) {
            pdu.setSequenceNumber(DefaultSequenceNumberUtil.getSequenceNo());
        }
        ByteBuf buffer = allocator.buffer(pdu.getCommandLength());
        buffer.writeInt(pdu.getCommandLength());
        buffer.writeInt(pdu.getCommandId());
        buffer.writeInt(pdu.getCommandStatus());
        buffer.writeInt(pdu.getSequenceNumber());
        pdu.writeBody(buffer);
        pdu.writeOptionalParameters(buffer, this.context);
        if (buffer.readableBytes() != pdu.getCommandLength()) {
            throw new NotEnoughDataInBufferException("During PDU encoding the expected commandLength did not match the actual encoded (a serious error with our own encoding process)", pdu.getCommandLength(), buffer.readableBytes());
        }
        return buffer;
    }

    @Override
    public Pdu decode(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        if (buffer.readableBytes() < 4) {
            return null;
        }
        int commandLength = buffer.getInt(buffer.readerIndex());
        if (commandLength < 16) {
            throw new UnrecoverablePduException("Invalid PDU length [0x" + HexUtil.toHexString(commandLength) + "] parsed");
        }
        if (buffer.readableBytes() < commandLength) {
            return null;
        }
        ByteBuf buffer0 = buffer.readSlice(commandLength);
        return this.doDecode(commandLength, buffer0);
    }

    protected Pdu doDecode(int commandLength, ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        buffer.skipBytes(4);
        int commandId = buffer.readInt();
        int commandStatus = buffer.readInt();
        int sequenceNumber = buffer.readInt();
        Pdu pdu = null;
        pdu = PduUtil.isRequestCommandId(commandId) ? (commandId == 21 ? new EnquireLink() : (commandId == 5 ? new DeliverSm() : (commandId == 4 ? new SubmitSm() : (commandId == 259 ? new DataSm() : (commandId == 8 ? new CancelSm() : (commandId == 3 ? new QuerySm() : (commandId == 7 ? new ReplaceSm() : (commandId == 9 ? new BindTransceiver() : (commandId == 2 ? new BindTransmitter() : (commandId == 1 ? new BindReceiver() : (commandId == 6 ? new Unbind() : (commandId == 258 ? new AlertNotification() : new PartialPdu(commandId))))))))))))) : (commandId == -2147483644 ? new SubmitSmResp() : (commandId == -2147483643 ? new DeliverSmResp() : (commandId == -2147483389 ? new DataSmResp() : (commandId == -2147483640 ? new CancelSmResp() : (commandId == -2147483645 ? new QuerySmResp() : (commandId == -2147483641 ? new ReplaceSmResp() : (commandId == -2147483627 ? new EnquireLinkResp() : (commandId == -2147483639 ? new BindTransceiverResp() : (commandId == -2147483647 ? new BindReceiverResp() : (commandId == -2147483646 ? new BindTransmitterResp() : (commandId == -2147483642 ? new UnbindResp() : (commandId == Integer.MIN_VALUE ? new GenericNack() : new PartialPduResp(commandId)))))))))))));
        pdu.setCommandLength(commandLength);
        pdu.setCommandStatus(commandStatus);
        pdu.setSequenceNumber(sequenceNumber);
        if (pdu instanceof PartialPdu) {
            throw new UnknownCommandIdException(pdu, "Unsupported or unknown PDU request commandId [0x" + HexUtil.toHexString(commandId) + "]");
        }
        if (pdu instanceof PartialPduResp) {
            throw new UnknownCommandIdException(pdu, "Unsupported or unknown PDU response commandId [0x" + HexUtil.toHexString(commandId) + "]");
        }
        if (pdu instanceof PduResponse) {
            PduResponse response = (PduResponse)pdu;
            response.setResultMessage(this.context.lookupResultMessage(commandStatus));
        }
        try {
            ((Pdu)pdu).readBody(buffer);
            pdu.readOptionalParameters(buffer, this.context);
        }
        catch (RecoverablePduException e) {
            if (e.getPartialPdu() == null) {
                e.setPartialPdu(pdu);
            }
            throw e;
        }
        return pdu;
    }
}

