/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp;

import com.zx.sms.codec.smpp.Tlv;
import com.zx.sms.codec.smpp.msg.DeliverSm;
import com.zx.sms.codec.smpp.msg.DeliverSmReceipt;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;

public class DeliverSmReceiptCodec
extends MessageToMessageCodec<DeliverSm, DeliverSmReceipt> {
    DeliverSmReceiptCodec() {
    }

    protected void encode(ChannelHandlerContext ctx, DeliverSmReceipt msg, List<Object> out) throws Exception {
        DeliverSm pdu = new DeliverSm();
        pdu.setCommandStatus(msg.getCommandStatus());
        pdu.setSequenceNumber(msg.getSequenceNumber());
        pdu.setServiceType(msg.getServiceType());
        pdu.setSourceAddress(msg.getSourceAddress());
        pdu.setDestAddress(msg.getDestAddress());
        pdu.setEsmClass(msg.getEsmClass());
        pdu.setProtocolId(msg.getProtocolId());
        pdu.setPriority(msg.getPriority());
        pdu.setScheduleDeliveryTime(msg.getScheduleDeliveryTime());
        pdu.setValidityPeriod(msg.getValidityPeriod());
        pdu.setRegisteredDelivery(msg.getRegisteredDelivery());
        pdu.setReplaceIfPresent(msg.getReplaceIfPresent());
        pdu.setDataCoding(msg.getDataCoding());
        pdu.setDefaultMsgId(msg.getDefaultMsgId());
        pdu.setShortMessage(msg.getShortMessage());
        pdu.setMsglength((short)msg.getShortMessage().length);
        if (msg.getOptionalParameters() != null) {
            for (Tlv tlv : msg.getOptionalParameters()) {
                pdu.addOptionalParameter(tlv);
            }
        }
        out.add(pdu);
    }

    protected void decode(ChannelHandlerContext ctx, DeliverSm msg, List<Object> out) throws Exception {
        if ((msg.getEsmClass() & 0x3C) == 4) {
            DeliverSmReceipt pdu = new DeliverSmReceipt();
            pdu.setCommandLength(msg.getCommandLength());
            pdu.setCommandStatus(msg.getCommandStatus());
            pdu.setSequenceNumber(msg.getSequenceNumber());
            pdu.setServiceType(msg.getServiceType());
            pdu.setSourceAddress(msg.getSourceAddress());
            pdu.setDestAddress(msg.getDestAddress());
            pdu.setEsmClass(msg.getEsmClass());
            pdu.setProtocolId(msg.getProtocolId());
            pdu.setPriority(msg.getPriority());
            pdu.setScheduleDeliveryTime(msg.getScheduleDeliveryTime());
            pdu.setValidityPeriod(msg.getValidityPeriod());
            pdu.setRegisteredDelivery(msg.getRegisteredDelivery());
            pdu.setReplaceIfPresent(msg.getReplaceIfPresent());
            pdu.setDataCoding(msg.getDataCoding());
            pdu.setDefaultMsgId(msg.getDefaultMsgId());
            pdu.setShortMessage(msg.getShortMessage());
            if (msg.getOptionalParameters() != null) {
                for (Tlv tlv : msg.getOptionalParameters()) {
                    pdu.addOptionalParameter(tlv);
                }
            }
            out.add(pdu);
        } else {
            out.add(msg);
        }
    }
}

