/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp;

import com.zx.sms.codec.smpp.DefaultPduTranscoder;
import com.zx.sms.codec.smpp.DefaultPduTranscoderContext;
import com.zx.sms.codec.smpp.DeliverSmReceiptCodec;
import com.zx.sms.codec.smpp.PduTranscoder;
import com.zx.sms.codec.smpp.msg.DeliverSm;
import com.zx.sms.codec.smpp.msg.DeliverSmReceipt;
import com.zx.sms.codec.smpp.msg.Pdu;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPMessageCodec
extends MessageToMessageCodec<ByteBuf, Pdu> {
    private static final PduTranscoder transcoder = new DefaultPduTranscoder(new DefaultPduTranscoderContext());
    private static final DeliverSmReceiptCodec reportcodec = new DeliverSmReceiptCodec();
    private final Logger logger = LoggerFactory.getLogger(SMPPMessageCodec.class);

    protected void encode(ChannelHandlerContext ctx, Pdu msg, List<Object> out) throws Exception {
        try {
            if (msg instanceof DeliverSmReceipt) {
                ArrayList<Object> deliout = new ArrayList<Object>(1);
                reportcodec.encode(ctx, (DeliverSmReceipt)msg, deliout);
                DeliverSm deli = (DeliverSm)deliout.get(0);
                ByteBuf buf = transcoder.encode(deli, ctx.alloc());
                out.add(buf);
            } else {
                ByteBuf buf = transcoder.encode(msg, ctx.alloc());
                out.add(buf);
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        try {
            Pdu pdu = transcoder.decode(msg);
            if (pdu != null) {
                if (pdu instanceof DeliverSm) {
                    DeliverSm deli = (DeliverSm)pdu;
                    reportcodec.decode(ctx, deli, out);
                } else {
                    out.add(pdu);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
    }
}

